/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.probekit.impl.sinks;

import com.ibm.json.java.JSONObject;
import com.ibm.neo.config.ConfigTree;
import com.ibm.neo.probekit.IEvent;
import com.ibm.neo.probekit.IProbe;
import com.ibm.neo.probekit.ISink;
import com.ibm.neo.probekit.ProbeKit;
import com.ibm.neo.probekit.ProbeSchema;
import com.ibm.neo.probekit.impl.sinks.JsonEventSerializer;
import com.ibm.neo.util.CyclicArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUdpSink
implements ISink {
    public static final String CONFIG_HOST = "host";
    public static final String CONFIG_PORT = "port";
    public static final String CONFIG_FLUSH_INTERVAL = "flush-interval";
    public static final String CONFIG_MAX_FLUSH_RATE = "max-flush-rate";
    public static final String CONFIG_MAX_MESSAGE_SIZE = "max-message-size";
    private static final long DEFAULT_FLUSH_INTERVAL = 1000L;
    private static final int DEFAULT_MAX_FLUSH_RATE = -1;
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 8000;
    private static Logger LOGGER = LoggerFactory.getLogger(JsonUdpSink.class);
    private final ConcurrentHashMap<String, WriteQueue> mProbeName2Queue = new ConcurrentHashMap();
    private String mName = null;
    private DatagramSocket mSock = null;
    private InetAddress mAddr = null;
    private int mPort = 0;
    private int mMaxMessageSize = 0;
    private int mMaxFlushRate = 0;
    private ScheduledFuture<?> mFlushFuture = null;
    private int mFlushErrorCount = 0;

    @Override
    public void initialize(ConfigTree.ConfigNode config, ScheduledExecutorService scheduler) throws Exception {
        this.mName = config.getName();
        this.mMaxFlushRate = config.getChildIntegerValue(CONFIG_MAX_FLUSH_RATE, Integer.valueOf(-1));
        String host = config.getChildStringValue(CONFIG_HOST, null);
        this.mAddr = null == host ? null : InetAddress.getByName(host);
        this.mPort = config.getChildIntegerValue(CONFIG_PORT, Integer.valueOf(-1));
        if (this.mPort <= 0 || this.mPort > Short.MAX_VALUE) {
            throw new IllegalArgumentException("A valid port number was not specified");
        }
        this.mMaxMessageSize = config.getChildIntegerValue(CONFIG_MAX_MESSAGE_SIZE, Integer.valueOf(8000));
        if (this.mMaxMessageSize < 8 || this.mMaxMessageSize > 65536) {
            throw new IllegalArgumentException("The maximum message size must be greater than 8 bytes and less than 64K bytes.");
        }
        long flushInterval = config.getChildLongValue(CONFIG_FLUSH_INTERVAL, Long.valueOf(1000L));
        if (flushInterval < 1L) {
            throw new IllegalArgumentException("Illegal flush interval: " + flushInterval);
        }
        this.mSock = new DatagramSocket();
        this.mFlushFuture = scheduler.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                JsonUdpSink.this.flush();
            }
        }, flushInterval, flushInterval, TimeUnit.MILLISECONDS);
        LOGGER.info("[ProbeKit] Initialized {} [host: {}, port: {}, flush-interval: {}, max-message-size: {}]", new Object[]{this.mName, host, this.mPort, flushInterval, this.mMaxMessageSize});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws Exception {
        this.mFlushFuture.cancel(false);
        try {
            this.flush();
        }
        finally {
            this.mSock.close();
        }
    }

    @Override
    public void write(IEvent event) throws Exception {
        IProbe probe = event.getProbe();
        ProbeSchema schema = probe.getSchema();
        WriteQueue queue = this.getOrCreateQueue(schema, probe.getConfig());
        if (null != queue) {
            queue.enqueue(event);
        }
    }

    private WriteQueue getOrCreateQueue(ProbeSchema schema, ConfigTree.ConfigNode config) {
        WriteQueue oldQueue;
        String probeName = schema.getName();
        WriteQueue queue = this.mProbeName2Queue.get(probeName);
        if (null == queue && null != (oldQueue = this.mProbeName2Queue.putIfAbsent(probeName, queue = new WriteQueue(this.getMaxFlushRate(config))))) {
            queue = oldQueue;
        }
        return queue;
    }

    protected void flush() {
        for (WriteQueue q : this.mProbeName2Queue.values()) {
            try {
                q.flush();
            }
            catch (Throwable t) {
                LOGGER.error("[ProbeKit] Unexpected error while flushing events", t);
            }
        }
    }

    private int getMaxFlushRate(ConfigTree.ConfigNode config) {
        return config.getChildIntegerValue(CONFIG_MAX_FLUSH_RATE, Integer.valueOf(this.mMaxFlushRate));
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.mName).append(CONFIG_HOST, (Object)this.mAddr).append(CONFIG_PORT, this.mPort).toString();
    }

    private final class WriteQueue {
        private final ConcurrentLinkedQueue<IEvent> mQueue = new ConcurrentLinkedQueue();
        private final CyclicArray<Long> mFlushCounts = new CyclicArray(10);
        private final CyclicArray<Long> mFlushTimes = new CyclicArray(10);
        private final int mMaxFlushRate;
        private final ByteArrayOutputStream mOutBuffer = new ByteArrayOutputStream(8096);
        private volatile long mLastFlushTime = System.nanoTime();
        private volatile double mLastFlushRate = 0.0;

        WriteQueue(int maxFlushRate) {
            this.mMaxFlushRate = maxFlushRate;
        }

        private double getFlushRate() {
            long totalCount = 0L;
            long totalNanos = 0L;
            for (int i = 0; i < this.mFlushCounts.capacity(); ++i) {
                Long count = (Long)this.mFlushCounts.get(i);
                Long nanos = (Long)this.mFlushTimes.get(i);
                if (null == count || null == nanos) continue;
                totalCount += count.longValue();
                totalNanos += nanos.longValue();
            }
            long totalSeconds = TimeUnit.NANOSECONDS.toSeconds(totalNanos);
            if (0L == totalSeconds) {
                return 0.0;
            }
            return (double)totalCount / (double)totalSeconds;
        }

        void enqueue(IEvent event) {
            if (this.mMaxFlushRate > 0 && this.mLastFlushRate > (double)this.mMaxFlushRate) {
                ProbeKit.getInstance().recordEventOverflow(event.getProbe());
            } else {
                this.mQueue.add(event);
            }
        }

        synchronized void flush() {
            IEvent event = this.mQueue.poll();
            long count = 0L;
            while (null != event) {
                block7: {
                    try {
                        byte[] eventData = this.serializeEvent(event);
                        if (eventData.length <= 0) break block7;
                        DatagramPacket packet = new DatagramPacket(eventData, eventData.length, JsonUdpSink.this.mAddr, JsonUdpSink.this.mPort);
                        try {
                            JsonUdpSink.this.mSock.send(packet);
                            JsonUdpSink.this.mFlushErrorCount = 0;
                        }
                        catch (IOException ex) {
                            if (ex.getMessage().contains("Message too long")) {
                                JsonUdpSink.this.mMaxMessageSize = Math.max(8, (int)Math.floor(0.9 * (double)eventData.length));
                                break block7;
                            }
                            throw ex;
                        }
                    }
                    catch (Exception ex) {
                        ++JsonUdpSink.this.mFlushErrorCount;
                        if (JsonUdpSink.this.mFlushErrorCount >= 10) break block7;
                        LOGGER.error("[ProbeKit] Unexpected error while flushing events", (Throwable)ex);
                    }
                }
                event = this.mQueue.poll();
                ++count;
            }
            if (this.mMaxFlushRate > 0) {
                long nanoTime = System.nanoTime();
                this.mFlushTimes.add((Object)(nanoTime - this.mLastFlushTime));
                this.mFlushCounts.add((Object)count);
                this.mLastFlushTime = nanoTime;
                this.mLastFlushRate = this.getFlushRate();
            }
        }

        private byte[] serializeEvent(IEvent event) throws IOException {
            block1: {
                JSONObject eventObj = JsonEventSerializer.serialize(event);
                do {
                    OutputStreamWriter writer = new OutputStreamWriter((OutputStream)this.mOutBuffer, "UTF-8");
                    this.mOutBuffer.reset();
                    eventObj.serialize((Writer)writer, false);
                    writer.append('\n');
                    writer.flush();
                    if (this.mOutBuffer.size() <= JsonUdpSink.this.mMaxMessageSize) break block1;
                } while (this.truncateEventObject(eventObj));
                return new byte[0];
            }
            return this.mOutBuffer.toByteArray();
        }

        private boolean truncateEventObject(JSONObject jobj) {
            int newLength;
            String maxKey = null;
            String maxValue = null;
            for (String key : jobj.keySet()) {
                Object value = jobj.get((Object)key);
                if (!(value instanceof String) || null != maxValue && ((String)value).length() <= maxValue.length()) continue;
                maxKey = key;
                maxValue = (String)value;
            }
            if (null != maxKey && maxValue.length() > 3 && (newLength = (int)Math.floor(0.9 * (double)maxValue.length())) > 3) {
                maxValue = StringUtils.abbreviate((String)maxValue, (int)newLength);
                jobj.put((Object)maxKey, (Object)maxValue);
                return true;
            }
            return false;
        }
    }
}

