/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.probekit.state;

import com.ibm.neo.probekit.state.DiagnosticState;
import com.ibm.neo.probekit.state.MutableDiagnosticState;

public abstract class DiagnosticStateContext {
    private static final ThreadLocal<MutableDiagnosticState> LOCAL_STATE = new ThreadLocal<MutableDiagnosticState>(){

        @Override
        protected MutableDiagnosticState initialValue() {
            return new MutableDiagnosticState();
        }
    };

    public static DiagnosticState getMutableState() {
        return LOCAL_STATE.get();
    }

    public static DiagnosticState getImmutableState() {
        return DiagnosticStateContext.getMutableState().immutable();
    }

    public static DiagnosticState getStateCopy() {
        return DiagnosticStateContext.getMutableState().copy();
    }

    public static void setState(DiagnosticState state) {
        if (null == state) {
            throw new IllegalArgumentException("state was null");
        }
        DiagnosticState localState = DiagnosticStateContext.getMutableState();
        localState.clear();
        localState.putAll(state);
    }

    public static void mergeState(DiagnosticState state) {
        if (null == state) {
            throw new IllegalArgumentException("state was null");
        }
        DiagnosticState localState = DiagnosticStateContext.getMutableState();
        localState.putAll(state);
    }

    public static void clearState() {
        DiagnosticState localState = DiagnosticStateContext.getMutableState();
        localState.clear();
    }
}

