/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.probekit.state;

import com.ibm.neo.probekit.state.DiagnosticState;
import com.ibm.neo.probekit.state.DiagnosticStateProducer;
import com.ibm.neo.probekit.state.MutableDiagnosticState;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class DynamicDiagnosticState {
    private static final ConcurrentLinkedQueue<DiagnosticStateProducer> PRODUCERS = new ConcurrentLinkedQueue();

    public static void addProducer(DiagnosticStateProducer producer) {
        PRODUCERS.add(producer);
    }

    public static void removeProducer(DiagnosticStateProducer producer) {
        PRODUCERS.remove(producer);
    }

    public static DiagnosticState produceAndMerge() {
        MutableDiagnosticState state = new MutableDiagnosticState();
        for (DiagnosticStateProducer producer : PRODUCERS) {
            DiagnosticState tmp = producer.produce();
            if (null == tmp) continue;
            state.putAll(tmp);
        }
        return state;
    }
}

