/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.asset.repository.requestoptions;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalRequestOption {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalRequestOption.class);
    private static final int MANUAL = -1;
    private final ThreadLocal<Integer> m_option = new ThreadLocal();
    private final String m_name;

    CalRequestOption(String _name) {
        this.m_name = _name;
    }

    public final void offForRequest() {
        this.m_option.set(0);
    }

    final void incrementForInternalRequest() {
        Integer set = this.m_option.get();
        if (set != null && set != -1) {
            set = set + 1;
            this.m_option.set(set);
        }
    }

    public final void off() {
        LOGGER.info("request option " + this.m_name + " set OFF");
        this.m_option.set(-1);
    }

    public final void reset() {
        LOGGER.info("request option " + this.m_name + " set ON");
        this.m_option.remove();
    }

    public final void resetForRequest() {
        Integer set = this.m_option.get();
        if (set == null) {
            return;
        }
        if (set > 0) {
            set = set - 1;
            this.m_option.set(set);
        }
        if (set == 0) {
            this.m_option.remove();
        }
    }

    public final boolean isOn() {
        return this.m_option.get() == null;
    }
}

