/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.identity;

import com.ibm.neo.security.identity.CapabilityInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DefaultRolesAndCapabilities {
    private static final Map<CapabilityInfo, Collection<CapabilityInfo>> DEFAULT_CAPS = new HashMap<CapabilityInfo, Collection<CapabilityInfo>>();
    private static final Map<String, Collection<CapabilityInfo>> DEFAULT_ROLES = new HashMap<String, Collection<CapabilityInfo>>();
    public static final String ROLE_ADMINISTRATOR = "administrator";
    public static final String ROLE_CREATOR = "creator";
    public static final String ROLE_CONTRIBUTOR = "contributor";
    public static final String ROLE_CONSUMER = "consumer";
    public static final CapabilityInfo ENABLED = new CapabilityInfo("ENABLED");
    public static final CapabilityInfo READ_WB = new CapabilityInfo("READ", "WORKBOOK");
    public static final CapabilityInfo CREATE_WB = new CapabilityInfo("CREATE", "WORKBOOK");
    public static final CapabilityInfo EDIT_WB = new CapabilityInfo("EDIT", "WORKBOOK");
    public static final CapabilityInfo MODIFY_WB = new CapabilityInfo("MODIFY", "WORKBOOK");
    public static final CapabilityInfo UPDATE_PERMISSIONS_WB = new CapabilityInfo("UPDATE_PERMISSIONS", "WORKBOOK");
    public static final CapabilityInfo SHARE_WB = new CapabilityInfo("SHARE", "WORKBOOK");
    public static final CapabilityInfo READ_DS = new CapabilityInfo("READ", "USER_DATASOURCE");
    public static final CapabilityInfo CREATE_DS = new CapabilityInfo("CREATE", "USER_DATASOURCE");
    public static final CapabilityInfo EDIT_DS = new CapabilityInfo("EDIT", "USER_DATASOURCE");
    public static final CapabilityInfo UPDATE_DS = new CapabilityInfo("UPDATE", "USER_DATASOURCE");
    public static final CapabilityInfo MODIFY_DS = new CapabilityInfo("MODIFY", "USER_DATASOURCE");
    public static final CapabilityInfo UPDATE_PERMISSIONS_DS = new CapabilityInfo("UPDATE_PERMISSIONS", "USER_DATASOURCE");
    public static final CapabilityInfo READ_FOLDER = new CapabilityInfo("READ", "FOLDER");
    public static final CapabilityInfo CREATE_FOLDER = new CapabilityInfo("CREATE", "FOLDER");
    public static final CapabilityInfo MODIFY_FOLDER = new CapabilityInfo("MODIFY", "FOLDER");
    public static final CapabilityInfo UPDATE_PERMISSIONS_FOLDER = new CapabilityInfo("UPDATE_PERMISSIONS", "FOLDER");
    public static final CapabilityInfo MANIPULATE_ROLES = new CapabilityInfo("MANIPULATE_ROLES");
    public static final CapabilityInfo ADMINISTRATE_CONTENT = new CapabilityInfo("ADMINISTRATE_CONTENT");

    public static Map<CapabilityInfo, Collection<CapabilityInfo>> getDefaultCapabilities() {
        return Collections.unmodifiableMap(DEFAULT_CAPS);
    }

    public static Map<String, Collection<CapabilityInfo>> getDefaultRoles() {
        return Collections.unmodifiableMap(DEFAULT_ROLES);
    }

    static {
        DEFAULT_CAPS.put(ENABLED, Arrays.asList(new CapabilityInfo[0]));
        DEFAULT_CAPS.put(READ_WB, Arrays.asList(ENABLED));
        DEFAULT_CAPS.put(CREATE_WB, Arrays.asList(ENABLED));
        DEFAULT_CAPS.put(EDIT_WB, Arrays.asList(ENABLED));
        DEFAULT_CAPS.put(MODIFY_WB, Arrays.asList(ENABLED));
        DEFAULT_CAPS.put(UPDATE_PERMISSIONS_WB, Arrays.asList(ENABLED));
        DEFAULT_CAPS.put(SHARE_WB, Arrays.asList(ENABLED));
        DEFAULT_CAPS.put(READ_DS, Arrays.asList(ENABLED));
        DEFAULT_CAPS.put(CREATE_DS, Arrays.asList(ENABLED));
        DEFAULT_CAPS.put(EDIT_DS, Arrays.asList(ENABLED));
        DEFAULT_CAPS.put(UPDATE_DS, Arrays.asList(ENABLED));
        DEFAULT_CAPS.put(MODIFY_DS, Arrays.asList(ENABLED));
        DEFAULT_CAPS.put(UPDATE_PERMISSIONS_DS, Arrays.asList(ENABLED));
        DEFAULT_CAPS.put(READ_FOLDER, Arrays.asList(ENABLED));
        DEFAULT_CAPS.put(CREATE_FOLDER, Arrays.asList(ENABLED));
        DEFAULT_CAPS.put(MODIFY_FOLDER, Arrays.asList(ENABLED));
        DEFAULT_CAPS.put(UPDATE_PERMISSIONS_FOLDER, Arrays.asList(ENABLED));
        DEFAULT_CAPS.put(ADMINISTRATE_CONTENT, Arrays.asList(ENABLED));
        DEFAULT_CAPS.put(MANIPULATE_ROLES, Arrays.asList(ENABLED));
        DEFAULT_ROLES.put(ROLE_CONSUMER, Arrays.asList(READ_WB, SHARE_WB, READ_DS, READ_FOLDER));
        DEFAULT_ROLES.put(ROLE_CONTRIBUTOR, Arrays.asList(READ_WB, CREATE_WB, EDIT_WB, SHARE_WB, MODIFY_WB, READ_DS, READ_FOLDER, CREATE_FOLDER, MODIFY_FOLDER, UPDATE_PERMISSIONS_FOLDER));
        DEFAULT_ROLES.put(ROLE_CREATOR, Arrays.asList(READ_WB, CREATE_WB, EDIT_WB, MODIFY_WB, UPDATE_PERMISSIONS_WB, SHARE_WB, READ_DS, CREATE_DS, EDIT_DS, UPDATE_DS, MODIFY_DS, UPDATE_PERMISSIONS_DS, READ_FOLDER, CREATE_FOLDER, MODIFY_FOLDER, UPDATE_PERMISSIONS_FOLDER));
        DEFAULT_ROLES.put(ROLE_ADMINISTRATOR, Arrays.asList(READ_WB, CREATE_WB, EDIT_WB, MODIFY_WB, UPDATE_PERMISSIONS_WB, SHARE_WB, READ_DS, CREATE_DS, EDIT_DS, UPDATE_DS, MODIFY_DS, UPDATE_PERMISSIONS_DS, READ_FOLDER, CREATE_FOLDER, MODIFY_FOLDER, UPDATE_PERMISSIONS_FOLDER, MANIPULATE_ROLES, ADMINISTRATE_CONTENT));
    }
}

