/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.identity;

import com.ibm.neo.security.identity.CapabilityService;
import com.ibm.neo.security.identity.Credentials;
import com.ibm.neo.security.identity.InvalidCredentials;
import com.ibm.neo.security.identity.InvalidToken;
import com.ibm.neo.security.identity.NewSessionListener;
import com.ibm.neo.security.identity.RoleAndCapabilityManipulator;
import com.ibm.neo.security.identity.SecurityToken;
import com.ibm.neo.security.identity.TenantRequired;
import com.ibm.neo.security.identity.TenantStateManipulator;
import com.ibm.neo.security.identity.TenantUserInfo;
import com.ibm.neo.security.identity.UserGroupManipulator;
import com.ibm.neo.security.persistence.GeneralPersistenceException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.servlet.http.HttpServletRequest;

public interface IdentityService {
    public static final String EVERYONE = "EVERYONE";

    public UserGroupManipulator userGroupManipulator();

    public RoleAndCapabilityManipulator roleAndCapabilityManipulator();

    public CapabilityService capabilityService();

    public TenantStateManipulator tenantStateManipulator();

    public SecurityToken logIn(HttpServletRequest var1, Credentials var2) throws TenantRequired, InvalidCredentials;

    public boolean logOut(HttpServletRequest var1);

    public void checkValidToken(SecurityToken var1) throws InvalidToken;

    public boolean isValidToken(SecurityToken var1);

    public HttpServletRequest getCurrentRequest(SecurityToken var1) throws InvalidToken;

    public Map<String, List<String>> getCurrentRequestHeaders(SecurityToken var1) throws InvalidToken;

    public TenantUserInfo userInfo(SecurityToken var1) throws InvalidToken;

    public String userId(SecurityToken var1) throws InvalidToken;

    public String tenantId(SecurityToken var1) throws InvalidToken;

    public Credentials requiredCredentials();

    public SecurityToken beginRequest(HttpServletRequest var1) throws InvalidToken;

    public void checkIsRequestingSudo(SecurityToken var1) throws InvalidToken;

    public void setIsRequestingSudo(SecurityToken var1, boolean var2) throws InvalidToken;

    public boolean canSudo(SecurityToken var1) throws GeneralPersistenceException, InvalidToken;

    public SecurityToken beginRequest(String var1) throws InvalidToken;

    public void endRequest(HttpServletRequest var1);

    public ExecutorService createThreadPool(ExecutorService var1);

    public boolean isHealthy();

    public void registerCapabilities(String[] var1);

    public List<String> identity(SecurityToken var1) throws GeneralPersistenceException, InvalidToken;

    public void registerNewSessionListener(NewSessionListener var1);

    public void unRegisterNewSessionListener(NewSessionListener var1);
}

