/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.crypto.service;

import com.ibm.neo.crypto.service.CryptoException;
import com.ibm.neo.crypto.service.CryptoService;
import com.ibm.neo.crypto.service.CryptoServiceFactory;
import com.ibm.neo.crypto.service.impl.CryptoServiceImpl;
import com.ibm.neo.crypto.service.spi.CryptoProvider;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCryptoServiceFactory
implements CryptoServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCryptoServiceFactory.class);
    public static final String PROVIDER_CONFIG_KEY = "neo.crypto.provider";

    @Override
    public CryptoService getInstance(Properties config) throws CryptoException {
        CryptoProvider provider = DefaultCryptoServiceFactory.loadCryptoProvider(config);
        return new CryptoServiceImpl(config, provider);
    }

    private static CryptoProvider loadCryptoProvider(Properties config) throws CryptoException {
        String clazzName = config.getProperty(PROVIDER_CONFIG_KEY);
        if (StringUtils.isEmpty((String)clazzName)) {
            LOGGER.warn("CryptoProvider was not configured - encryption is disabled! Please set the 'neo.crypto.provider' configuration provider.");
            return null;
        }
        LOGGER.info("Loading CryptoProvider implementation: {}", (Object)clazzName);
        try {
            Class<?> clazz = Class.forName(clazzName);
            return (CryptoProvider)clazz.newInstance();
        }
        catch (Exception ex) {
            LOGGER.error("Failed to load CryptoProvider implementation: " + clazzName, (Throwable)ex);
            throw new CryptoException("Unable to create CryptoProvider implementation: " + clazzName, ex);
        }
    }
}

