/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.crypto.service.impl;

import com.ibm.neo.crypto.service.CryptoException;
import com.ibm.neo.crypto.service.CryptoService;
import com.ibm.neo.crypto.service.impl.EncryptingCipherSessionInputStream;
import com.ibm.neo.crypto.service.spi.CryptoCipherSession;
import com.ibm.neo.crypto.service.spi.CryptoProvider;
import com.ibm.neo.security.ACSHelper;
import com.ibm.neo.security.shiro.WASubject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CryptoServiceImpl
implements CryptoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CryptoServiceImpl.class);
    private static final String CIPHER_SESSION_CACHE_KEY = "CryptoService.CipherSession";
    private final Properties config;
    private final CryptoProvider provider;
    private boolean enabled = false;

    public CryptoServiceImpl(Properties config, CryptoProvider provider) {
        this.config = config;
        this.provider = provider;
        this.enabled = null != provider;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private void checkEnabled() {
        if (!this.enabled) {
            throw new IllegalStateException("CryptoService was not enabled");
        }
    }

    @Override
    public byte[] encrypt(byte[] data) throws CryptoException {
        this.checkEnabled();
        ByteArrayOutputStream arrayOutStream = new ByteArrayOutputStream();
        OutputStream encryptingStream = this.encrypt(arrayOutStream);
        try {
            encryptingStream.write(data);
        }
        catch (IOException ex) {
            throw new CryptoException(ex);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)encryptingStream);
        }
        return arrayOutStream.toByteArray();
    }

    @Override
    public byte[] decrypt(byte[] data) throws CryptoException {
        this.checkEnabled();
        InputStream decryptingStream = this.decrypt(new ByteArrayInputStream(data));
        ByteArrayOutputStream arrayOutStream = new ByteArrayOutputStream();
        try {
            IOUtils.copy((InputStream)decryptingStream, (OutputStream)arrayOutStream);
        }
        catch (IOException ex) {
            throw new CryptoException(ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)decryptingStream);
        }
        return arrayOutStream.toByteArray();
    }

    @Override
    public OutputStream encrypt(OutputStream out) throws CryptoException {
        this.checkEnabled();
        CryptoCipherSession cipherSession = this.getOrCreateCipherSession();
        return cipherSession.encrypt(out);
    }

    @Override
    public InputStream encrypt(InputStream in) throws CryptoException {
        this.checkEnabled();
        CryptoCipherSession cipherSession = this.getOrCreateCipherSession();
        return new EncryptingCipherSessionInputStream(cipherSession, in);
    }

    @Override
    public InputStream decrypt(InputStream in) throws CryptoException {
        this.checkEnabled();
        CryptoCipherSession cipherSession = this.getOrCreateCipherSession();
        return cipherSession.decrypt(in);
    }

    private CryptoCipherSession getOrCreateCipherSession() throws CryptoException {
        Subject subject = ThreadContext.getSubject();
        if (subject instanceof WASubject) {
            WASubject waSubject = (WASubject)subject;
            CryptoCipherSession session = (CryptoCipherSession)waSubject.getAttribute(CIPHER_SESSION_CACHE_KEY);
            if (null == session) {
                LOGGER.trace("Creating new cipher session for WASubject");
                session = this.createCipherSession(waSubject);
                waSubject.setAttribute(CIPHER_SESSION_CACHE_KEY, (Object)session);
            } else {
                LOGGER.trace("Found existing cipher session cached in WASubject");
            }
            return session;
        }
        LOGGER.error("Cannot get a cipher session unless a WASubject is bound to current Thread");
        throw new CryptoException("Cannot get a cipher session unless a WASubject is bound to current Thread");
    }

    private CryptoCipherSession createCipherSession(WASubject subject) throws CryptoException {
        Map headers = ACSHelper.getHttpHeaders((Subject)subject);
        return this.provider.createCipherSession(this.config, headers);
    }
}

