/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.crypto.service.impl;

import com.ibm.neo.crypto.service.CryptoException;
import com.ibm.neo.crypto.service.spi.CryptoCipherSession;
import com.ibm.neo.io.ByteBufferOutputStream;
import com.ibm.neo.io.TransformingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class EncryptingCipherSessionInputStream
extends TransformingInputStream {
    private static final int INPUT_BUFFER_SIZE = 16384;
    private static final int OUTPUT_BUFFER_SIZE = 32768;
    private static final int ENCRYPT_BUFFER_SIZE = 8192;

    EncryptingCipherSessionInputStream(CryptoCipherSession cipherSession, InputStream source) throws CryptoException {
        super(source, (TransformingInputStream.ITransformer)new EncryptingTransformer(cipherSession), 16384, 32768);
    }

    private static final class EncryptingTransformer
    implements TransformingInputStream.ITransformer {
        private final ByteBufferOutputStream mBufOut = new ByteBufferOutputStream(8192);
        private final OutputStream mEncryptOut;
        private final byte[] mCopyBuf = new byte[8192];
        private boolean mFinished = false;

        public EncryptingTransformer(CryptoCipherSession cipherSession) throws CryptoException {
            this.mEncryptOut = cipherSession.encrypt((OutputStream)this.mBufOut);
        }

        public TransformingInputStream.ETransformResult transform(ByteBuffer input, ByteBuffer output, boolean endOfInput) throws IOException {
            if (!output.hasRemaining()) {
                return TransformingInputStream.ETransformResult.OVERFLOW;
            }
            int bytesToCopy = Math.min(this.mCopyBuf.length, input.remaining());
            while (bytesToCopy > 0) {
                input.get(this.mCopyBuf, 0, bytesToCopy);
                this.mEncryptOut.write(this.mCopyBuf, 0, bytesToCopy);
                if (this.mBufOut.size() >= output.remaining()) break;
                bytesToCopy = Math.min(this.mCopyBuf.length, input.remaining());
            }
            if (endOfInput) {
                this.mEncryptOut.flush();
            }
            this.mBufOut.transferTo(output);
            if (!output.hasRemaining()) {
                return TransformingInputStream.ETransformResult.OVERFLOW;
            }
            return TransformingInputStream.ETransformResult.UNDERFLOW;
        }

        public TransformingInputStream.ETransformResult flush(ByteBuffer output) throws IOException {
            if (!this.mFinished) {
                this.mEncryptOut.close();
                this.mFinished = true;
            }
            this.mBufOut.transferTo(output);
            if (!output.hasRemaining()) {
                return TransformingInputStream.ETransformResult.OVERFLOW;
            }
            return TransformingInputStream.ETransformResult.UNDERFLOW;
        }

        public void close() throws IOException {
            if (!this.mFinished) {
                this.mEncryptOut.close();
            }
        }
    }
}

