/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.codec;

import org.apache.parquet.hadoop.codec.CompressionCodecNotSupportedException;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.mapred.FileOutputFormat;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class CodecConfig {
    private static final Logger LOG = LoggerFactory.getLogger(CodecConfig.class);

    public abstract boolean isHadoopCompressionSet();

    public abstract Class getHadoopOutputCompressorClass(Class var1);

    public abstract Configuration getConfiguration();

    public static CodecConfig from(JobConf jobConf) {
        return new MapredCodecConfig(jobConf);
    }

    public static CodecConfig from(TaskAttemptContext context) {
        return new MapreduceCodecConfig(context);
    }

    public static boolean isParquetCompressionSet(Configuration conf) {
        return conf.get("parquet.compression") != null;
    }

    public static CompressionCodecName getParquetCompressionCodec(Configuration configuration) {
        return CompressionCodecName.fromConf(configuration.get("parquet.compression", CompressionCodecName.UNCOMPRESSED.name()));
    }

    public CompressionCodecName getCodec() {
        CompressionCodecName codec;
        Configuration configuration = this.getConfiguration();
        if (CodecConfig.isParquetCompressionSet(configuration)) {
            codec = CodecConfig.getParquetCompressionCodec(configuration);
        } else if (this.isHadoopCompressionSet()) {
            codec = this.getHadoopCompressionCodec();
        } else {
            LOG.info("Compression set to false");
            codec = CompressionCodecName.UNCOMPRESSED;
        }
        LOG.info("Compression: {}", (Object)codec.name());
        return codec;
    }

    private CompressionCodecName getHadoopCompressionCodec() {
        CompressionCodecName codec;
        try {
            Class codecClass = this.getHadoopOutputCompressorClass(CompressionCodecName.UNCOMPRESSED.getHadoopCompressionCodecClass());
            LOG.info("Compression set through hadoop codec: {}", (Object)codecClass.getName());
            codec = CompressionCodecName.fromCompressionCodec(codecClass);
        }
        catch (CompressionCodecNotSupportedException e) {
            LOG.warn("codec defined in hadoop config is not supported by parquet [{}] and will use UNCOMPRESSED", (Object)e.getCodecClass().getName(), (Object)e);
            codec = CompressionCodecName.UNCOMPRESSED;
        }
        catch (IllegalArgumentException e) {
            LOG.warn("codec class not found: {}", (Object)e.getMessage(), (Object)e);
            codec = CompressionCodecName.UNCOMPRESSED;
        }
        return codec;
    }

    private static class MapredCodecConfig
    extends CodecConfig {
        private final JobConf conf;

        public MapredCodecConfig(JobConf conf) {
            this.conf = conf;
        }

        @Override
        public boolean isHadoopCompressionSet() {
            return FileOutputFormat.getCompressOutput(this.conf);
        }

        @Override
        public Class getHadoopOutputCompressorClass(Class defaultCodec) {
            return FileOutputFormat.getOutputCompressorClass(this.conf, defaultCodec);
        }

        @Override
        public Configuration getConfiguration() {
            return this.conf;
        }
    }

    private static class MapreduceCodecConfig
    extends CodecConfig {
        private final TaskAttemptContext context;

        public MapreduceCodecConfig(TaskAttemptContext context) {
            this.context = context;
        }

        @Override
        public boolean isHadoopCompressionSet() {
            return shaded.org.apache.hadoop.mapreduce.lib.output.FileOutputFormat.getCompressOutput(this.context);
        }

        @Override
        public Class getHadoopOutputCompressorClass(Class defaultCodec) {
            return shaded.org.apache.hadoop.mapreduce.lib.output.FileOutputFormat.getOutputCompressorClass(this.context, defaultCodec);
        }

        @Override
        public Configuration getConfiguration() {
            return ContextUtil.getConfiguration(this.context);
        }
    }
}

