/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.fs;

import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.fs.BlockLocation;
import shaded.org.apache.hadoop.fs.FileStatus;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.fs.permission.FsPermission;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class LocatedFileStatus
extends FileStatus {
    private BlockLocation[] locations;

    public LocatedFileStatus() {
    }

    public LocatedFileStatus(FileStatus stat, BlockLocation[] locations) throws IOException {
        this(stat.getLen(), stat.isDirectory(), stat.getReplication(), stat.getBlockSize(), stat.getModificationTime(), stat.getAccessTime(), stat.getPermission(), stat.getOwner(), stat.getGroup(), null, stat.getPath(), locations);
        if (stat.isSymlink()) {
            this.setSymlink(stat.getSymlink());
        }
    }

    public LocatedFileStatus(long length, boolean isdir, int block_replication, long blocksize, long modification_time, long access_time, FsPermission permission, String owner, String group, Path symlink, Path path, BlockLocation[] locations) {
        super(length, isdir, block_replication, blocksize, modification_time, access_time, permission, owner, group, symlink, path);
        this.locations = locations;
    }

    public BlockLocation[] getBlockLocations() {
        return this.locations;
    }

    @Override
    public int compareTo(FileStatus o) {
        return super.compareTo(o);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

