/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.fs.shell;

import java.io.IOException;
import java.util.LinkedList;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.fs.PathIOException;
import shaded.org.apache.hadoop.fs.PathIsDirectoryException;
import shaded.org.apache.hadoop.fs.PathNotFoundException;
import shaded.org.apache.hadoop.fs.shell.CommandFactory;
import shaded.org.apache.hadoop.fs.shell.CommandFormat;
import shaded.org.apache.hadoop.fs.shell.FsCommand;
import shaded.org.apache.hadoop.fs.shell.PathData;

@InterfaceAudience.Private
@InterfaceStability.Unstable
class Touch
extends FsCommand {
    Touch() {
    }

    public static void registerCommands(CommandFactory factory) {
        factory.addClass(Touchz.class, "-touchz");
    }

    public static class Touchz
    extends Touch {
        public static final String NAME = "touchz";
        public static final String USAGE = "<path> ...";
        public static final String DESCRIPTION = "Creates a file of zero length at <path> with current time as the timestamp of that <path>. An error is returned if the file exists with non-zero length\n";

        @Override
        protected void processOptions(LinkedList<String> args) {
            CommandFormat cf = new CommandFormat(1, Integer.MAX_VALUE, new String[0]);
            cf.parse(args);
        }

        @Override
        protected void processPath(PathData item) throws IOException {
            if (item.stat.isDirectory()) {
                throw new PathIsDirectoryException(item.toString());
            }
            if (item.stat.getLen() != 0L) {
                throw new PathIOException(item.toString(), "Not a zero-length file");
            }
            this.touchz(item);
        }

        @Override
        protected void processNonexistentPath(PathData item) throws IOException {
            if (!item.parentExists()) {
                throw new PathNotFoundException(item.toString()).withFullyQualifiedPath(item.path.toUri().toString());
            }
            this.touchz(item);
        }

        private void touchz(PathData item) throws IOException {
            item.fs.create(item.path).close();
        }
    }
}

