/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.fs.shell.find;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.shell.find.Expression;
import shaded.org.apache.hadoop.util.ReflectionUtils;
import shaded.org.apache.hadoop.util.StringUtils;

final class ExpressionFactory {
    private static final String REGISTER_EXPRESSION_METHOD = "registerExpression";
    private Map<String, Class<? extends Expression>> expressionMap = new HashMap<String, Class<? extends Expression>>();
    private static final ExpressionFactory INSTANCE = new ExpressionFactory();

    static ExpressionFactory getExpressionFactory() {
        return INSTANCE;
    }

    private ExpressionFactory() {
    }

    void registerExpression(Class<? extends Expression> expressionClass) {
        try {
            Method register = expressionClass.getMethod(REGISTER_EXPRESSION_METHOD, ExpressionFactory.class);
            if (register != null) {
                register.invoke(null, this);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(StringUtils.stringifyException(e));
        }
    }

    void addClass(Class<? extends Expression> expressionClass, String ... names) throws IOException {
        for (String name : names) {
            this.expressionMap.put(name, expressionClass);
        }
    }

    boolean isExpression(String expressionName) {
        return this.expressionMap.containsKey(expressionName);
    }

    Expression getExpression(String expressionName, Configuration conf) {
        if (conf == null) {
            throw new NullPointerException("configuration is null");
        }
        Class<? extends Expression> expressionClass = this.expressionMap.get(expressionName);
        Expression instance = this.createExpression(expressionClass, conf);
        return instance;
    }

    Expression createExpression(Class<? extends Expression> expressionClass, Configuration conf) {
        Expression instance = null;
        if (expressionClass != null) {
            instance = ReflectionUtils.newInstance(expressionClass, conf);
        }
        return instance;
    }

    Expression createExpression(String expressionClassname, Configuration conf) {
        try {
            Class<Expression> expressionClass = Class.forName(expressionClassname).asSubclass(Expression.class);
            return this.createExpression(expressionClass, conf);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Invalid classname " + expressionClassname);
        }
    }
}

