/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.protocolPB;

import com.google.common.base.Optional;
import java.util.List;
import java.util.Map;
import shaded.org.apache.hadoop.conf.ReconfigurationTaskStatus;
import shaded.org.apache.hadoop.conf.ReconfigurationUtil;
import shaded.org.apache.hadoop.hdfs.protocol.proto.ReconfigurationProtocolProtos;

public final class ReconfigurationProtocolServerSideUtils {
    private ReconfigurationProtocolServerSideUtils() {
    }

    public static ReconfigurationProtocolProtos.ListReconfigurablePropertiesResponseProto listReconfigurableProperties(List<String> reconfigurableProperties) {
        ReconfigurationProtocolProtos.ListReconfigurablePropertiesResponseProto.Builder builder = ReconfigurationProtocolProtos.ListReconfigurablePropertiesResponseProto.newBuilder();
        builder.addAllName(reconfigurableProperties);
        return builder.build();
    }

    public static ReconfigurationProtocolProtos.GetReconfigurationStatusResponseProto getReconfigurationStatus(ReconfigurationTaskStatus status) {
        ReconfigurationProtocolProtos.GetReconfigurationStatusResponseProto.Builder builder = ReconfigurationProtocolProtos.GetReconfigurationStatusResponseProto.newBuilder();
        builder.setStartTime(status.getStartTime());
        if (status.stopped()) {
            builder.setEndTime(status.getEndTime());
            assert (status.getStatus() != null);
            for (Map.Entry<ReconfigurationUtil.PropertyChange, Optional<String>> result : status.getStatus().entrySet()) {
                ReconfigurationProtocolProtos.GetReconfigurationStatusConfigChangeProto.Builder changeBuilder = ReconfigurationProtocolProtos.GetReconfigurationStatusConfigChangeProto.newBuilder();
                ReconfigurationUtil.PropertyChange change = result.getKey();
                changeBuilder.setName(change.prop);
                changeBuilder.setOldValue(change.oldVal != null ? change.oldVal : "");
                if (change.newVal != null) {
                    changeBuilder.setNewValue(change.newVal);
                }
                if (result.getValue().isPresent()) {
                    changeBuilder.setErrorMessage((String)result.getValue().get());
                }
                builder.addChanges(changeBuilder);
            }
        }
        return builder.build();
    }
}

