/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.qjournal.client;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import shaded.org.apache.hadoop.util.StringUtils;

class QuorumException
extends IOException {
    private static final long serialVersionUID = 1L;

    public static <K, V> QuorumException create(String simpleMsg, Map<K, V> successes, Map<K, Throwable> exceptions) {
        Preconditions.checkArgument((!exceptions.isEmpty() ? 1 : 0) != 0, (Object)"Must pass exceptions");
        StringBuilder msg = new StringBuilder();
        msg.append(simpleMsg).append(". ");
        if (!successes.isEmpty()) {
            msg.append(successes.size()).append(" successful responses:\n");
            Joiner.on((String)"\n").useForNull("null [success]").withKeyValueSeparator(": ").appendTo(msg, successes);
            msg.append("\n");
        }
        msg.append(exceptions.size() + " exceptions thrown:\n");
        boolean isFirst = true;
        for (Map.Entry<K, Throwable> e : exceptions.entrySet()) {
            if (!isFirst) {
                msg.append("\n");
            }
            isFirst = false;
            msg.append(e.getKey()).append(": ");
            if (e.getValue() instanceof RuntimeException) {
                msg.append(StringUtils.stringifyException(e.getValue()));
                continue;
            }
            if (e.getValue().getLocalizedMessage() != null) {
                msg.append(e.getValue().getLocalizedMessage());
                continue;
            }
            msg.append(StringUtils.stringifyException(e.getValue()));
        }
        return new QuorumException(msg.toString());
    }

    private QuorumException(String msg) {
        super(msg);
    }
}

