/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.balancer;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.org.apache.hadoop.HadoopIllegalArgumentException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.conf.Configured;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.fs.StorageType;
import shaded.org.apache.hadoop.hdfs.DFSUtil;
import shaded.org.apache.hadoop.hdfs.HdfsConfiguration;
import shaded.org.apache.hadoop.hdfs.server.balancer.BalancerParameters;
import shaded.org.apache.hadoop.hdfs.server.balancer.BalancingPolicy;
import shaded.org.apache.hadoop.hdfs.server.balancer.Dispatcher;
import shaded.org.apache.hadoop.hdfs.server.balancer.ExitStatus;
import shaded.org.apache.hadoop.hdfs.server.balancer.Matcher;
import shaded.org.apache.hadoop.hdfs.server.balancer.NameNodeConnector;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import shaded.org.apache.hadoop.hdfs.server.namenode.UnsupportedActionException;
import shaded.org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import shaded.org.apache.hadoop.hdfs.server.protocol.StorageReport;
import shaded.org.apache.hadoop.io.IOUtils;
import shaded.org.apache.hadoop.net.NetUtils;
import shaded.org.apache.hadoop.net.Node;
import shaded.org.apache.hadoop.security.SecurityUtil;
import shaded.org.apache.hadoop.security.UserGroupInformation;
import shaded.org.apache.hadoop.util.HostsFileReader;
import shaded.org.apache.hadoop.util.StringUtils;
import shaded.org.apache.hadoop.util.Time;
import shaded.org.apache.hadoop.util.Tool;
import shaded.org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class Balancer {
    static final Log LOG = LogFactory.getLog(Balancer.class);
    static final Path BALANCER_ID_PATH = new Path("/system/balancer.id");
    private static final String USAGE = "Usage: hdfs balancer\n\t[-policy <policy>]\tthe balancing policy: " + BalancingPolicy.Node.INSTANCE.getName() + " or " + BalancingPolicy.Pool.INSTANCE.getName() + "\n\t[-threshold <threshold>]\tPercentage of disk capacity" + "\n\t[-exclude [-f <hosts-file> | <comma-separated list of hosts>]]" + "\tExcludes the specified datanodes." + "\n\t[-include [-f <hosts-file> | <comma-separated list of hosts>]]" + "\tIncludes only the specified datanodes." + "\n\t[-source [-f <hosts-file> | <comma-separated list of hosts>]]" + "\tPick only the specified datanodes as source nodes." + "\n\t[-blockpools <comma-separated list of blockpool ids>]" + "\tThe balancer will only run on blockpools included in this list." + "\n\t[-idleiterations <idleiterations>]" + "\tNumber of consecutive idle iterations (-1 for Infinite) before " + "exit." + "\n\t[-runDuringUpgrade]" + "\tWhether to run the balancer during an ongoing HDFS upgrade." + "This is usually not desired since it will not affect used space " + "on over-utilized machines.";
    private final Dispatcher dispatcher;
    private final NameNodeConnector nnc;
    private final BalancingPolicy policy;
    private final Set<String> sourceNodes;
    private final boolean runDuringUpgrade;
    private final double threshold;
    private final long maxSizeToMove;
    private final long defaultBlockSize;
    private final Collection<Dispatcher.Source> overUtilized = new LinkedList<Dispatcher.Source>();
    private final Collection<Dispatcher.Source> aboveAvgUtilized = new LinkedList<Dispatcher.Source>();
    private final Collection<Dispatcher.DDatanode.StorageGroup> belowAvgUtilized = new LinkedList<Dispatcher.DDatanode.StorageGroup>();
    private final Collection<Dispatcher.DDatanode.StorageGroup> underUtilized = new LinkedList<Dispatcher.DDatanode.StorageGroup>();

    private static void checkReplicationPolicyCompatibility(Configuration conf) throws UnsupportedActionException {
        if (!(BlockPlacementPolicy.getInstance(conf, null, null, null) instanceof BlockPlacementPolicyDefault)) {
            throw new UnsupportedActionException("Balancer without BlockPlacementPolicyDefault");
        }
    }

    static long getLong(Configuration conf, String key, long defaultValue) {
        long v = conf.getLong(key, defaultValue);
        LOG.info((Object)(key + " = " + v + " (default=" + defaultValue + ")"));
        if (v <= 0L) {
            throw new HadoopIllegalArgumentException(key + " = " + v + " <= " + 0);
        }
        return v;
    }

    static long getLongBytes(Configuration conf, String key, long defaultValue) {
        long v = conf.getLongBytes(key, defaultValue);
        LOG.info((Object)(key + " = " + v + " (default=" + defaultValue + ")"));
        if (v <= 0L) {
            throw new HadoopIllegalArgumentException(key + " = " + v + " <= " + 0);
        }
        return v;
    }

    static int getInt(Configuration conf, String key, int defaultValue) {
        int v = conf.getInt(key, defaultValue);
        LOG.info((Object)(key + " = " + v + " (default=" + defaultValue + ")"));
        if (v <= 0) {
            throw new HadoopIllegalArgumentException(key + " = " + v + " <= " + 0);
        }
        return v;
    }

    Balancer(NameNodeConnector theblockpool, BalancerParameters p, Configuration conf) {
        long movedWinWidth = Balancer.getLong(conf, "dfs.balancer.movedWinWidth", 5400000L);
        int moverThreads = Balancer.getInt(conf, "dfs.balancer.moverThreads", 1000);
        int dispatcherThreads = Balancer.getInt(conf, "dfs.balancer.dispatcherThreads", 200);
        int maxConcurrentMovesPerNode = Balancer.getInt(conf, "dfs.datanode.balance.max.concurrent.moves", 50);
        long getBlocksSize = Balancer.getLongBytes(conf, "dfs.balancer.getBlocks.size", 0x80000000L);
        long getBlocksMinBlockSize = Balancer.getLongBytes(conf, "dfs.balancer.getBlocks.min-block-size", 0xA00000L);
        int blockMoveTimeout = conf.getInt("dfs.balancer.block-move.timeout", 0);
        int maxNoMoveInterval = conf.getInt("dfs.balancer.max-no-move-interval", 60000);
        this.nnc = theblockpool;
        this.dispatcher = new Dispatcher(theblockpool, p.getIncludedNodes(), p.getExcludedNodes(), movedWinWidth, moverThreads, dispatcherThreads, maxConcurrentMovesPerNode, getBlocksSize, getBlocksMinBlockSize, blockMoveTimeout, maxNoMoveInterval, conf);
        this.threshold = p.getThreshold();
        this.policy = p.getBalancingPolicy();
        this.sourceNodes = p.getSourceNodes();
        this.runDuringUpgrade = p.getRunDuringUpgrade();
        this.maxSizeToMove = Balancer.getLongBytes(conf, "dfs.balancer.max-size-to-move", 0x280000000L);
        this.defaultBlockSize = Balancer.getLongBytes(conf, "dfs.blocksize", 0x8000000L);
    }

    private static long getCapacity(DatanodeStorageReport report, StorageType t) {
        long capacity = 0L;
        for (StorageReport r : report.getStorageReports()) {
            if (r.getStorage().getStorageType() != t) continue;
            capacity += r.getCapacity();
        }
        return capacity;
    }

    private long getRemaining(DatanodeStorageReport report, StorageType t) {
        long remaining = 0L;
        for (StorageReport r : report.getStorageReports()) {
            if (r.getStorage().getStorageType() != t || r.getRemaining() < this.defaultBlockSize) continue;
            remaining += r.getRemaining();
        }
        return remaining;
    }

    private long init(List<DatanodeStorageReport> reports) {
        for (DatanodeStorageReport r : reports) {
            this.policy.accumulateSpaces(r);
        }
        this.policy.initAvgUtilization();
        long overLoadedBytes = 0L;
        long underLoadedBytes = 0L;
        for (DatanodeStorageReport r : reports) {
            Dispatcher.DDatanode dn = this.dispatcher.newDatanode(r.getDatanodeInfo());
            boolean isSource = Dispatcher.Util.isIncluded(this.sourceNodes, dn.getDatanodeInfo());
            for (StorageType t : StorageType.getMovableTypes()) {
                Dispatcher.DDatanode.StorageGroup g;
                Double utilization = this.policy.getUtilization(r, t);
                if (utilization == null) continue;
                double average = this.policy.getAvgUtilization(t);
                if (utilization >= average && !isSource) {
                    LOG.info((Object)(dn + "[" + (Object)((Object)t) + "] has utilization=" + utilization + " >= average=" + average + " but it is not specified as a source; skipping it."));
                    continue;
                }
                double utilizationDiff = utilization - average;
                long capacity = Balancer.getCapacity(r, t);
                double thresholdDiff = Math.abs(utilizationDiff) - this.threshold;
                long maxSize2Move = Balancer.computeMaxSize2Move(capacity, this.getRemaining(r, t), utilizationDiff, this.maxSizeToMove);
                if (utilizationDiff > 0.0) {
                    Dispatcher.Source s = dn.addSource(t, maxSize2Move, this.dispatcher);
                    if (thresholdDiff <= 0.0) {
                        this.aboveAvgUtilized.add(s);
                    } else {
                        overLoadedBytes += Balancer.percentage2bytes(thresholdDiff, capacity);
                        this.overUtilized.add(s);
                    }
                    g = s;
                } else {
                    g = dn.addTarget(t, maxSize2Move);
                    if (thresholdDiff <= 0.0) {
                        this.belowAvgUtilized.add(g);
                    } else {
                        underLoadedBytes += Balancer.percentage2bytes(thresholdDiff, capacity);
                        this.underUtilized.add(g);
                    }
                }
                this.dispatcher.getStorageGroupMap().put(g);
            }
        }
        this.logUtilizationCollections();
        Preconditions.checkState((this.dispatcher.getStorageGroupMap().size() == this.overUtilized.size() + this.underUtilized.size() + this.aboveAvgUtilized.size() + this.belowAvgUtilized.size() ? 1 : 0) != 0, (Object)"Mismatched number of storage groups");
        return Math.max(overLoadedBytes, underLoadedBytes);
    }

    private static long computeMaxSize2Move(long capacity, long remaining, double utilizationDiff, long max) {
        double diff = Math.abs(utilizationDiff);
        long maxSizeToMove = Balancer.percentage2bytes(diff, capacity);
        if (utilizationDiff < 0.0) {
            maxSizeToMove = Math.min(remaining, maxSizeToMove);
        }
        return Math.min(max, maxSizeToMove);
    }

    private static long percentage2bytes(double percentage, long capacity) {
        Preconditions.checkArgument((percentage >= 0.0 ? 1 : 0) != 0, (String)"percentage = %s < 0", (Object[])new Object[]{percentage});
        return (long)(percentage * (double)capacity / 100.0);
    }

    private void logUtilizationCollections() {
        Balancer.logUtilizationCollection("over-utilized", this.overUtilized);
        if (LOG.isTraceEnabled()) {
            Balancer.logUtilizationCollection("above-average", this.aboveAvgUtilized);
            Balancer.logUtilizationCollection("below-average", this.belowAvgUtilized);
        }
        Balancer.logUtilizationCollection("underutilized", this.underUtilized);
    }

    private static <T extends Dispatcher.DDatanode.StorageGroup> void logUtilizationCollection(String name, Collection<T> items) {
        LOG.info((Object)(items.size() + " " + name + ": " + items));
    }

    private long chooseStorageGroups() {
        if (this.dispatcher.getCluster().isNodeGroupAware()) {
            this.chooseStorageGroups(Matcher.SAME_NODE_GROUP);
        }
        this.chooseStorageGroups(Matcher.SAME_RACK);
        this.chooseStorageGroups(Matcher.ANY_OTHER);
        return this.dispatcher.bytesToMove();
    }

    private void chooseStorageGroups(Matcher matcher) {
        LOG.info((Object)("chooseStorageGroups for " + matcher + ": overUtilized => underUtilized"));
        this.chooseStorageGroups(this.overUtilized, this.underUtilized, matcher);
        LOG.info((Object)("chooseStorageGroups for " + matcher + ": overUtilized => belowAvgUtilized"));
        this.chooseStorageGroups(this.overUtilized, this.belowAvgUtilized, matcher);
        LOG.info((Object)("chooseStorageGroups for " + matcher + ": underUtilized => aboveAvgUtilized"));
        this.chooseStorageGroups(this.underUtilized, this.aboveAvgUtilized, matcher);
    }

    private <G extends Dispatcher.DDatanode.StorageGroup, C extends Dispatcher.DDatanode.StorageGroup> void chooseStorageGroups(Collection<G> groups, Collection<C> candidates, Matcher matcher) {
        Iterator<G> i = groups.iterator();
        while (i.hasNext()) {
            Dispatcher.DDatanode.StorageGroup g = (Dispatcher.DDatanode.StorageGroup)i.next();
            while (this.choose4One(g, candidates, matcher)) {
            }
            if (g.hasSpaceForScheduling()) continue;
            i.remove();
        }
    }

    private <C extends Dispatcher.DDatanode.StorageGroup> boolean choose4One(Dispatcher.DDatanode.StorageGroup g, Collection<C> candidates, Matcher matcher) {
        Iterator<C> i = candidates.iterator();
        C chosen = this.chooseCandidate(g, i, matcher);
        if (chosen == null) {
            return false;
        }
        if (g instanceof Dispatcher.Source) {
            this.matchSourceWithTargetToMove((Dispatcher.Source)g, (Dispatcher.DDatanode.StorageGroup)chosen);
        } else {
            this.matchSourceWithTargetToMove((Dispatcher.Source)chosen, g);
        }
        if (!((Dispatcher.DDatanode.StorageGroup)chosen).hasSpaceForScheduling()) {
            i.remove();
        }
        return true;
    }

    private void matchSourceWithTargetToMove(Dispatcher.Source source, Dispatcher.DDatanode.StorageGroup target) {
        long size = Math.min(source.availableSizeToMove(), target.availableSizeToMove());
        Dispatcher.Task task = new Dispatcher.Task(target, size);
        source.addTask(task);
        target.incScheduledSize(task.getSize());
        this.dispatcher.add(source, target);
        LOG.info((Object)("Decided to move " + StringUtils.byteDesc(size) + " bytes from " + source.getDisplayName() + " to " + target.getDisplayName()));
    }

    private <G extends Dispatcher.DDatanode.StorageGroup, C extends Dispatcher.DDatanode.StorageGroup> C chooseCandidate(G g, Iterator<C> candidates, Matcher matcher) {
        if (g.hasSpaceForScheduling()) {
            while (candidates.hasNext()) {
                Dispatcher.DDatanode.StorageGroup c = (Dispatcher.DDatanode.StorageGroup)candidates.next();
                if (!c.hasSpaceForScheduling()) {
                    candidates.remove();
                    continue;
                }
                if (!this.matchStorageGroups(c, g, matcher)) continue;
                return (C)c;
            }
        }
        return null;
    }

    private boolean matchStorageGroups(Dispatcher.DDatanode.StorageGroup left, Dispatcher.DDatanode.StorageGroup right, Matcher matcher) {
        return left.getStorageType() == right.getStorageType() && matcher.match(this.dispatcher.getCluster(), (Node)left.getDatanodeInfo(), (Node)right.getDatanodeInfo());
    }

    void resetData(Configuration conf) {
        this.overUtilized.clear();
        this.aboveAvgUtilized.clear();
        this.belowAvgUtilized.clear();
        this.underUtilized.clear();
        this.policy.reset();
        this.dispatcher.reset(conf);
    }

    Result newResult(ExitStatus exitStatus, long bytesLeftToMove, long bytesBeingMoved) {
        return new Result(exitStatus, bytesLeftToMove, bytesBeingMoved, this.dispatcher.getBytesMoved());
    }

    Result newResult(ExitStatus exitStatus) {
        return new Result(exitStatus, -1L, -1L, this.dispatcher.getBytesMoved());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result runOneIteration() {
        try {
            List<DatanodeStorageReport> reports = this.dispatcher.init();
            long bytesLeftToMove = this.init(reports);
            if (bytesLeftToMove == 0L) {
                System.out.println("The cluster is balanced. Exiting...");
                Result result = this.newResult(ExitStatus.SUCCESS, bytesLeftToMove, 0L);
                return result;
            }
            LOG.info((Object)("Need to move " + StringUtils.byteDesc(bytesLeftToMove) + " to make the cluster balanced."));
            if (!this.runDuringUpgrade && this.nnc.isUpgrading()) {
                System.err.println("Balancer exiting as upgrade is not finalized, please finalize the HDFS upgrade before running the balancer.");
                LOG.error((Object)"Balancer exiting as upgrade is not finalized, please finalize the HDFS upgrade before running the balancer.");
                Result result = this.newResult(ExitStatus.UNFINALIZED_UPGRADE, bytesLeftToMove, -1L);
                return result;
            }
            long bytesBeingMoved = this.chooseStorageGroups();
            if (bytesBeingMoved == 0L) {
                System.out.println("No block can be moved. Exiting...");
                Result result = this.newResult(ExitStatus.NO_MOVE_BLOCK, bytesLeftToMove, bytesBeingMoved);
                return result;
            }
            LOG.info((Object)("Will move " + StringUtils.byteDesc(bytesBeingMoved) + " in this iteration"));
            if (!this.dispatcher.dispatchAndCheckContinue()) {
                Result result = this.newResult(ExitStatus.NO_MOVE_PROGRESS, bytesLeftToMove, bytesBeingMoved);
                return result;
            }
            Result result = this.newResult(ExitStatus.IN_PROGRESS, bytesLeftToMove, bytesBeingMoved);
            return result;
        }
        catch (IllegalArgumentException e) {
            System.out.println(e + ".  Exiting ...");
            Result result = this.newResult(ExitStatus.ILLEGAL_ARGUMENTS);
            return result;
        }
        catch (IOException e) {
            System.out.println(e + ".  Exiting ...");
            Result result = this.newResult(ExitStatus.IO_EXCEPTION);
            return result;
        }
        catch (InterruptedException e) {
            System.out.println(e + ".  Exiting ...");
            Result result = this.newResult(ExitStatus.INTERRUPTED);
            return result;
        }
        finally {
            this.dispatcher.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int run(Collection<URI> namenodes, BalancerParameters p, Configuration conf) throws IOException, InterruptedException {
        block15: {
            block14: {
                sleeptime = conf.getLong("dfs.heartbeat.interval", 3L) * 2000L + conf.getLong("dfs.namenode.replication.interval", 3L) * 1000L;
                Balancer.LOG.info((Object)("namenodes  = " + namenodes));
                Balancer.LOG.info((Object)("parameters = " + p));
                Balancer.LOG.info((Object)("included nodes = " + p.getIncludedNodes()));
                Balancer.LOG.info((Object)("excluded nodes = " + p.getExcludedNodes()));
                Balancer.LOG.info((Object)("source nodes = " + p.getSourceNodes()));
                Balancer.checkKeytabAndInit(conf);
                System.out.println("Time Stamp               Iteration#  Bytes Already Moved  Bytes Left To Move  Bytes Being Moved");
                connectors = Collections.emptyList();
                try {
                    connectors = NameNodeConnector.newNameNodeConnectors(namenodes, Balancer.class.getSimpleName(), Balancer.BALANCER_ID_PATH, conf, p.getMaxIdleIteration());
                    done = false;
                    var7_7 = false;
lbl14:
                    // 2 sources

                    while (!done) {
                        done = true;
                        Collections.shuffle(connectors);
lbl17:
                        // 4 sources

                        for (NameNodeConnector var9_11 : connectors) {
                            if (p.getBlockPools().size() == 0 || p.getBlockPools().contains(var9_11.getBlockpoolID())) {
                                b = new Balancer(var9_11, p, conf);
                                r = b.runOneIteration();
                                r.print((int)var7_8, System.out);
                                b.resetData(conf);
                                if (r.exitStatus == ExitStatus.IN_PROGRESS) {
                                    done = false;
                                    continue;
                                }
                                if (r.exitStatus == ExitStatus.SUCCESS) continue;
                                var12_14 = r.exitStatus.getExitCode();
                                i$ = connectors.iterator();
                                break block14;
                            }
                            ** GOTO lbl-1000
                        }
                        ** GOTO lbl50
                    }
                    break block15;
                }
                catch (Throwable var15_17) {
                    i$ = connectors.iterator();
                    while (true) {
                        if (!i$.hasNext()) {
                            throw var15_17;
                        }
                        var17_19 = (NameNodeConnector)i$.next();
                        IOUtils.cleanup(Balancer.LOG, new Closeable[]{var17_19});
                    }
                }
            }
            while (true) {
                if (!i$.hasNext()) {
                    return var12_14;
                }
                var14_16 = (NameNodeConnector)i$.next();
                IOUtils.cleanup(Balancer.LOG, new Closeable[]{var14_16});
            }
lbl-1000:
            // 1 sources

            {
                Balancer.LOG.info((Object)("Skipping blockpool " + var9_11.getBlockpoolID()));
                ** GOTO lbl17
lbl50:
                // 1 sources

                if (!done) {
                    Thread.sleep(sleeptime);
                }
                ++var7_8;
                ** GOTO lbl14
            }
        }
        i$ = connectors.iterator();
        while (true) {
            if (!i$.hasNext()) {
                return ExitStatus.SUCCESS.getExitCode();
            }
            var7_9 = (NameNodeConnector)i$.next();
            IOUtils.cleanup(Balancer.LOG, new Closeable[]{var7_9});
        }
    }

    private static void checkKeytabAndInit(Configuration conf) throws IOException {
        if (conf.getBoolean("dfs.balancer.keytab.enabled", false)) {
            LOG.info((Object)"Keytab is configured, will login using keytab.");
            UserGroupInformation.setConfiguration(conf);
            String addr = conf.get("dfs.balancer.address", "0.0.0.0:0");
            InetSocketAddress socAddr = NetUtils.createSocketAddr(addr, 0, "dfs.balancer.address");
            SecurityUtil.login(conf, "dfs.balancer.keytab.file", "dfs.balancer.kerberos.principal", socAddr.getHostName());
        }
    }

    private static String time2Str(long elapsedTime) {
        String unit;
        double time = elapsedTime;
        if (elapsedTime < 1000L) {
            unit = "milliseconds";
        } else if (elapsedTime < 60000L) {
            unit = "seconds";
            time /= 1000.0;
        } else if (elapsedTime < 3600000L) {
            unit = "minutes";
            time /= 60000.0;
        } else {
            unit = "hours";
            time /= 3600000.0;
        }
        return time + " " + unit;
    }

    public static void main(String[] args) {
        if (DFSUtil.parseHelpArgument(args, USAGE, System.out, true)) {
            System.exit(0);
        }
        try {
            System.exit(ToolRunner.run((Configuration)new HdfsConfiguration(), new Cli(), args));
        }
        catch (Throwable e) {
            LOG.error((Object)"Exiting balancer due an exception", e);
            System.exit(-1);
        }
    }

    static class Cli
    extends Configured
    implements Tool {
        Cli() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public int run(String[] args) {
            int n;
            long startTime = Time.monotonicNow();
            Configuration conf = this.getConf();
            try {
                Balancer.checkReplicationPolicyCompatibility(conf);
                Collection<URI> namenodes = DFSUtil.getInternalNsRpcUris(conf);
                n = Balancer.run(namenodes, Cli.parse(args), conf);
            }
            catch (IOException e) {
                System.out.println(e + ".  Exiting ...");
                int n2 = ExitStatus.IO_EXCEPTION.getExitCode();
                System.out.format("%-24s ", DateFormat.getDateTimeInstance().format(new Date()));
                System.out.println("Balancing took " + Balancer.time2Str(Time.monotonicNow() - startTime));
                return n2;
            }
            catch (InterruptedException e2) {
                System.out.println(e2 + ".  Exiting ...");
                int n3 = ExitStatus.INTERRUPTED.getExitCode();
                {
                    catch (Throwable throwable) {
                        System.out.format("%-24s ", DateFormat.getDateTimeInstance().format(new Date()));
                        System.out.println("Balancing took " + Balancer.time2Str(Time.monotonicNow() - startTime));
                        throw throwable;
                    }
                }
                System.out.format("%-24s ", DateFormat.getDateTimeInstance().format(new Date()));
                System.out.println("Balancing took " + Balancer.time2Str(Time.monotonicNow() - startTime));
                return n3;
            }
            System.out.format("%-24s ", DateFormat.getDateTimeInstance().format(new Date()));
            System.out.println("Balancing took " + Balancer.time2Str(Time.monotonicNow() - startTime));
            return n;
        }

        static BalancerParameters parse(String[] args) {
            HashSet<String> excludedNodes = null;
            HashSet<String> includedNodes = null;
            BalancerParameters.Builder b = new BalancerParameters.Builder();
            if (args != null) {
                try {
                    for (int i = 0; i < args.length; ++i) {
                        if ("-threshold".equalsIgnoreCase(args[i])) {
                            Preconditions.checkArgument((++i < args.length ? 1 : 0) != 0, (Object)("Threshold value is missing: args = " + Arrays.toString(args)));
                            try {
                                double threshold = Double.parseDouble(args[i]);
                                if (threshold < 1.0 || threshold > 100.0) {
                                    throw new IllegalArgumentException("Number out of range: threshold = " + threshold);
                                }
                                LOG.info((Object)("Using a threshold of " + threshold));
                                b.setThreshold(threshold);
                                continue;
                            }
                            catch (IllegalArgumentException e) {
                                System.err.println("Expecting a number in the range of [1.0, 100.0]: " + args[i]);
                                throw e;
                            }
                        }
                        if ("-policy".equalsIgnoreCase(args[i])) {
                            Preconditions.checkArgument((++i < args.length ? 1 : 0) != 0, (Object)("Policy value is missing: args = " + Arrays.toString(args)));
                            try {
                                b.setBalancingPolicy(BalancingPolicy.parse(args[i]));
                                continue;
                            }
                            catch (IllegalArgumentException e) {
                                System.err.println("Illegal policy name: " + args[i]);
                                throw e;
                            }
                        }
                        if ("-exclude".equalsIgnoreCase(args[i])) {
                            excludedNodes = new HashSet<String>();
                            i = Cli.processHostList(args, i, "exclude", excludedNodes);
                            b.setExcludedNodes(excludedNodes);
                            continue;
                        }
                        if ("-include".equalsIgnoreCase(args[i])) {
                            includedNodes = new HashSet<String>();
                            i = Cli.processHostList(args, i, "include", includedNodes);
                            b.setIncludedNodes(includedNodes);
                            continue;
                        }
                        if ("-source".equalsIgnoreCase(args[i])) {
                            HashSet<String> sourceNodes = new HashSet<String>();
                            i = Cli.processHostList(args, i, "source", sourceNodes);
                            b.setSourceNodes(sourceNodes);
                            continue;
                        }
                        if ("-blockpools".equalsIgnoreCase(args[i])) {
                            Preconditions.checkArgument((++i < args.length ? 1 : 0) != 0, (Object)("blockpools value is missing: args = " + Arrays.toString(args)));
                            Set<String> blockpools = Cli.parseBlockPoolList(args[i]);
                            LOG.info((Object)("Balancer will run on the following blockpools: " + blockpools.toString()));
                            b.setBlockpools(blockpools);
                            continue;
                        }
                        if ("-idleiterations".equalsIgnoreCase(args[i])) {
                            Preconditions.checkArgument((++i < args.length ? 1 : 0) != 0, (Object)("idleiterations value is missing: args = " + Arrays.toString(args)));
                            int maxIdleIteration = Integer.parseInt(args[i]);
                            LOG.info((Object)("Using a idleiterations of " + maxIdleIteration));
                            b.setMaxIdleIteration(maxIdleIteration);
                            continue;
                        }
                        if ("-runDuringUpgrade".equalsIgnoreCase(args[i])) {
                            b.setRunDuringUpgrade(true);
                            LOG.info((Object)"Will run the balancer even during an ongoing HDFS upgrade. Most users will not want to run the balancer during an upgrade since it will not affect used space on over-utilized machines.");
                            continue;
                        }
                        throw new IllegalArgumentException("args = " + Arrays.toString(args));
                    }
                    Preconditions.checkArgument((excludedNodes == null || includedNodes == null ? 1 : 0) != 0, (Object)"-exclude and -include options cannot be specified together.");
                }
                catch (RuntimeException e) {
                    Cli.printUsage(System.err);
                    throw e;
                }
            }
            return b.build();
        }

        private static int processHostList(String[] args, int i, String type, Set<String> nodes) {
            Preconditions.checkArgument((++i < args.length ? 1 : 0) != 0, (String)"List of %s nodes | -f <filename> is missing: args=%s", (Object[])new Object[]{type, Arrays.toString(args)});
            if ("-f".equalsIgnoreCase(args[i])) {
                Preconditions.checkArgument((++i < args.length ? 1 : 0) != 0, (String)"File containing %s nodes is not specified: args=%s", (Object[])new Object[]{type, Arrays.toString(args)});
                String filename = args[i];
                try {
                    HostsFileReader.readFileToSet(type, filename, nodes);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to read " + type + " node list from file: " + filename);
                }
            } else {
                String[] addresses = StringUtils.getTrimmedStrings(args[i]);
                nodes.addAll(Arrays.asList(addresses));
            }
            return i;
        }

        private static Set<String> parseBlockPoolList(String string) {
            String[] addrs = StringUtils.getTrimmedStrings(string);
            return new HashSet<String>(Arrays.asList(addrs));
        }

        private static void printUsage(PrintStream out) {
            out.println(USAGE + "\n");
        }
    }

    static class Result {
        final ExitStatus exitStatus;
        final long bytesLeftToMove;
        final long bytesBeingMoved;
        final long bytesAlreadyMoved;

        Result(ExitStatus exitStatus, long bytesLeftToMove, long bytesBeingMoved, long bytesAlreadyMoved) {
            this.exitStatus = exitStatus;
            this.bytesLeftToMove = bytesLeftToMove;
            this.bytesBeingMoved = bytesBeingMoved;
            this.bytesAlreadyMoved = bytesAlreadyMoved;
        }

        void print(int iteration, PrintStream out) {
            out.printf("%-24s %10d  %19s  %18s  %17s%n", DateFormat.getDateTimeInstance().format(new Date()), iteration, StringUtils.byteDesc(this.bytesAlreadyMoved), StringUtils.byteDesc(this.bytesLeftToMove), StringUtils.byteDesc(this.bytesBeingMoved));
        }
    }
}

