/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.blockmanagement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.StorageType;
import shaded.org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatusWithUpgradeDomain;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.FSClusterStats;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.Host2NodesMap;
import shaded.org.apache.hadoop.net.NetworkTopology;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class BlockPlacementPolicyWithUpgradeDomain
extends BlockPlacementPolicyDefault {
    private int upgradeDomainFactor;

    @Override
    public void initialize(Configuration conf, FSClusterStats stats, NetworkTopology clusterMap, Host2NodesMap host2datanodeMap) {
        super.initialize(conf, stats, clusterMap, host2datanodeMap);
        this.upgradeDomainFactor = conf.getInt("dfs.namenode.upgrade.domain.factor", 3);
    }

    @Override
    protected boolean isGoodDatanode(DatanodeDescriptor node, int maxTargetPerRack, boolean considerLoad, List<DatanodeStorageInfo> results, boolean avoidStaleNodes) {
        Set<String> upgradeDomains;
        boolean isGoodTarget = super.isGoodDatanode(node, maxTargetPerRack, considerLoad, results, avoidStaleNodes);
        if (isGoodTarget && results.size() > 0 && results.size() < this.upgradeDomainFactor && (upgradeDomains = this.getUpgradeDomains(results)).contains(node.getUpgradeDomain())) {
            isGoodTarget = false;
        }
        return isGoodTarget;
    }

    public String getUpgradeDomainWithDefaultValue(DatanodeInfo datanodeInfo) {
        String upgradeDomain = datanodeInfo.getUpgradeDomain();
        if (upgradeDomain == null) {
            LOG.warn("Upgrade domain isn't defined for " + datanodeInfo);
            upgradeDomain = datanodeInfo.getXferAddr();
        }
        return upgradeDomain;
    }

    private String getUpgradeDomain(DatanodeStorageInfo storage) {
        return this.getUpgradeDomainWithDefaultValue(storage.getDatanodeDescriptor());
    }

    private Set<String> getUpgradeDomains(List<DatanodeStorageInfo> results) {
        HashSet<String> upgradeDomains = new HashSet<String>();
        if (results == null) {
            return upgradeDomains;
        }
        for (DatanodeStorageInfo storageInfo : results) {
            upgradeDomains.add(this.getUpgradeDomain(storageInfo));
        }
        return upgradeDomains;
    }

    private Set<String> getUpgradeDomainsFromNodes(DatanodeInfo[] nodes) {
        HashSet<String> upgradeDomains = new HashSet<String>();
        if (nodes == null) {
            return upgradeDomains;
        }
        for (DatanodeInfo node : nodes) {
            upgradeDomains.add(this.getUpgradeDomainWithDefaultValue(node));
        }
        return upgradeDomains;
    }

    private <T> Map<String, List<T>> getUpgradeDomainMap(Collection<T> storagesOrDataNodes) {
        HashMap<String, List<T>> upgradeDomainMap = new HashMap<String, List<T>>();
        for (T storage : storagesOrDataNodes) {
            String upgradeDomain = this.getUpgradeDomainWithDefaultValue(this.getDatanodeInfo(storage));
            ArrayList<T> storages = (ArrayList<T>)upgradeDomainMap.get(upgradeDomain);
            if (storages == null) {
                storages = new ArrayList<T>();
                upgradeDomainMap.put(upgradeDomain, storages);
            }
            storages.add(storage);
        }
        return upgradeDomainMap;
    }

    @Override
    public BlockPlacementStatus verifyBlockPlacement(DatanodeInfo[] locs, int numberOfReplicas) {
        BlockPlacementStatus defaultStatus = super.verifyBlockPlacement(locs, numberOfReplicas);
        BlockPlacementStatusWithUpgradeDomain upgradeDomainStatus = new BlockPlacementStatusWithUpgradeDomain(defaultStatus, this.getUpgradeDomainsFromNodes(locs), numberOfReplicas, this.upgradeDomainFactor);
        return upgradeDomainStatus;
    }

    private <T> List<T> getShareUDSet(Map<String, List<T>> upgradeDomains) {
        ArrayList getShareUDSet = new ArrayList();
        for (Map.Entry<String, List<T>> e : upgradeDomains.entrySet()) {
            if (e.getValue().size() <= 1) continue;
            getShareUDSet.addAll(e.getValue());
        }
        return getShareUDSet;
    }

    private Collection<DatanodeStorageInfo> combine(Collection<DatanodeStorageInfo> moreThanOne, Collection<DatanodeStorageInfo> exactlyOne) {
        ArrayList<DatanodeStorageInfo> all = new ArrayList<DatanodeStorageInfo>();
        if (moreThanOne != null) {
            all.addAll(moreThanOne);
        }
        if (exactlyOne != null) {
            all.addAll(exactlyOne);
        }
        return all;
    }

    @Override
    protected Collection<DatanodeStorageInfo> pickupReplicaSet(Collection<DatanodeStorageInfo> moreThanOne, Collection<DatanodeStorageInfo> exactlyOne, Map<String, List<DatanodeStorageInfo>> rackMap) {
        Collection<DatanodeStorageInfo> all = this.combine(moreThanOne, exactlyOne);
        List shareUDSet = this.getShareUDSet(this.getUpgradeDomainMap(all));
        ArrayList<DatanodeStorageInfo> shareRackAndUDSet = new ArrayList<DatanodeStorageInfo>();
        if (shareUDSet.size() == 0) {
            return super.pickupReplicaSet(moreThanOne, exactlyOne, rackMap);
        }
        if (moreThanOne != null) {
            for (DatanodeStorageInfo storage : shareUDSet) {
                if (!moreThanOne.contains(storage)) continue;
                shareRackAndUDSet.add(storage);
            }
        }
        return shareRackAndUDSet.size() > 0 ? shareRackAndUDSet : shareUDSet;
    }

    @Override
    boolean useDelHint(DatanodeStorageInfo delHint, DatanodeStorageInfo added, List<DatanodeStorageInfo> moreThanOne, Collection<DatanodeStorageInfo> exactlyOne, List<StorageType> excessTypes) {
        if (!super.useDelHint(delHint, added, moreThanOne, exactlyOne, excessTypes)) {
            return false;
        }
        return this.isMovableBasedOnUpgradeDomain(this.combine(moreThanOne, exactlyOne), delHint, added);
    }

    private <T> boolean isMovableBasedOnUpgradeDomain(Collection<T> all, T source, T target) {
        Map<String, List<T>> udMap = this.getUpgradeDomainMap(all);
        List<T> shareUDSet = this.getShareUDSet(udMap);
        if (this.notReduceNumOfGroups(shareUDSet, source, target)) {
            return true;
        }
        return udMap.size() > this.upgradeDomainFactor;
    }

    @Override
    public boolean isMovable(Collection<DatanodeInfo> locs, DatanodeInfo source, DatanodeInfo target) {
        if (super.isMovable(locs, source, target)) {
            return this.isMovableBasedOnUpgradeDomain(locs, source, target);
        }
        return false;
    }
}

