/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.blockmanagement;

import shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementStatus;

public class BlockPlacementStatusDefault
implements BlockPlacementStatus {
    private int requiredRacks = 0;
    private int currentRacks = 0;

    public BlockPlacementStatusDefault(int currentRacks, int requiredRacks) {
        this.requiredRacks = requiredRacks;
        this.currentRacks = currentRacks;
    }

    @Override
    public boolean isPlacementPolicySatisfied() {
        return this.requiredRacks <= this.currentRacks;
    }

    @Override
    public String getErrorDescription() {
        if (this.isPlacementPolicySatisfied()) {
            return null;
        }
        return "Block should be additionally replicated on " + (this.requiredRacks - this.currentRacks) + " more rack(s).";
    }
}

