/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.common;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.hdfs.DFSUtil;
import shaded.org.apache.hadoop.hdfs.server.datanode.DataNodeLayoutVersion;
import shaded.org.apache.hadoop.hdfs.server.namenode.MetaRecoveryContext;
import shaded.org.apache.hadoop.hdfs.server.namenode.NameNodeLayoutVersion;
import shaded.org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public interface HdfsServerConstants {
    public static final int MIN_BLOCKS_FOR_WRITE = 1;
    public static final long LEASE_SOFTLIMIT_PERIOD = 60000L;
    public static final long LEASE_RECOVER_PERIOD = 10000L;
    public static final int MAX_PATH_LENGTH = 8000;
    public static final int MAX_PATH_DEPTH = 1000;
    public static final long INVALID_TXID = -12345L;
    public static final long RESERVED_LEGACY_GENERATION_STAMPS = 0x10000000000L;
    public static final int NAMENODE_LAYOUT_VERSION = NameNodeLayoutVersion.CURRENT_LAYOUT_VERSION;
    public static final int DATANODE_LAYOUT_VERSION = DataNodeLayoutVersion.CURRENT_LAYOUT_VERSION;
    public static final String[] RESERVED_PATH_COMPONENTS = new String[]{".snapshot", ".reserved"};
    public static final byte[] DOT_SNAPSHOT_DIR_BYTES = DFSUtil.string2Bytes(".snapshot");
    public static final String NAMENODE_LEASE_HOLDER = "HDFS_NameNode";
    public static final String CRYPTO_XATTR_ENCRYPTION_ZONE = "raw.hdfs.crypto.encryption.zone";
    public static final String CRYPTO_XATTR_FILE_ENCRYPTION_INFO = "raw.hdfs.crypto.file.encryption.info";
    public static final String SECURITY_XATTR_UNREADABLE_BY_SUPERUSER = "security.hdfs.unreadable.by.superuser";

    public static enum BlockUCState {
        COMPLETE,
        UNDER_CONSTRUCTION,
        UNDER_RECOVERY,
        COMMITTED;

    }

    public static enum ReplicaState {
        FINALIZED(0),
        RBW(1),
        RWR(2),
        RUR(3),
        TEMPORARY(4);

        private static final ReplicaState[] cachedValues;
        private final int value;

        private ReplicaState(int v) {
            this.value = v;
        }

        public int getValue() {
            return this.value;
        }

        public static ReplicaState getState(int v) {
            return cachedValues[v];
        }

        public static ReplicaState read(DataInput in) throws IOException {
            return cachedValues[in.readByte()];
        }

        public void write(DataOutput out) throws IOException {
            out.writeByte(this.ordinal());
        }

        static {
            cachedValues = ReplicaState.values();
        }
    }

    public static enum NamenodeRole {
        NAMENODE("NameNode"),
        BACKUP("Backup Node"),
        CHECKPOINT("Checkpoint Node");

        private String description = null;

        private NamenodeRole(String arg) {
            this.description = arg;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum StartupOption {
        FORMAT("-format"),
        CLUSTERID("-clusterid"),
        GENCLUSTERID("-genclusterid"),
        REGULAR("-regular"),
        BACKUP("-backup"),
        CHECKPOINT("-checkpoint"),
        UPGRADE("-upgrade"),
        ROLLBACK("-rollback"),
        FINALIZE("-finalize"),
        ROLLINGUPGRADE("-rollingUpgrade"),
        IMPORT("-importCheckpoint"),
        BOOTSTRAPSTANDBY("-bootstrapStandby"),
        INITIALIZESHAREDEDITS("-initializeSharedEdits"),
        RECOVER("-recover"),
        FORCE("-force"),
        NONINTERACTIVE("-nonInteractive"),
        SKIPSHAREDEDITSCHECK("-skipSharedEditsCheck"),
        RENAMERESERVED("-renameReserved"),
        METADATAVERSION("-metadataVersion"),
        UPGRADEONLY("-upgradeOnly"),
        HOTSWAP("-hotswap"),
        OBSERVER("-observer");

        private static final Pattern ENUM_WITH_ROLLING_UPGRADE_OPTION;
        private final String name;
        private String clusterId = null;
        private RollingUpgradeStartupOption rollingUpgradeStartupOption;
        private boolean isForceFormat = false;
        private boolean isInteractiveFormat = true;
        private int force = 0;

        private StartupOption(String arg) {
            this.name = arg;
        }

        public String getName() {
            return this.name;
        }

        public NamenodeRole toNodeRole() {
            switch (this) {
                case BACKUP: {
                    return NamenodeRole.BACKUP;
                }
                case CHECKPOINT: {
                    return NamenodeRole.CHECKPOINT;
                }
            }
            return NamenodeRole.NAMENODE;
        }

        public void setClusterId(String cid) {
            this.clusterId = cid;
        }

        public String getClusterId() {
            return this.clusterId;
        }

        public void setRollingUpgradeStartupOption(String opt) {
            Preconditions.checkState((this == ROLLINGUPGRADE ? 1 : 0) != 0);
            this.rollingUpgradeStartupOption = RollingUpgradeStartupOption.fromString(opt);
        }

        public RollingUpgradeStartupOption getRollingUpgradeStartupOption() {
            Preconditions.checkState((this == ROLLINGUPGRADE ? 1 : 0) != 0);
            return this.rollingUpgradeStartupOption;
        }

        public MetaRecoveryContext createRecoveryContext() {
            if (!this.name.equals(StartupOption.RECOVER.name)) {
                return null;
            }
            return new MetaRecoveryContext(this.force);
        }

        public void setForce(int force) {
            this.force = force;
        }

        public int getForce() {
            return this.force;
        }

        public boolean getForceFormat() {
            return this.isForceFormat;
        }

        public void setForceFormat(boolean force) {
            this.isForceFormat = force;
        }

        public boolean getInteractiveFormat() {
            return this.isInteractiveFormat;
        }

        public void setInteractiveFormat(boolean interactive) {
            this.isInteractiveFormat = interactive;
        }

        public String toString() {
            if (this == ROLLINGUPGRADE) {
                return super.toString() + "(" + (Object)((Object)this.getRollingUpgradeStartupOption()) + ")";
            }
            return super.toString();
        }

        public static StartupOption getEnum(String value) {
            Matcher matcher = ENUM_WITH_ROLLING_UPGRADE_OPTION.matcher(value);
            if (matcher.matches()) {
                StartupOption option = StartupOption.valueOf(matcher.group(1));
                option.setRollingUpgradeStartupOption(matcher.group(2));
                return option;
            }
            return StartupOption.valueOf(value);
        }

        static {
            ENUM_WITH_ROLLING_UPGRADE_OPTION = Pattern.compile("(\\w+)\\((\\w+)\\)");
        }
    }

    public static enum RollingUpgradeStartupOption {
        ROLLBACK,
        DOWNGRADE,
        STARTED;

        private static final RollingUpgradeStartupOption[] VALUES;

        public String getOptionString() {
            return StartupOption.ROLLINGUPGRADE.getName() + " " + StringUtils.toLowerCase(this.name());
        }

        public boolean matches(StartupOption option) {
            return option == StartupOption.ROLLINGUPGRADE && option.getRollingUpgradeStartupOption() == this;
        }

        static RollingUpgradeStartupOption fromString(String s) {
            for (RollingUpgradeStartupOption opt : VALUES) {
                if (!opt.name().equalsIgnoreCase(s)) continue;
                return opt;
            }
            throw new IllegalArgumentException("Failed to convert \"" + s + "\" to " + RollingUpgradeStartupOption.class.getSimpleName());
        }

        public static String getAllOptionString() {
            StringBuilder b = new StringBuilder("<");
            for (RollingUpgradeStartupOption opt : VALUES) {
                b.append(StringUtils.toLowerCase(opt.name())).append("|");
            }
            b.setCharAt(b.length() - 1, '>');
            return b.toString();
        }

        static {
            VALUES = RollingUpgradeStartupOption.values();
        }
    }

    public static enum NodeType {
        NAME_NODE,
        DATA_NODE,
        JOURNAL_NODE;

    }
}

