/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.Flushable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.FileUtil;
import shaded.org.apache.hadoop.fs.HardLink;
import shaded.org.apache.hadoop.hdfs.server.common.Storage;
import shaded.org.apache.hadoop.hdfs.server.datanode.DataNode;
import shaded.org.apache.hadoop.hdfs.server.datanode.FaultInjectorFileIoEvents;
import shaded.org.apache.hadoop.hdfs.server.datanode.ProfilingFileIoEvents;
import shaded.org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import shaded.org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetUtil;
import shaded.org.apache.hadoop.io.IOUtils;
import shaded.org.apache.hadoop.io.LongWritable;
import shaded.org.apache.hadoop.io.nativeio.NativeIO;
import shaded.org.apache.hadoop.io.nativeio.NativeIOException;
import shaded.org.apache.hadoop.net.SocketOutputStream;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FileIoProvider {
    public static final Logger LOG = LoggerFactory.getLogger(FileIoProvider.class);
    private final ProfilingFileIoEvents profilingEventHook;
    private final FaultInjectorFileIoEvents faultInjectorEventHook;
    private final DataNode datanode;
    private static final int LEN_INT = 4;

    public FileIoProvider(@Nullable Configuration conf, DataNode datanode) {
        this.profilingEventHook = new ProfilingFileIoEvents(conf);
        this.faultInjectorEventHook = new FaultInjectorFileIoEvents(conf);
        this.datanode = datanode;
    }

    public void flush(@Nullable FsVolumeSpi volume, Flushable f) throws IOException {
        long begin = this.profilingEventHook.beforeFileIo(volume, OPERATION.FLUSH, 0L);
        try {
            this.faultInjectorEventHook.beforeFileIo(volume, OPERATION.FLUSH, 0L);
            f.flush();
            this.profilingEventHook.afterFileIo(volume, OPERATION.FLUSH, begin, 0L);
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public void sync(@Nullable FsVolumeSpi volume, FileOutputStream fos) throws IOException {
        long begin = this.profilingEventHook.beforeFileIo(volume, OPERATION.SYNC, 0L);
        try {
            this.faultInjectorEventHook.beforeFileIo(volume, OPERATION.SYNC, 0L);
            IOUtils.fsync(fos.getChannel(), false);
            this.profilingEventHook.afterFileIo(volume, OPERATION.SYNC, begin, 0L);
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public void dirSync(@Nullable FsVolumeSpi volume, File dir) throws IOException {
        long begin = this.profilingEventHook.beforeFileIo(volume, OPERATION.SYNC, 0L);
        try {
            this.faultInjectorEventHook.beforeFileIo(volume, OPERATION.SYNC, 0L);
            IOUtils.fsync(dir);
            this.profilingEventHook.afterFileIo(volume, OPERATION.SYNC, begin, 0L);
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public void syncFileRange(@Nullable FsVolumeSpi volume, FileDescriptor outFd, long offset, long numBytes, int flags) throws NativeIOException {
        long begin = this.profilingEventHook.beforeFileIo(volume, OPERATION.SYNC, 0L);
        try {
            this.faultInjectorEventHook.beforeFileIo(volume, OPERATION.SYNC, 0L);
            NativeIO.POSIX.syncFileRangeIfPossible(outFd, offset, numBytes, flags);
            this.profilingEventHook.afterFileIo(volume, OPERATION.SYNC, begin, 0L);
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public void posixFadvise(@Nullable FsVolumeSpi volume, String identifier, FileDescriptor outFd, long offset, long length, int flags) throws NativeIOException {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.FADVISE);
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.FADVISE);
            NativeIO.POSIX.getCacheManipulator().posixFadviseIfPossible(identifier, outFd, offset, length, flags);
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.FADVISE, begin);
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public boolean delete(@Nullable FsVolumeSpi volume, File f) {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.DELETE);
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.DELETE);
            boolean deleted = f.delete();
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.DELETE, begin);
            return deleted;
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public boolean deleteWithExistsCheck(@Nullable FsVolumeSpi volume, File f) {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.DELETE);
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.DELETE);
            boolean deleted = !f.exists() || f.delete();
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.DELETE, begin);
            if (!deleted) {
                LOG.warn("Failed to delete file {}", (Object)f);
            }
            return deleted;
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public void transferToSocketFully(@Nullable FsVolumeSpi volume, SocketOutputStream sockOut, FileChannel fileCh, long position, int count, LongWritable waitTime, LongWritable transferTime) throws IOException {
        long begin = this.profilingEventHook.beforeFileIo(volume, OPERATION.TRANSFER, count);
        try {
            this.faultInjectorEventHook.beforeFileIo(volume, OPERATION.TRANSFER, count);
            sockOut.transferToFully(fileCh, position, count, waitTime, transferTime);
            this.profilingEventHook.afterFileIo(volume, OPERATION.TRANSFER, begin, count);
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public boolean createFile(@Nullable FsVolumeSpi volume, File f) throws IOException {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.OPEN);
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.OPEN);
            boolean created = f.createNewFile();
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.OPEN, begin);
            return created;
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public FileInputStream getFileInputStream(@Nullable FsVolumeSpi volume, File f) throws FileNotFoundException {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.OPEN);
        WrappedFileInputStream fis = null;
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.OPEN);
            fis = new WrappedFileInputStream(volume, f);
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.OPEN, begin);
            return fis;
        }
        catch (Exception e) {
            org.apache.commons.io.IOUtils.closeQuietly(fis);
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public FileOutputStream getFileOutputStream(@Nullable FsVolumeSpi volume, File f, boolean append) throws FileNotFoundException {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.OPEN);
        WrappedFileOutputStream fos = null;
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.OPEN);
            fos = new WrappedFileOutputStream(volume, f, append);
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.OPEN, begin);
            return fos;
        }
        catch (Exception e) {
            org.apache.commons.io.IOUtils.closeQuietly(fos);
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public FileOutputStream getFileOutputStream(@Nullable FsVolumeSpi volume, File f) throws FileNotFoundException {
        return this.getFileOutputStream(volume, f, false);
    }

    public FileOutputStream getFileOutputStream(@Nullable FsVolumeSpi volume, FileDescriptor fd) {
        return new WrappedFileOutputStream(volume, fd);
    }

    public FileInputStream getShareDeleteFileInputStream(@Nullable FsVolumeSpi volume, File f, long offset) throws IOException {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.OPEN);
        WrappedFileInputStream fis = null;
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.OPEN);
            fis = new WrappedFileInputStream(volume, NativeIO.getShareDeleteFileDescriptor(f, offset));
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.OPEN, begin);
            return fis;
        }
        catch (Exception e) {
            org.apache.commons.io.IOUtils.closeQuietly(fis);
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public FileInputStream openAndSeek(@Nullable FsVolumeSpi volume, File f, long offset) throws IOException {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.OPEN);
        WrappedFileInputStream fis = null;
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.OPEN);
            fis = new WrappedFileInputStream(volume, FsDatasetUtil.openAndSeek(f, offset));
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.OPEN, begin);
            return fis;
        }
        catch (Exception e) {
            org.apache.commons.io.IOUtils.closeQuietly(fis);
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public RandomAccessFile getRandomAccessFile(@Nullable FsVolumeSpi volume, File f, String mode) throws FileNotFoundException {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.OPEN);
        WrappedRandomAccessFile raf = null;
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.OPEN);
            raf = new WrappedRandomAccessFile(volume, f, mode);
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.OPEN, begin);
            return raf;
        }
        catch (Exception e) {
            org.apache.commons.io.IOUtils.closeQuietly(raf);
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public boolean fullyDelete(@Nullable FsVolumeSpi volume, File dir) {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.DELETE);
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.DELETE);
            boolean deleted = FileUtil.fullyDelete(dir);
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.DELETE, begin);
            return deleted;
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public void replaceFile(@Nullable FsVolumeSpi volume, File src, File target) throws IOException {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.MOVE);
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.MOVE);
            FileUtil.replaceFile(src, target);
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.MOVE, begin);
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public void rename(@Nullable FsVolumeSpi volume, File src, File target) throws IOException {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.MOVE);
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.MOVE);
            Storage.rename(src, target);
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.MOVE, begin);
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public void moveFile(@Nullable FsVolumeSpi volume, File src, File target) throws IOException {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.MOVE);
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.MOVE);
            FileUtils.moveFile((File)src, (File)target);
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.MOVE, begin);
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public void move(@Nullable FsVolumeSpi volume, Path src, Path target, CopyOption ... options) throws IOException {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.MOVE);
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.MOVE);
            Files.move(src, target, options);
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.MOVE, begin);
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public void renameTo(@Nullable FsVolumeSpi volume, File src, File target) throws IOException {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.MOVE);
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.MOVE);
            NativeIO.renameTo(src, target);
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.MOVE, begin);
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public void nativeCopyFileUnbuffered(@Nullable FsVolumeSpi volume, File src, File target, boolean preserveFileDate) throws IOException {
        long length = src.length();
        long begin = this.profilingEventHook.beforeFileIo(volume, OPERATION.NATIVE_COPY, length);
        try {
            this.faultInjectorEventHook.beforeFileIo(volume, OPERATION.NATIVE_COPY, length);
            Storage.nativeCopyFileUnbuffered(src, target, preserveFileDate);
            this.profilingEventHook.afterFileIo(volume, OPERATION.NATIVE_COPY, begin, length);
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public boolean mkdirs(@Nullable FsVolumeSpi volume, File dir) throws IOException {
        boolean isDirectory;
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.MKDIRS);
        boolean created = false;
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.MKDIRS);
            created = dir.mkdirs();
            isDirectory = !created && dir.isDirectory();
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.MKDIRS, begin);
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
        if (!created && !isDirectory) {
            throw new IOException("Mkdirs failed to create " + dir);
        }
        return created;
    }

    public void mkdirsWithExistsCheck(@Nullable FsVolumeSpi volume, File dir) throws IOException {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.MKDIRS);
        boolean succeeded = false;
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.MKDIRS);
            succeeded = dir.isDirectory() || dir.mkdirs();
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.MKDIRS, begin);
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
        if (!succeeded) {
            throw new IOException("Mkdirs failed to create " + dir);
        }
    }

    public File[] listFiles(@Nullable FsVolumeSpi volume, File dir) throws IOException {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.LIST);
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.LIST);
            File[] children = FileUtil.listFiles(dir);
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.LIST, begin);
            return children;
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public String[] list(@Nullable FsVolumeSpi volume, File dir) throws IOException {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.LIST);
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.LIST);
            String[] children = FileUtil.list(dir);
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.LIST, begin);
            return children;
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public List<String> listDirectory(@Nullable FsVolumeSpi volume, File dir, FilenameFilter filter) throws IOException {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.LIST);
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.LIST);
            List<String> children = IOUtils.listDirectory(dir, filter);
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.LIST, begin);
            return children;
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public int getHardLinkCount(@Nullable FsVolumeSpi volume, File f) throws IOException {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.LIST);
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.LIST);
            int count = HardLink.getLinkCount(f);
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.LIST, begin);
            return count;
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    public boolean exists(@Nullable FsVolumeSpi volume, File f) {
        long begin = this.profilingEventHook.beforeMetadataOp(volume, OPERATION.EXISTS);
        try {
            this.faultInjectorEventHook.beforeMetadataOp(volume, OPERATION.EXISTS);
            boolean exists = f.exists();
            this.profilingEventHook.afterMetadataOp(volume, OPERATION.EXISTS, begin);
            return exists;
        }
        catch (Exception e) {
            this.onFailure(volume, begin);
            throw e;
        }
    }

    private void onFailure(@Nullable FsVolumeSpi volume, long begin) {
        if (this.datanode != null && volume != null) {
            this.datanode.checkDiskErrorAsync(volume);
        }
        this.profilingEventHook.onFailure(volume, begin);
    }

    private final class WrappedRandomAccessFile
    extends RandomAccessFile {
        @Nullable
        private final FsVolumeSpi volume;

        public WrappedRandomAccessFile(FsVolumeSpi volume, File f, String mode) throws FileNotFoundException {
            super(f, mode);
            this.volume = volume;
        }

        @Override
        public int read() throws IOException {
            long begin = FileIoProvider.this.profilingEventHook.beforeFileIo(this.volume, OPERATION.READ, 4L);
            try {
                FileIoProvider.this.faultInjectorEventHook.beforeFileIo(this.volume, OPERATION.READ, 4L);
                int b = super.read();
                FileIoProvider.this.profilingEventHook.afterFileIo(this.volume, OPERATION.READ, begin, 4L);
                return b;
            }
            catch (Exception e) {
                FileIoProvider.this.onFailure(this.volume, begin);
                throw e;
            }
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            long begin = FileIoProvider.this.profilingEventHook.beforeFileIo(this.volume, OPERATION.READ, len);
            try {
                FileIoProvider.this.faultInjectorEventHook.beforeFileIo(this.volume, OPERATION.READ, len);
                int numBytesRead = super.read(b, off, len);
                FileIoProvider.this.profilingEventHook.afterFileIo(this.volume, OPERATION.READ, begin, numBytesRead);
                return numBytesRead;
            }
            catch (Exception e) {
                FileIoProvider.this.onFailure(this.volume, begin);
                throw e;
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            long begin = FileIoProvider.this.profilingEventHook.beforeFileIo(this.volume, OPERATION.READ, b.length);
            try {
                FileIoProvider.this.faultInjectorEventHook.beforeFileIo(this.volume, OPERATION.READ, b.length);
                int numBytesRead = super.read(b);
                FileIoProvider.this.profilingEventHook.afterFileIo(this.volume, OPERATION.READ, begin, numBytesRead);
                return numBytesRead;
            }
            catch (Exception e) {
                FileIoProvider.this.onFailure(this.volume, begin);
                throw e;
            }
        }

        @Override
        public void write(int b) throws IOException {
            long begin = FileIoProvider.this.profilingEventHook.beforeFileIo(this.volume, OPERATION.WRITE, 4L);
            try {
                FileIoProvider.this.faultInjectorEventHook.beforeFileIo(this.volume, OPERATION.WRITE, 4L);
                super.write(b);
                FileIoProvider.this.profilingEventHook.afterFileIo(this.volume, OPERATION.WRITE, begin, 4L);
            }
            catch (Exception e) {
                FileIoProvider.this.onFailure(this.volume, begin);
                throw e;
            }
        }

        @Override
        public void write(@Nonnull byte[] b) throws IOException {
            long begin = FileIoProvider.this.profilingEventHook.beforeFileIo(this.volume, OPERATION.WRITE, b.length);
            try {
                FileIoProvider.this.faultInjectorEventHook.beforeFileIo(this.volume, OPERATION.WRITE, b.length);
                super.write(b);
                FileIoProvider.this.profilingEventHook.afterFileIo(this.volume, OPERATION.WRITE, begin, b.length);
            }
            catch (Exception e) {
                FileIoProvider.this.onFailure(this.volume, begin);
                throw e;
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            long begin = FileIoProvider.this.profilingEventHook.beforeFileIo(this.volume, OPERATION.WRITE, len);
            try {
                FileIoProvider.this.faultInjectorEventHook.beforeFileIo(this.volume, OPERATION.WRITE, len);
                super.write(b, off, len);
                FileIoProvider.this.profilingEventHook.afterFileIo(this.volume, OPERATION.WRITE, begin, len);
            }
            catch (Exception e) {
                FileIoProvider.this.onFailure(this.volume, begin);
                throw e;
            }
        }
    }

    private final class WrappedFileOutputStream
    extends FileOutputStream {
        @Nullable
        private final FsVolumeSpi volume;

        private WrappedFileOutputStream(FsVolumeSpi volume, File f, boolean append) throws FileNotFoundException {
            super(f, append);
            this.volume = volume;
        }

        private WrappedFileOutputStream(FsVolumeSpi volume, FileDescriptor fd) {
            super(fd);
            this.volume = volume;
        }

        @Override
        public void write(int b) throws IOException {
            long begin = FileIoProvider.this.profilingEventHook.beforeFileIo(this.volume, OPERATION.WRITE, 4L);
            try {
                FileIoProvider.this.faultInjectorEventHook.beforeFileIo(this.volume, OPERATION.WRITE, 4L);
                super.write(b);
                FileIoProvider.this.profilingEventHook.afterFileIo(this.volume, OPERATION.WRITE, begin, 4L);
            }
            catch (Exception e) {
                FileIoProvider.this.onFailure(this.volume, begin);
                throw e;
            }
        }

        @Override
        public void write(@Nonnull byte[] b) throws IOException {
            long begin = FileIoProvider.this.profilingEventHook.beforeFileIo(this.volume, OPERATION.WRITE, b.length);
            try {
                FileIoProvider.this.faultInjectorEventHook.beforeFileIo(this.volume, OPERATION.WRITE, b.length);
                super.write(b);
                FileIoProvider.this.profilingEventHook.afterFileIo(this.volume, OPERATION.WRITE, begin, b.length);
            }
            catch (Exception e) {
                FileIoProvider.this.onFailure(this.volume, begin);
                throw e;
            }
        }

        @Override
        public void write(@Nonnull byte[] b, int off, int len) throws IOException {
            long begin = FileIoProvider.this.profilingEventHook.beforeFileIo(this.volume, OPERATION.WRITE, len);
            try {
                FileIoProvider.this.faultInjectorEventHook.beforeFileIo(this.volume, OPERATION.WRITE, len);
                super.write(b, off, len);
                FileIoProvider.this.profilingEventHook.afterFileIo(this.volume, OPERATION.WRITE, begin, len);
            }
            catch (Exception e) {
                FileIoProvider.this.onFailure(this.volume, begin);
                throw e;
            }
        }
    }

    private final class WrappedFileInputStream
    extends FileInputStream {
        @Nullable
        private final FsVolumeSpi volume;

        private WrappedFileInputStream(FsVolumeSpi volume, File f) throws FileNotFoundException {
            super(f);
            this.volume = volume;
        }

        private WrappedFileInputStream(FsVolumeSpi volume, FileDescriptor fd) {
            super(fd);
            this.volume = volume;
        }

        @Override
        public int read() throws IOException {
            long begin = FileIoProvider.this.profilingEventHook.beforeFileIo(this.volume, OPERATION.READ, 4L);
            try {
                FileIoProvider.this.faultInjectorEventHook.beforeFileIo(this.volume, OPERATION.READ, 4L);
                int b = super.read();
                FileIoProvider.this.profilingEventHook.afterFileIo(this.volume, OPERATION.READ, begin, 4L);
                return b;
            }
            catch (Exception e) {
                FileIoProvider.this.onFailure(this.volume, begin);
                throw e;
            }
        }

        @Override
        public int read(@Nonnull byte[] b) throws IOException {
            long begin = FileIoProvider.this.profilingEventHook.beforeFileIo(this.volume, OPERATION.READ, b.length);
            try {
                FileIoProvider.this.faultInjectorEventHook.beforeFileIo(this.volume, OPERATION.READ, b.length);
                int numBytesRead = super.read(b);
                FileIoProvider.this.profilingEventHook.afterFileIo(this.volume, OPERATION.READ, begin, numBytesRead);
                return numBytesRead;
            }
            catch (Exception e) {
                FileIoProvider.this.onFailure(this.volume, begin);
                throw e;
            }
        }

        @Override
        public int read(@Nonnull byte[] b, int off, int len) throws IOException {
            long begin = FileIoProvider.this.profilingEventHook.beforeFileIo(this.volume, OPERATION.READ, len);
            try {
                FileIoProvider.this.faultInjectorEventHook.beforeFileIo(this.volume, OPERATION.READ, len);
                int numBytesRead = super.read(b, off, len);
                FileIoProvider.this.profilingEventHook.afterFileIo(this.volume, OPERATION.READ, begin, numBytesRead);
                return numBytesRead;
            }
            catch (Exception e) {
                FileIoProvider.this.onFailure(this.volume, begin);
                throw e;
            }
        }
    }

    public static enum OPERATION {
        OPEN,
        EXISTS,
        LIST,
        DELETE,
        MOVE,
        MKDIRS,
        TRANSFER,
        SYNC,
        FADVISE,
        READ,
        WRITE,
        FLUSH,
        NATIVE_COPY;

    }
}

