/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.fs.LocalFileSystem;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.fs.StorageType;
import shaded.org.apache.hadoop.fs.permission.FsPermission;
import shaded.org.apache.hadoop.hdfs.server.datanode.checker.Checkable;
import shaded.org.apache.hadoop.hdfs.server.datanode.checker.VolumeCheckResult;
import shaded.org.apache.hadoop.util.DiskChecker;
import shaded.org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class StorageLocation
implements Checkable<CheckContext, VolumeCheckResult> {
    final StorageType storageType;
    final File file;
    private static final Pattern regex = Pattern.compile("^\\[(\\w*)\\](.+)$");

    private StorageLocation(StorageType storageType, URI uri) {
        this.storageType = storageType;
        if (uri.getScheme() != null && !"file".equalsIgnoreCase(uri.getScheme())) {
            throw new IllegalArgumentException("Unsupported URI schema in " + uri);
        }
        this.file = new File(uri.getPath());
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    URI getUri() {
        return this.file.toURI();
    }

    public File getFile() {
        return this.file;
    }

    public static StorageLocation parse(String rawLocation) throws IOException, SecurityException {
        Matcher matcher = regex.matcher(rawLocation);
        StorageType storageType = StorageType.DEFAULT;
        String location = rawLocation;
        if (matcher.matches()) {
            String classString = matcher.group(1);
            location = matcher.group(2).trim();
            if (!classString.isEmpty()) {
                storageType = StorageType.valueOf(StringUtils.toUpperCase(classString));
            }
        }
        return new StorageLocation(storageType, new Path(location).toUri());
    }

    public String toString() {
        return "[" + (Object)((Object)this.storageType) + "]" + this.file.toURI();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof StorageLocation)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public VolumeCheckResult check(CheckContext context) throws IOException {
        DiskChecker.checkDir(context.localFileSystem, new Path(this.file.toURI()), context.expectedPermission);
        return VolumeCheckResult.HEALTHY;
    }

    public static final class CheckContext {
        private final LocalFileSystem localFileSystem;
        private final FsPermission expectedPermission;

        public CheckContext(LocalFileSystem localFileSystem, FsPermission expectedPermission) {
            this.localFileSystem = localFileSystem;
            this.expectedPermission = expectedPermission;
        }
    }
}

