/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import shaded.org.apache.hadoop.HadoopIllegalArgumentException;
import shaded.org.apache.hadoop.fs.InvalidPathException;
import shaded.org.apache.hadoop.fs.permission.FsAction;
import shaded.org.apache.hadoop.hdfs.DFSUtil;
import shaded.org.apache.hadoop.hdfs.protocol.FSLimitException;
import shaded.org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import shaded.org.apache.hadoop.hdfs.protocol.SnapshotException;
import shaded.org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import shaded.org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import shaded.org.apache.hadoop.hdfs.server.namenode.FSPermissionChecker;
import shaded.org.apache.hadoop.hdfs.server.namenode.INode;
import shaded.org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import shaded.org.apache.hadoop.hdfs.server.namenode.INodesInPath;
import shaded.org.apache.hadoop.hdfs.server.namenode.snapshot.DirectorySnapshottableFeature;
import shaded.org.apache.hadoop.hdfs.server.namenode.snapshot.Snapshot;
import shaded.org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotManager;
import shaded.org.apache.hadoop.hdfs.util.ReadOnlyList;
import shaded.org.apache.hadoop.util.ChunkedArrayList;

class FSDirSnapshotOp {
    FSDirSnapshotOp() {
    }

    static void verifySnapshotName(FSDirectory fsd, String snapshotName, String path) throws FSLimitException.PathComponentTooLongException {
        if (snapshotName.contains("/")) {
            throw new HadoopIllegalArgumentException("Snapshot name cannot contain \"/\"");
        }
        byte[] bytes = DFSUtil.string2Bytes(snapshotName);
        fsd.verifyINodeName(bytes);
        fsd.verifyMaxComponentLength(bytes, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void allowSnapshot(FSDirectory fsd, SnapshotManager snapshotManager, String path) throws IOException {
        fsd.writeLock();
        try {
            snapshotManager.setSnapshottable(path, true);
        }
        finally {
            fsd.writeUnlock();
        }
        fsd.getEditLog().logAllowSnapshot(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disallowSnapshot(FSDirectory fsd, SnapshotManager snapshotManager, String path) throws IOException {
        fsd.writeLock();
        try {
            snapshotManager.resetSnapshottable(path);
        }
        finally {
            fsd.writeUnlock();
        }
        fsd.getEditLog().logDisallowSnapshot(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String createSnapshot(FSDirectory fsd, SnapshotManager snapshotManager, String snapshotRoot, String snapshotName, boolean logRetryCache) throws IOException {
        String snapshotPath;
        FSPermissionChecker pc = fsd.getPermissionChecker();
        INodesInPath iip = fsd.resolvePath(pc, snapshotRoot, FSDirectory.DirOp.WRITE);
        if (fsd.isPermissionEnabled()) {
            fsd.checkOwner(pc, iip);
        }
        if (snapshotName == null || snapshotName.isEmpty()) {
            snapshotName = Snapshot.generateDefaultSnapshotName();
        } else if (!DFSUtil.isValidNameForComponent(snapshotName)) {
            throw new InvalidPathException("Invalid snapshot name: " + snapshotName);
        }
        FSDirSnapshotOp.verifySnapshotName(fsd, snapshotName, snapshotRoot);
        fsd.writeLock();
        try {
            snapshotPath = snapshotManager.createSnapshot(fsd.getFSNamesystem().getLeaseManager(), iip, snapshotRoot, snapshotName);
        }
        finally {
            fsd.writeUnlock();
        }
        fsd.getEditLog().logCreateSnapshot(snapshotRoot, snapshotName, logRetryCache);
        return snapshotPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void renameSnapshot(FSDirectory fsd, SnapshotManager snapshotManager, String path, String snapshotOldName, String snapshotNewName, boolean logRetryCache) throws IOException {
        FSPermissionChecker pc = fsd.getPermissionChecker();
        INodesInPath iip = fsd.resolvePath(pc, path, FSDirectory.DirOp.WRITE);
        if (fsd.isPermissionEnabled()) {
            fsd.checkOwner(pc, iip);
        }
        FSDirSnapshotOp.verifySnapshotName(fsd, snapshotNewName, path);
        fsd.writeLock();
        try {
            snapshotManager.renameSnapshot(iip, path, snapshotOldName, snapshotNewName);
        }
        finally {
            fsd.writeUnlock();
        }
        fsd.getEditLog().logRenameSnapshot(path, snapshotOldName, snapshotNewName, logRetryCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SnapshottableDirectoryStatus[] getSnapshottableDirListing(FSDirectory fsd, SnapshotManager snapshotManager) throws IOException {
        FSPermissionChecker pc = fsd.getPermissionChecker();
        fsd.readLock();
        try {
            String user = pc.isSuperUser() ? null : pc.getUser();
            SnapshottableDirectoryStatus[] snapshottableDirectoryStatusArray = snapshotManager.getSnapshottableDirListing(user);
            return snapshottableDirectoryStatusArray;
        }
        finally {
            fsd.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SnapshotDiffReport getSnapshotDiffReport(FSDirectory fsd, SnapshotManager snapshotManager, String path, String fromSnapshot, String toSnapshot) throws IOException {
        SnapshotDiffReport diffs;
        FSPermissionChecker pc = fsd.getPermissionChecker();
        fsd.readLock();
        try {
            INodesInPath iip = fsd.resolvePath(pc, path, FSDirectory.DirOp.READ);
            if (fsd.isPermissionEnabled()) {
                FSDirSnapshotOp.checkSubtreeReadPermission(fsd, pc, path, fromSnapshot);
                FSDirSnapshotOp.checkSubtreeReadPermission(fsd, pc, path, toSnapshot);
            }
            diffs = snapshotManager.diff(iip, path, fromSnapshot, toSnapshot);
        }
        finally {
            fsd.readUnlock();
        }
        return diffs;
    }

    static Collection<String> getSnapshotFiles(FSDirectory fsd, List<DirectorySnapshottableFeature> lsf, String file) throws IOException {
        ArrayList<String> snaps = new ArrayList<String>();
        for (DirectorySnapshottableFeature sf : lsf) {
            Snapshot s;
            String dirName;
            ReadOnlyList<Snapshot> lsnap = sf.getSnapshotList();
            Iterator i$ = lsnap.iterator();
            while (i$.hasNext() && file.startsWith(dirName = (s = (Snapshot)i$.next()).getRoot().getRootFullPathName())) {
                String snapname = s.getRoot().getFullPathName();
                if (dirName.equals("/")) {
                    snapname = snapname + "/";
                }
                snapname = snapname + file.substring(file.indexOf(dirName) + dirName.length());
                if (fsd.getFSNamesystem().getFileInfo(snapname, true) == null) continue;
                snaps.add(snapname);
            }
        }
        return snaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static INode.BlocksMapUpdateInfo deleteSnapshot(FSDirectory fsd, SnapshotManager snapshotManager, String snapshotRoot, String snapshotName, boolean logRetryCache) throws IOException {
        FSPermissionChecker pc = fsd.getPermissionChecker();
        INodesInPath iip = fsd.resolvePath(pc, snapshotRoot, FSDirectory.DirOp.WRITE);
        if (fsd.isPermissionEnabled()) {
            fsd.checkOwner(pc, iip);
        }
        INode.BlocksMapUpdateInfo collectedBlocks = new INode.BlocksMapUpdateInfo();
        ChunkedArrayList<INode> removedINodes = new ChunkedArrayList<INode>();
        INode.ReclaimContext context = new INode.ReclaimContext(fsd.getBlockStoragePolicySuite(), collectedBlocks, removedINodes, null);
        fsd.writeLock();
        try {
            snapshotManager.deleteSnapshot(iip, snapshotName, context);
            fsd.updateCount(iip, context.quotaDelta(), false);
            fsd.removeFromInodeMap(removedINodes);
            fsd.updateReplicationFactor(context.collectedBlocks().toUpdateReplicationInfo());
        }
        finally {
            fsd.writeUnlock();
        }
        removedINodes.clear();
        fsd.getEditLog().logDeleteSnapshot(snapshotRoot, snapshotName, logRetryCache);
        return collectedBlocks;
    }

    private static void checkSubtreeReadPermission(FSDirectory fsd, FSPermissionChecker pc, String snapshottablePath, String snapshot) throws IOException {
        String fromPath = snapshot == null ? snapshottablePath : Snapshot.getSnapshotPath(snapshottablePath, snapshot);
        INodesInPath iip = fsd.resolvePath(pc, fromPath, FSDirectory.DirOp.READ);
        fsd.checkPermission(pc, iip, false, null, null, FsAction.READ, FsAction.READ);
    }

    private static void checkSnapshot(INode target, List<INodeDirectory> snapshottableDirs) throws SnapshotException {
        if (target.isDirectory()) {
            INodeDirectory targetDir = target.asDirectory();
            DirectorySnapshottableFeature sf = targetDir.getDirectorySnapshottableFeature();
            if (sf != null) {
                if (sf.getNumSnapshots() > 0) {
                    String fullPath = targetDir.getFullPathName();
                    throw new SnapshotException("The directory " + fullPath + " cannot be deleted since " + fullPath + " is snapshottable and already has snapshots");
                }
                if (snapshottableDirs != null) {
                    snapshottableDirs.add(targetDir);
                }
            }
            for (INode child : targetDir.getChildrenList(0x7FFFFFFE)) {
                FSDirSnapshotOp.checkSnapshot(child, snapshottableDirs);
            }
        }
    }

    static void checkSnapshot(FSDirectory fsd, INodesInPath iip, List<INodeDirectory> snapshottableDirs) throws SnapshotException {
        SnapshotManager sm = fsd.getFSNamesystem().getSnapshotManager();
        if (sm.getNumSnapshottableDirs() > 0) {
            FSDirSnapshotOp.checkSnapshot(iip.getLastINode(), snapshottableDirs);
        }
    }
}

