/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.namenode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.protobuf.BlockingService;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import shaded.org.apache.hadoop.HadoopIllegalArgumentException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.conf.ReconfigurationTaskStatus;
import shaded.org.apache.hadoop.crypto.CryptoProtocolVersion;
import shaded.org.apache.hadoop.fs.BatchedRemoteIterator;
import shaded.org.apache.hadoop.fs.CacheFlag;
import shaded.org.apache.hadoop.fs.ContentSummary;
import shaded.org.apache.hadoop.fs.CreateFlag;
import shaded.org.apache.hadoop.fs.FileAlreadyExistsException;
import shaded.org.apache.hadoop.fs.FsServerDefaults;
import shaded.org.apache.hadoop.fs.InvalidPathException;
import shaded.org.apache.hadoop.fs.Options;
import shaded.org.apache.hadoop.fs.ParentNotDirectoryException;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.fs.QuotaUsage;
import shaded.org.apache.hadoop.fs.StorageType;
import shaded.org.apache.hadoop.fs.UnresolvedLinkException;
import shaded.org.apache.hadoop.fs.XAttr;
import shaded.org.apache.hadoop.fs.XAttrSetFlag;
import shaded.org.apache.hadoop.fs.permission.AclEntry;
import shaded.org.apache.hadoop.fs.permission.AclStatus;
import shaded.org.apache.hadoop.fs.permission.FsAction;
import shaded.org.apache.hadoop.fs.permission.FsPermission;
import shaded.org.apache.hadoop.fs.permission.PermissionStatus;
import shaded.org.apache.hadoop.ha.HAServiceProtocol;
import shaded.org.apache.hadoop.ha.HAServiceStatus;
import shaded.org.apache.hadoop.ha.HealthCheckFailedException;
import shaded.org.apache.hadoop.ha.ServiceFailedException;
import shaded.org.apache.hadoop.ha.proto.HAServiceProtocolProtos;
import shaded.org.apache.hadoop.ha.protocolPB.HAServiceProtocolPB;
import shaded.org.apache.hadoop.ha.protocolPB.HAServiceProtocolServerSideTranslatorPB;
import shaded.org.apache.hadoop.hdfs.AddBlockFlag;
import shaded.org.apache.hadoop.hdfs.DFSUtil;
import shaded.org.apache.hadoop.hdfs.HDFSPolicyProvider;
import shaded.org.apache.hadoop.hdfs.inotify.EventBatch;
import shaded.org.apache.hadoop.hdfs.inotify.EventBatchList;
import shaded.org.apache.hadoop.hdfs.protocol.AclException;
import shaded.org.apache.hadoop.hdfs.protocol.AlreadyBeingCreatedException;
import shaded.org.apache.hadoop.hdfs.protocol.BlockListAsLongs;
import shaded.org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import shaded.org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import shaded.org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import shaded.org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import shaded.org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import shaded.org.apache.hadoop.hdfs.protocol.CorruptFileBlocks;
import shaded.org.apache.hadoop.hdfs.protocol.DSQuotaExceededException;
import shaded.org.apache.hadoop.hdfs.protocol.DatanodeID;
import shaded.org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import shaded.org.apache.hadoop.hdfs.protocol.DirectoryListing;
import shaded.org.apache.hadoop.hdfs.protocol.EncryptionZone;
import shaded.org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import shaded.org.apache.hadoop.hdfs.protocol.FSLimitException;
import shaded.org.apache.hadoop.hdfs.protocol.HdfsConstants;
import shaded.org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import shaded.org.apache.hadoop.hdfs.protocol.LastBlockWithStatus;
import shaded.org.apache.hadoop.hdfs.protocol.LocatedBlock;
import shaded.org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import shaded.org.apache.hadoop.hdfs.protocol.NSQuotaExceededException;
import shaded.org.apache.hadoop.hdfs.protocol.OpenFileEntry;
import shaded.org.apache.hadoop.hdfs.protocol.QuotaByStorageTypeExceededException;
import shaded.org.apache.hadoop.hdfs.protocol.QuotaExceededException;
import shaded.org.apache.hadoop.hdfs.protocol.RecoveryInProgressException;
import shaded.org.apache.hadoop.hdfs.protocol.RollingUpgradeInfo;
import shaded.org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import shaded.org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import shaded.org.apache.hadoop.hdfs.protocol.UnregisteredNodeException;
import shaded.org.apache.hadoop.hdfs.protocol.UnresolvedPathException;
import shaded.org.apache.hadoop.hdfs.protocol.proto.ClientNamenodeProtocolProtos;
import shaded.org.apache.hadoop.hdfs.protocol.proto.DatanodeLifelineProtocolProtos;
import shaded.org.apache.hadoop.hdfs.protocol.proto.DatanodeProtocolProtos;
import shaded.org.apache.hadoop.hdfs.protocol.proto.NamenodeProtocolProtos;
import shaded.org.apache.hadoop.hdfs.protocol.proto.ReconfigurationProtocolProtos;
import shaded.org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolPB;
import shaded.org.apache.hadoop.hdfs.protocolPB.ClientNamenodeProtocolServerSideTranslatorPB;
import shaded.org.apache.hadoop.hdfs.protocolPB.DatanodeLifelineProtocolPB;
import shaded.org.apache.hadoop.hdfs.protocolPB.DatanodeLifelineProtocolServerSideTranslatorPB;
import shaded.org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolPB;
import shaded.org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolServerSideTranslatorPB;
import shaded.org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolPB;
import shaded.org.apache.hadoop.hdfs.protocolPB.NamenodeProtocolServerSideTranslatorPB;
import shaded.org.apache.hadoop.hdfs.protocolPB.ReconfigurationProtocolPB;
import shaded.org.apache.hadoop.hdfs.protocolPB.ReconfigurationProtocolServerSideTranslatorPB;
import shaded.org.apache.hadoop.hdfs.security.token.block.DataEncryptionKey;
import shaded.org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import shaded.org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import shaded.org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerFaultInjector;
import shaded.org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import shaded.org.apache.hadoop.hdfs.server.common.HttpGetFailedException;
import shaded.org.apache.hadoop.hdfs.server.common.IncorrectVersionException;
import shaded.org.apache.hadoop.hdfs.server.namenode.CheckpointSignature;
import shaded.org.apache.hadoop.hdfs.server.namenode.EditLogInputStream;
import shaded.org.apache.hadoop.hdfs.server.namenode.FSEditLog;
import shaded.org.apache.hadoop.hdfs.server.namenode.FSEditLogOp;
import shaded.org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import shaded.org.apache.hadoop.hdfs.server.namenode.GlobalStateIdContext;
import shaded.org.apache.hadoop.hdfs.server.namenode.InotifyFSEditLogOpTranslator;
import shaded.org.apache.hadoop.hdfs.server.namenode.LeaseExpiredException;
import shaded.org.apache.hadoop.hdfs.server.namenode.NameNode;
import shaded.org.apache.hadoop.hdfs.server.namenode.SafeModeException;
import shaded.org.apache.hadoop.hdfs.server.namenode.UnsupportedActionException;
import shaded.org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import shaded.org.apache.hadoop.hdfs.server.protocol.BlockReportContext;
import shaded.org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import shaded.org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import shaded.org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import shaded.org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import shaded.org.apache.hadoop.hdfs.server.protocol.FinalizeCommand;
import shaded.org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import shaded.org.apache.hadoop.hdfs.server.protocol.NamenodeCommand;
import shaded.org.apache.hadoop.hdfs.server.protocol.NamenodeProtocols;
import shaded.org.apache.hadoop.hdfs.server.protocol.NamenodeRegistration;
import shaded.org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import shaded.org.apache.hadoop.hdfs.server.protocol.NodeRegistration;
import shaded.org.apache.hadoop.hdfs.server.protocol.RegisterCommand;
import shaded.org.apache.hadoop.hdfs.server.protocol.RemoteEditLogManifest;
import shaded.org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import shaded.org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import shaded.org.apache.hadoop.hdfs.server.protocol.StorageBlockReport;
import shaded.org.apache.hadoop.hdfs.server.protocol.StorageReceivedDeletedBlocks;
import shaded.org.apache.hadoop.hdfs.server.protocol.StorageReport;
import shaded.org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import shaded.org.apache.hadoop.io.EnumSetWritable;
import shaded.org.apache.hadoop.io.Text;
import shaded.org.apache.hadoop.ipc.ProtobufRpcEngine;
import shaded.org.apache.hadoop.ipc.RPC;
import shaded.org.apache.hadoop.ipc.RefreshRegistry;
import shaded.org.apache.hadoop.ipc.RefreshResponse;
import shaded.org.apache.hadoop.ipc.RetriableException;
import shaded.org.apache.hadoop.ipc.RetryCache;
import shaded.org.apache.hadoop.ipc.Server;
import shaded.org.apache.hadoop.ipc.StandbyException;
import shaded.org.apache.hadoop.ipc.WritableRpcEngine;
import shaded.org.apache.hadoop.ipc.proto.GenericRefreshProtocolProtos;
import shaded.org.apache.hadoop.ipc.proto.RefreshCallQueueProtocolProtos;
import shaded.org.apache.hadoop.ipc.protocolPB.GenericRefreshProtocolPB;
import shaded.org.apache.hadoop.ipc.protocolPB.GenericRefreshProtocolServerSideTranslatorPB;
import shaded.org.apache.hadoop.ipc.protocolPB.RefreshCallQueueProtocolPB;
import shaded.org.apache.hadoop.ipc.protocolPB.RefreshCallQueueProtocolServerSideTranslatorPB;
import shaded.org.apache.hadoop.net.Node;
import shaded.org.apache.hadoop.security.AccessControlException;
import shaded.org.apache.hadoop.security.Groups;
import shaded.org.apache.hadoop.security.SecurityUtil;
import shaded.org.apache.hadoop.security.UserGroupInformation;
import shaded.org.apache.hadoop.security.authorize.AuthorizationException;
import shaded.org.apache.hadoop.security.authorize.ProxyUsers;
import shaded.org.apache.hadoop.security.proto.RefreshAuthorizationPolicyProtocolProtos;
import shaded.org.apache.hadoop.security.proto.RefreshUserMappingsProtocolProtos;
import shaded.org.apache.hadoop.security.protocolPB.RefreshAuthorizationPolicyProtocolPB;
import shaded.org.apache.hadoop.security.protocolPB.RefreshAuthorizationPolicyProtocolServerSideTranslatorPB;
import shaded.org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolPB;
import shaded.org.apache.hadoop.security.protocolPB.RefreshUserMappingsProtocolServerSideTranslatorPB;
import shaded.org.apache.hadoop.security.token.SecretManager;
import shaded.org.apache.hadoop.security.token.Token;
import shaded.org.apache.hadoop.tools.proto.GetUserMappingsProtocolProtos;
import shaded.org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolPB;
import shaded.org.apache.hadoop.tools.protocolPB.GetUserMappingsProtocolServerSideTranslatorPB;
import shaded.org.apache.hadoop.tracing.SpanReceiverInfo;
import shaded.org.apache.hadoop.tracing.TraceAdminPB;
import shaded.org.apache.hadoop.tracing.TraceAdminProtocolPB;
import shaded.org.apache.hadoop.tracing.TraceAdminProtocolServerSideTranslatorPB;
import shaded.org.apache.hadoop.util.Time;
import shaded.org.apache.hadoop.util.VersionInfo;
import shaded.org.apache.hadoop.util.VersionUtil;

@InterfaceAudience.Private
@VisibleForTesting
public class NameNodeRpcServer
implements NamenodeProtocols {
    private static final Logger LOG = NameNode.LOG;
    private static final Logger stateChangeLog = NameNode.stateChangeLog;
    private static final Logger blockStateChangeLog = NameNode.blockStateChangeLog;
    protected final FSNamesystem namesystem;
    protected final NameNode nn;
    private final NameNodeMetrics metrics;
    private final RetryCache retryCache;
    private final boolean serviceAuthEnabled;
    private final RPC.Server serviceRpcServer;
    private final InetSocketAddress serviceRPCAddress;
    private final RPC.Server lifelineRpcServer;
    private final InetSocketAddress lifelineRPCAddress;
    protected final RPC.Server clientRpcServer;
    protected final InetSocketAddress clientRpcAddress;
    private final String minimumDataNodeVersion;

    public NameNodeRpcServer(Configuration conf, NameNode nn) throws IOException {
        int[] auxiliaryPorts;
        this.nn = nn;
        this.namesystem = nn.getNamesystem();
        this.retryCache = this.namesystem.getRetryCache();
        this.metrics = NameNode.getNameNodeMetrics();
        int handlerCount = conf.getInt("dfs.namenode.handler.count", 10);
        RPC.setProtocolEngine(conf, ClientNamenodeProtocolPB.class, ProtobufRpcEngine.class);
        ClientNamenodeProtocolServerSideTranslatorPB clientProtocolServerTranslator = new ClientNamenodeProtocolServerSideTranslatorPB(this);
        BlockingService clientNNPbService = ClientNamenodeProtocolProtos.ClientNamenodeProtocol.newReflectiveBlockingService((ClientNamenodeProtocolProtos.ClientNamenodeProtocol.BlockingInterface)clientProtocolServerTranslator);
        int maxDataLength = conf.getInt("ipc.maximum.data.length", 0x4000000);
        DatanodeProtocolServerSideTranslatorPB dnProtoPbTranslator = new DatanodeProtocolServerSideTranslatorPB(this, maxDataLength);
        BlockingService dnProtoPbService = DatanodeProtocolProtos.DatanodeProtocolService.newReflectiveBlockingService(dnProtoPbTranslator);
        DatanodeLifelineProtocolServerSideTranslatorPB lifelineProtoPbTranslator = new DatanodeLifelineProtocolServerSideTranslatorPB(this);
        BlockingService lifelineProtoPbService = DatanodeLifelineProtocolProtos.DatanodeLifelineProtocolService.newReflectiveBlockingService(lifelineProtoPbTranslator);
        NamenodeProtocolServerSideTranslatorPB namenodeProtocolXlator = new NamenodeProtocolServerSideTranslatorPB(this);
        BlockingService NNPbService = NamenodeProtocolProtos.NamenodeProtocolService.newReflectiveBlockingService(namenodeProtocolXlator);
        RefreshAuthorizationPolicyProtocolServerSideTranslatorPB refreshAuthPolicyXlator = new RefreshAuthorizationPolicyProtocolServerSideTranslatorPB(this);
        BlockingService refreshAuthService = RefreshAuthorizationPolicyProtocolProtos.RefreshAuthorizationPolicyProtocolService.newReflectiveBlockingService(refreshAuthPolicyXlator);
        RefreshUserMappingsProtocolServerSideTranslatorPB refreshUserMappingXlator = new RefreshUserMappingsProtocolServerSideTranslatorPB(this);
        BlockingService refreshUserMappingService = RefreshUserMappingsProtocolProtos.RefreshUserMappingsProtocolService.newReflectiveBlockingService(refreshUserMappingXlator);
        RefreshCallQueueProtocolServerSideTranslatorPB refreshCallQueueXlator = new RefreshCallQueueProtocolServerSideTranslatorPB(this);
        BlockingService refreshCallQueueService = RefreshCallQueueProtocolProtos.RefreshCallQueueProtocolService.newReflectiveBlockingService(refreshCallQueueXlator);
        GenericRefreshProtocolServerSideTranslatorPB genericRefreshXlator = new GenericRefreshProtocolServerSideTranslatorPB(this);
        BlockingService genericRefreshService = GenericRefreshProtocolProtos.GenericRefreshProtocolService.newReflectiveBlockingService(genericRefreshXlator);
        GetUserMappingsProtocolServerSideTranslatorPB getUserMappingXlator = new GetUserMappingsProtocolServerSideTranslatorPB(this);
        BlockingService getUserMappingService = GetUserMappingsProtocolProtos.GetUserMappingsProtocolService.newReflectiveBlockingService(getUserMappingXlator);
        HAServiceProtocolServerSideTranslatorPB haServiceProtocolXlator = new HAServiceProtocolServerSideTranslatorPB(this);
        BlockingService haPbService = HAServiceProtocolProtos.HAServiceProtocolService.newReflectiveBlockingService(haServiceProtocolXlator);
        ReconfigurationProtocolServerSideTranslatorPB reconfigurationProtocolXlator = new ReconfigurationProtocolServerSideTranslatorPB(this);
        BlockingService reconfigurationPbService = ReconfigurationProtocolProtos.ReconfigurationProtocolService.newReflectiveBlockingService((ReconfigurationProtocolProtos.ReconfigurationProtocolService.BlockingInterface)reconfigurationProtocolXlator);
        TraceAdminProtocolServerSideTranslatorPB traceAdminXlator = new TraceAdminProtocolServerSideTranslatorPB(this);
        BlockingService traceAdminService = TraceAdminPB.TraceAdminService.newReflectiveBlockingService(traceAdminXlator);
        WritableRpcEngine.ensureInitialized();
        InetSocketAddress serviceRpcAddr = nn.getServiceRpcServerAddress(conf);
        if (serviceRpcAddr != null) {
            String bindHost = nn.getServiceRpcServerBindHost(conf);
            if (bindHost == null) {
                bindHost = serviceRpcAddr.getHostName();
            }
            LOG.info("Service RPC server is binding to " + bindHost + ":" + serviceRpcAddr.getPort());
            int serviceHandlerCount = conf.getInt("dfs.namenode.service.handler.count", 10);
            this.serviceRpcServer = new RPC.Builder(conf).setProtocol(ClientNamenodeProtocolPB.class).setInstance(clientNNPbService).setBindAddress(bindHost).setPort(serviceRpcAddr.getPort()).setNumHandlers(serviceHandlerCount).setVerbose(false).setSecretManager(this.namesystem.getDelegationTokenSecretManager()).build();
            DFSUtil.addPBProtocol(conf, HAServiceProtocolPB.class, haPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, ReconfigurationProtocolPB.class, reconfigurationPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, NamenodeProtocolPB.class, NNPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, DatanodeProtocolPB.class, dnProtoPbService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, RefreshAuthorizationPolicyProtocolPB.class, refreshAuthService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, RefreshUserMappingsProtocolPB.class, refreshUserMappingService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, RefreshCallQueueProtocolPB.class, refreshCallQueueService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, GenericRefreshProtocolPB.class, genericRefreshService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, GetUserMappingsProtocolPB.class, getUserMappingService, this.serviceRpcServer);
            DFSUtil.addPBProtocol(conf, TraceAdminProtocolPB.class, traceAdminService, this.serviceRpcServer);
            InetSocketAddress listenAddr = this.serviceRpcServer.getListenerAddress();
            this.serviceRPCAddress = new InetSocketAddress(serviceRpcAddr.getHostName(), listenAddr.getPort());
            nn.setRpcServiceServerAddress(conf, this.serviceRPCAddress);
        } else {
            this.serviceRpcServer = null;
            this.serviceRPCAddress = null;
        }
        InetSocketAddress lifelineRpcAddr = nn.getLifelineRpcServerAddress(conf);
        if (lifelineRpcAddr != null) {
            RPC.setProtocolEngine(conf, HAServiceProtocolPB.class, ProtobufRpcEngine.class);
            String bindHost = nn.getLifelineRpcServerBindHost(conf);
            if (bindHost == null) {
                bindHost = lifelineRpcAddr.getHostName();
            }
            LOG.info("Lifeline RPC server is binding to {}:{}", (Object)bindHost, (Object)lifelineRpcAddr.getPort());
            int lifelineHandlerCount = conf.getInt("dfs.namenode.lifeline.handler.count", 0);
            if (lifelineHandlerCount <= 0) {
                float lifelineHandlerRatio = conf.getFloat("dfs.namenode.lifeline.handler.ratio", 0.1f);
                lifelineHandlerCount = Math.max((int)((float)handlerCount * lifelineHandlerRatio), 1);
            }
            this.lifelineRpcServer = new RPC.Builder(conf).setProtocol(HAServiceProtocolPB.class).setInstance(haPbService).setBindAddress(bindHost).setPort(lifelineRpcAddr.getPort()).setNumHandlers(lifelineHandlerCount).setVerbose(false).setSecretManager(this.namesystem.getDelegationTokenSecretManager()).build();
            DFSUtil.addPBProtocol(conf, DatanodeLifelineProtocolPB.class, lifelineProtoPbService, this.lifelineRpcServer);
            InetSocketAddress listenAddr = this.lifelineRpcServer.getListenerAddress();
            this.lifelineRPCAddress = new InetSocketAddress(lifelineRpcAddr.getHostName(), listenAddr.getPort());
            nn.setRpcLifelineServerAddress(conf, this.lifelineRPCAddress);
        } else {
            this.lifelineRpcServer = null;
            this.lifelineRPCAddress = null;
        }
        InetSocketAddress rpcAddr = nn.getRpcServerAddress(conf);
        String bindHost = nn.getRpcServerBindHost(conf);
        if (bindHost == null) {
            bindHost = rpcAddr.getHostName();
        }
        LOG.info("RPC server is binding to " + bindHost + ":" + rpcAddr.getPort());
        boolean enableStateContext = conf.getBoolean("dfs.namenode.state.context.enabled", false);
        LOG.info("Enable NameNode state context:" + enableStateContext);
        GlobalStateIdContext stateIdContext = null;
        if (enableStateContext) {
            stateIdContext = new GlobalStateIdContext(this.namesystem);
        }
        this.clientRpcServer = new RPC.Builder(conf).setProtocol(ClientNamenodeProtocolPB.class).setInstance(clientNNPbService).setBindAddress(bindHost).setPort(rpcAddr.getPort()).setNumHandlers(handlerCount).setVerbose(false).setSecretManager(this.namesystem.getDelegationTokenSecretManager()).setAlignmentContext(stateIdContext).build();
        DFSUtil.addPBProtocol(conf, HAServiceProtocolPB.class, haPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, ReconfigurationProtocolPB.class, reconfigurationPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, NamenodeProtocolPB.class, NNPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, DatanodeProtocolPB.class, dnProtoPbService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, RefreshAuthorizationPolicyProtocolPB.class, refreshAuthService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, RefreshUserMappingsProtocolPB.class, refreshUserMappingService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, RefreshCallQueueProtocolPB.class, refreshCallQueueService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, GenericRefreshProtocolPB.class, genericRefreshService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, GetUserMappingsProtocolPB.class, getUserMappingService, this.clientRpcServer);
        DFSUtil.addPBProtocol(conf, TraceAdminProtocolPB.class, traceAdminService, this.clientRpcServer);
        this.serviceAuthEnabled = conf.getBoolean("hadoop.security.authorization", false);
        if (this.serviceAuthEnabled) {
            this.clientRpcServer.refreshServiceAcl(conf, new HDFSPolicyProvider());
            if (this.serviceRpcServer != null) {
                this.serviceRpcServer.refreshServiceAcl(conf, new HDFSPolicyProvider());
            }
            if (this.lifelineRpcServer != null) {
                this.lifelineRpcServer.refreshServiceAcl(conf, new HDFSPolicyProvider());
            }
        }
        InetSocketAddress listenAddr = this.clientRpcServer.getListenerAddress();
        this.clientRpcAddress = new InetSocketAddress(rpcAddr.getHostName(), listenAddr.getPort());
        nn.setRpcServerAddress(conf, this.clientRpcAddress);
        this.minimumDataNodeVersion = conf.get("dfs.namenode.min.supported.datanode.version", "2.1.0-beta");
        this.clientRpcServer.addTerseExceptions(SafeModeException.class, FileNotFoundException.class, HadoopIllegalArgumentException.class, FileAlreadyExistsException.class, InvalidPathException.class, ParentNotDirectoryException.class, UnresolvedLinkException.class, AlreadyBeingCreatedException.class, QuotaExceededException.class, RecoveryInProgressException.class, AccessControlException.class, SecretManager.InvalidToken.class, LeaseExpiredException.class, NSQuotaExceededException.class, DSQuotaExceededException.class, QuotaByStorageTypeExceededException.class, AclException.class, FSLimitException.PathComponentTooLongException.class, FSLimitException.MaxDirectoryItemsExceededException.class);
        this.clientRpcServer.addSuppressedLoggingExceptions(StandbyException.class, UnresolvedPathException.class);
        this.clientRpcServer.setTracer(nn.tracer);
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.setTracer(nn.tracer);
        }
        if (this.lifelineRpcServer != null) {
            this.lifelineRpcServer.setTracer(nn.tracer);
        }
        if ((auxiliaryPorts = conf.getInts("dfs.namenode.rpc-address.auxiliary-ports")) != null && auxiliaryPorts.length != 0) {
            for (int auxiliaryPort : auxiliaryPorts) {
                this.clientRpcServer.addAuxiliaryListener(auxiliaryPort);
            }
        }
    }

    @VisibleForTesting
    RPC.Server getLifelineRpcServer() {
        return this.lifelineRpcServer;
    }

    @VisibleForTesting
    public RPC.Server getClientRpcServer() {
        return this.clientRpcServer;
    }

    @VisibleForTesting
    RPC.Server getServiceRpcServer() {
        return this.serviceRpcServer;
    }

    void start() {
        this.clientRpcServer.start();
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.start();
        }
        if (this.lifelineRpcServer != null) {
            this.lifelineRpcServer.start();
        }
    }

    void join() throws InterruptedException {
        this.clientRpcServer.join();
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.join();
        }
        if (this.lifelineRpcServer != null) {
            this.lifelineRpcServer.join();
        }
    }

    void stop() {
        if (this.clientRpcServer != null) {
            this.clientRpcServer.stop();
        }
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.stop();
        }
        if (this.lifelineRpcServer != null) {
            this.lifelineRpcServer.stop();
        }
    }

    InetSocketAddress getLifelineRpcAddress() {
        return this.lifelineRPCAddress;
    }

    InetSocketAddress getServiceRpcAddress() {
        return this.serviceRPCAddress;
    }

    @VisibleForTesting
    public InetSocketAddress getRpcAddress() {
        return this.clientRpcAddress;
    }

    @VisibleForTesting
    public Set<InetSocketAddress> getAuxiliaryRpcAddresses() {
        return this.clientRpcServer.getAuxiliaryListenerAddresses();
    }

    private static UserGroupInformation getRemoteUser() throws IOException {
        return NameNode.getRemoteUser();
    }

    @Override
    public BlocksWithLocations getBlocks(DatanodeInfo datanode, long size) throws IOException {
        if (size <= 0L) {
            throw new IllegalArgumentException("Unexpected not positive size: " + size);
        }
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getBlocks((DatanodeID)datanode, size);
    }

    @Override
    public ExportedBlockKeys getBlockKeys() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getBlockManager().getBlockKeys();
    }

    @Override
    public void errorReport(NamenodeRegistration registration, int errorCode, String msg) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.namesystem.checkSuperuserPrivilege();
        this.verifyRequest(registration);
        LOG.info("Error report from " + registration + ": " + msg);
        if (errorCode == 1) {
            this.namesystem.releaseBackupNode(registration);
        }
    }

    @Override
    public NamenodeRegistration registerSubordinateNamenode(NamenodeRegistration registration) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        this.verifyLayoutVersion(registration.getVersion());
        NamenodeRegistration myRegistration = this.nn.setRegistration();
        this.namesystem.registerBackupNode(registration, myRegistration);
        return myRegistration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamenodeCommand startCheckpoint(NamenodeRegistration registration) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        this.verifyRequest(registration);
        if (!this.nn.isRole(HdfsServerConstants.NamenodeRole.NAMENODE)) {
            throw new IOException("Only an ACTIVE node can invoke startCheckpoint.");
        }
        RetryCache.CacheEntryWithPayload cacheEntry = RetryCache.waitForCompletion(this.retryCache, null);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return (NamenodeCommand)cacheEntry.getPayload();
        }
        NamenodeCommand ret = null;
        try {
            ret = this.namesystem.startCheckpoint(registration, this.nn.setRegistration());
            RetryCache.setState(cacheEntry, ret != null, ret);
        }
        catch (Throwable throwable) {
            RetryCache.setState(cacheEntry, ret != null, ret);
            throw throwable;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endCheckpoint(NamenodeRegistration registration, CheckpointSignature sig) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.endCheckpoint(registration, sig);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    public Token<DelegationTokenIdentifier> getDelegationToken(Text renewer) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getDelegationToken(renewer);
    }

    public long renewDelegationToken(Token<DelegationTokenIdentifier> token) throws SecretManager.InvalidToken, IOException {
        this.checkNNStartup();
        return this.namesystem.renewDelegationToken(token);
    }

    public void cancelDelegationToken(Token<DelegationTokenIdentifier> token) throws IOException {
        this.checkNNStartup();
        this.namesystem.cancelDelegationToken(token);
    }

    public LocatedBlocks getBlockLocations(String src, long offset, long length) throws IOException {
        this.checkNNStartup();
        this.metrics.incrGetBlockLocations();
        LocatedBlocks locatedBlocks = this.namesystem.getBlockLocations(NameNodeRpcServer.getClientMachine(), src, offset, length);
        return locatedBlocks;
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        this.checkNNStartup();
        return this.namesystem.getServerDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HdfsFileStatus create(String src, FsPermission masked, String clientName, EnumSetWritable<CreateFlag> flag, boolean createParent, short replication, long blockSize, CryptoProtocolVersion[] supportedVersions) throws IOException {
        this.checkNNStartup();
        String clientMachine = NameNodeRpcServer.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.create: file " + src + " for " + clientName + " at " + clientMachine);
        }
        if (!this.checkPathLength(src)) {
            throw new IOException("create: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntryWithPayload cacheEntry = RetryCache.waitForCompletion(this.retryCache, null);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return (HdfsFileStatus)cacheEntry.getPayload();
        }
        HdfsFileStatus status = null;
        try {
            PermissionStatus perm = new PermissionStatus(NameNodeRpcServer.getRemoteUser().getShortUserName(), null, masked);
            status = this.namesystem.startFile(src, perm, clientName, clientMachine, flag.get(), createParent, replication, blockSize, supportedVersions, cacheEntry != null);
            RetryCache.setState(cacheEntry, status != null, status);
        }
        catch (Throwable throwable) {
            RetryCache.setState(cacheEntry, status != null, status);
            throw throwable;
        }
        this.metrics.incrFilesCreated();
        this.metrics.incrCreateFileOps();
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LastBlockWithStatus append(String src, String clientName, EnumSetWritable<CreateFlag> flag) throws IOException {
        this.checkNNStartup();
        String clientMachine = NameNodeRpcServer.getClientMachine();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.append: file " + src + " for " + clientName + " at " + clientMachine);
        }
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntryWithPayload cacheEntry = RetryCache.waitForCompletion(this.retryCache, null);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return (LastBlockWithStatus)cacheEntry.getPayload();
        }
        LastBlockWithStatus info = null;
        boolean success = false;
        try {
            info = this.namesystem.appendFile(src, clientName, clientMachine, flag.get(), cacheEntry != null);
            success = true;
        }
        catch (Throwable throwable) {
            RetryCache.setState(cacheEntry, success, info);
            throw throwable;
        }
        RetryCache.setState(cacheEntry, success, info);
        this.metrics.incrFilesAppended();
        return info;
    }

    public boolean recoverLease(String src, String clientName) throws IOException {
        this.checkNNStartup();
        String clientMachine = NameNodeRpcServer.getClientMachine();
        return this.namesystem.recoverLease(src, clientName, clientMachine);
    }

    public boolean setReplication(String src, short replication) throws IOException {
        this.checkNNStartup();
        return this.namesystem.setReplication(src, replication);
    }

    public void unsetStoragePolicy(String src) throws IOException {
        this.checkNNStartup();
        this.namesystem.unsetStoragePolicy(src);
    }

    public void setStoragePolicy(String src, String policyName) throws IOException {
        this.checkNNStartup();
        this.namesystem.setStoragePolicy(src, policyName);
    }

    public BlockStoragePolicy getStoragePolicy(String path) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getStoragePolicy(path);
    }

    public BlockStoragePolicy[] getStoragePolicies() throws IOException {
        this.checkNNStartup();
        return this.namesystem.getStoragePolicies();
    }

    public void setPermission(String src, FsPermission permissions) throws IOException {
        this.checkNNStartup();
        this.namesystem.setPermission(src, permissions);
    }

    public void setOwner(String src, String username, String groupname) throws IOException {
        this.checkNNStartup();
        this.namesystem.setOwner(src, username, groupname);
    }

    public LocatedBlock addBlock(String src, String clientName, ExtendedBlock previous, DatanodeInfo[] excludedNodes, long fileId, String[] favoredNodes, EnumSet<AddBlockFlag> addBlockFlags) throws IOException {
        this.checkNNStartup();
        LocatedBlock locatedBlock = this.namesystem.getAdditionalBlock(src, fileId, clientName, previous, excludedNodes, favoredNodes, addBlockFlags);
        if (locatedBlock != null) {
            this.metrics.incrAddBlockOps();
        }
        return locatedBlock;
    }

    public LocatedBlock getAdditionalDatanode(String src, long fileId, ExtendedBlock blk, DatanodeInfo[] existings, String[] existingStorageIDs, DatanodeInfo[] excludes, int numAdditionalNodes, String clientName) throws IOException {
        this.checkNNStartup();
        if (LOG.isDebugEnabled()) {
            LOG.debug("getAdditionalDatanode: src=" + src + ", fileId=" + fileId + ", blk=" + blk + ", existings=" + Arrays.asList(existings) + ", excludes=" + Arrays.asList(excludes) + ", numAdditionalNodes=" + numAdditionalNodes + ", clientName=" + clientName);
        }
        this.metrics.incrGetAdditionalDatanodeOps();
        HashSet<Node> excludeSet = null;
        if (excludes != null) {
            excludeSet = new HashSet<Node>(excludes.length);
            for (DatanodeInfo node : excludes) {
                excludeSet.add((Node)node);
            }
        }
        LocatedBlock locatedBlock = this.namesystem.getAdditionalDatanode(src, fileId, blk, existings, existingStorageIDs, excludeSet, numAdditionalNodes, clientName);
        return locatedBlock;
    }

    public void abandonBlock(ExtendedBlock b, long fileId, String src, String holder) throws IOException {
        this.checkNNStartup();
        this.namesystem.abandonBlock(b, fileId, src, holder);
    }

    public boolean complete(String src, String clientName, ExtendedBlock last, long fileId) throws IOException {
        this.checkNNStartup();
        return this.namesystem.completeFile(src, clientName, last, fileId);
    }

    @Override
    public void reportBadBlocks(LocatedBlock[] blocks) throws IOException {
        this.checkNNStartup();
        this.namesystem.reportBadBlocks(blocks);
    }

    public LocatedBlock updateBlockForPipeline(ExtendedBlock block, String clientName) throws IOException {
        this.checkNNStartup();
        return this.namesystem.updateBlockForPipeline(block, clientName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePipeline(String clientName, ExtendedBlock oldBlock, ExtendedBlock newBlock, DatanodeID[] newNodes, String[] newStorageIDs) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.updatePipeline(clientName, oldBlock, newBlock, newNodes, newStorageIDs, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    @Override
    public void commitBlockSynchronization(ExtendedBlock block, long newgenerationstamp, long newlength, boolean closeFile, boolean deleteblock, DatanodeID[] newtargets, String[] newtargetstorages) throws IOException {
        this.checkNNStartup();
        this.namesystem.commitBlockSynchronization(block, newgenerationstamp, newlength, closeFile, deleteblock, newtargets, newtargetstorages);
    }

    public long getPreferredBlockSize(String filename) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getPreferredBlockSize(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean rename(String src, String dst) throws IOException {
        this.checkNNStartup();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.rename: " + src + " to " + dst);
        }
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return true;
        }
        boolean ret = false;
        try {
            ret = this.namesystem.renameTo(src, dst, cacheEntry != null);
        }
        finally {
            RetryCache.setState(cacheEntry, ret);
        }
        if (ret) {
            this.metrics.incrFilesRenamed();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void concat(String trg, String[] src) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.concat(trg, src, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename2(String src, String dst, Options.Rename ... options) throws IOException {
        this.checkNNStartup();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.rename: " + src + " to " + dst);
        }
        if (!this.checkPathLength(dst)) {
            throw new IOException("rename: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.renameTo(src, dst, cacheEntry != null, options);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
        this.metrics.incrFilesRenamed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean truncate(String src, long newLength, String clientName) throws IOException {
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.truncate: " + src + " to " + newLength);
        }
        String clientMachine = NameNodeRpcServer.getClientMachine();
        try {
            boolean bl = this.namesystem.truncate(src, newLength, clientName, clientMachine, Time.now());
            return bl;
        }
        finally {
            this.metrics.incrFilesTruncated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String src, boolean recursive) throws IOException {
        this.checkNNStartup();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* Namenode.delete: src=" + src + ", recursive=" + recursive);
        }
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return true;
        }
        boolean ret = false;
        try {
            ret = this.namesystem.delete(src, recursive, cacheEntry != null);
        }
        finally {
            RetryCache.setState(cacheEntry, ret);
        }
        if (ret) {
            this.metrics.incrDeleteFileOps();
        }
        return ret;
    }

    private boolean checkPathLength(String src) {
        Path srcPath = new Path(src);
        return src.length() <= 8000 && srcPath.depth() <= 1000;
    }

    public boolean mkdirs(String src, FsPermission masked, boolean createParent) throws IOException {
        this.checkNNStartup();
        if (stateChangeLog.isDebugEnabled()) {
            stateChangeLog.debug("*DIR* NameNode.mkdirs: " + src);
        }
        if (!this.checkPathLength(src)) {
            throw new IOException("mkdirs: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        return this.namesystem.mkdirs(src, new PermissionStatus(NameNodeRpcServer.getRemoteUser().getShortUserName(), null, masked), createParent);
    }

    public void renewLease(String clientName) throws IOException {
        this.checkNNStartup();
        this.namesystem.renewLease(clientName);
    }

    public DirectoryListing getListing(String src, byte[] startAfter, boolean needLocation) throws IOException {
        this.checkNNStartup();
        DirectoryListing files = this.namesystem.getListing(src, startAfter, needLocation);
        if (files != null) {
            this.metrics.incrGetListingOps();
            this.metrics.incrFilesInGetListingOps(files.getPartialListing().length);
        }
        return files;
    }

    public HdfsFileStatus getFileInfo(String src) throws IOException {
        this.checkNNStartup();
        this.metrics.incrFileInfoOps();
        return this.namesystem.getFileInfo(src, true);
    }

    public boolean isFileClosed(String src) throws IOException {
        this.checkNNStartup();
        return this.namesystem.isFileClosed(src);
    }

    public HdfsFileStatus getFileLinkInfo(String src) throws IOException {
        this.checkNNStartup();
        this.metrics.incrFileInfoOps();
        return this.namesystem.getFileInfo(src, false);
    }

    public long[] getStats() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        return this.namesystem.getStats();
    }

    public DatanodeInfo[] getDatanodeReport(HdfsConstants.DatanodeReportType type) throws IOException {
        this.checkNNStartup();
        DatanodeInfo[] results = this.namesystem.datanodeReport(type);
        return results;
    }

    public DatanodeStorageReport[] getDatanodeStorageReport(HdfsConstants.DatanodeReportType type) throws IOException {
        this.checkNNStartup();
        DatanodeStorageReport[] reports = this.namesystem.getDatanodeStorageReport(type);
        return reports;
    }

    public boolean setSafeMode(HdfsConstants.SafeModeAction action, boolean isChecked) throws IOException {
        this.checkNNStartup();
        NameNode.OperationCategory opCategory = NameNode.OperationCategory.UNCHECKED;
        if (isChecked) {
            opCategory = action == HdfsConstants.SafeModeAction.SAFEMODE_GET ? NameNode.OperationCategory.READ : NameNode.OperationCategory.WRITE;
        }
        this.namesystem.checkOperation(opCategory);
        return this.namesystem.setSafeMode(action);
    }

    public boolean restoreFailedStorage(String arg) throws IOException {
        this.checkNNStartup();
        return this.namesystem.restoreFailedStorage(arg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveNamespace() throws IOException {
        this.checkNNStartup();
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.saveNamespace();
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    public long rollEdits() throws AccessControlException, IOException {
        this.checkNNStartup();
        CheckpointSignature sig = this.namesystem.rollEditLog();
        return sig.getCurSegmentTxId();
    }

    public void refreshNodes() throws IOException {
        this.checkNNStartup();
        this.namesystem.refreshNodes();
    }

    @Override
    public long getTransactionID() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getFSImage().getCorrectLastAppliedOrWrittenTxId();
    }

    @Override
    public long getMostRecentCheckpointTxId() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.UNCHECKED);
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getFSImage().getMostRecentCheckpointTxId();
    }

    @Override
    public CheckpointSignature rollEditLog() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.rollEditLog();
    }

    @Override
    public RemoteEditLogManifest getEditLogManifest(long sinceTxId) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getEditLog().getEditLogManifest(sinceTxId);
    }

    @Override
    public boolean isUpgradeFinalized() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.isUpgradeFinalized();
    }

    @Override
    public boolean isRollingUpgrade() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.isRollingUpgrade();
    }

    public void finalizeUpgrade() throws IOException {
        this.checkNNStartup();
        this.namesystem.finalizeUpgrade();
    }

    public RollingUpgradeInfo rollingUpgrade(HdfsConstants.RollingUpgradeAction action) throws IOException {
        this.checkNNStartup();
        LOG.info("rollingUpgrade " + action);
        switch (action) {
            case QUERY: {
                return this.namesystem.queryRollingUpgrade();
            }
            case PREPARE: {
                return this.namesystem.startRollingUpgrade();
            }
            case FINALIZE: {
                return this.namesystem.finalizeRollingUpgrade();
            }
        }
        throw new UnsupportedActionException(action + " is not yet supported.");
    }

    public void metaSave(String filename) throws IOException {
        this.checkNNStartup();
        this.namesystem.metaSave(filename);
    }

    public BatchedRemoteIterator.BatchedEntries<OpenFileEntry> listOpenFiles(long prevId) throws IOException {
        this.checkNNStartup();
        return this.namesystem.listOpenFiles(prevId);
    }

    public void msync() throws IOException {
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
    }

    public HAServiceProtocol.HAServiceState getHAServiceState() throws IOException {
        this.checkNNStartup();
        return this.nn.getServiceStatus().getState();
    }

    public CorruptFileBlocks listCorruptFileBlocks(String path, String cookie) throws IOException {
        this.checkNNStartup();
        String[] cookieTab = new String[]{cookie};
        Collection<FSNamesystem.CorruptFileBlockInfo> fbs = this.namesystem.listCorruptFileBlocks(path, cookieTab);
        String[] files = new String[fbs.size()];
        int i = 0;
        for (FSNamesystem.CorruptFileBlockInfo fb : fbs) {
            files[i++] = fb.path;
        }
        return new CorruptFileBlocks(files, cookieTab[0]);
    }

    public void setBalancerBandwidth(long bandwidth) throws IOException {
        this.checkNNStartup();
        this.namesystem.setBalancerBandwidth(bandwidth);
    }

    public ContentSummary getContentSummary(String path) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getContentSummary(path);
    }

    public QuotaUsage getQuotaUsage(String path) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getQuotaUsage(path);
    }

    public void setQuota(String path, long namespaceQuota, long storagespaceQuota, StorageType type) throws IOException {
        this.checkNNStartup();
        this.namesystem.setQuota(path, namespaceQuota, storagespaceQuota, type);
    }

    public void fsync(String src, long fileId, String clientName, long lastBlockLength) throws IOException {
        this.checkNNStartup();
        this.namesystem.fsync(src, fileId, clientName, lastBlockLength);
    }

    public void setTimes(String src, long mtime, long atime) throws IOException {
        this.checkNNStartup();
        this.namesystem.setTimes(src, mtime, atime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSymlink(String target, String link, FsPermission dirPerms, boolean createParent) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        if (!this.checkPathLength(link)) {
            throw new IOException("Symlink path exceeds 8000 character limit");
        }
        UserGroupInformation ugi = NameNodeRpcServer.getRemoteUser();
        boolean success = false;
        try {
            PermissionStatus perm = new PermissionStatus(ugi.getShortUserName(), null, dirPerms);
            this.namesystem.createSymlink(target, link, perm, createParent, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    public String getLinkTarget(String path) throws IOException {
        this.checkNNStartup();
        this.metrics.incrGetLinkTargetOps();
        HdfsFileStatus stat = null;
        try {
            stat = this.namesystem.getFileInfo(path, false);
        }
        catch (UnresolvedPathException e) {
            return e.getResolvedPath().toString();
        }
        catch (UnresolvedLinkException e) {
            throw new AssertionError((Object)"UnresolvedLinkException thrown");
        }
        if (stat == null) {
            throw new FileNotFoundException("File does not exist: " + path);
        }
        if (!stat.isSymlink()) {
            throw new IOException("Path " + path + " is not a symbolic link");
        }
        return stat.getSymlink();
    }

    @Override
    public DatanodeRegistration registerDatanode(DatanodeRegistration nodeReg) throws IOException {
        this.checkNNStartup();
        this.verifySoftwareVersion(nodeReg);
        this.namesystem.registerDatanode(nodeReg);
        return nodeReg;
    }

    @Override
    public HeartbeatResponse sendHeartbeat(DatanodeRegistration nodeReg, StorageReport[] report, long dnCacheCapacity, long dnCacheUsed, int xmitsInProgress, int xceiverCount, int failedVolumes, VolumeFailureSummary volumeFailureSummary, boolean requestFullBlockReportLease, @Nonnull SlowPeerReports slowPeers, @Nonnull SlowDiskReports slowDisks) throws IOException {
        this.checkNNStartup();
        this.verifyRequest(nodeReg);
        return this.namesystem.handleHeartbeat(nodeReg, report, dnCacheCapacity, dnCacheUsed, xceiverCount, xmitsInProgress, failedVolumes, volumeFailureSummary, requestFullBlockReportLease, slowPeers, slowDisks);
    }

    @Override
    public DatanodeCommand blockReport(final DatanodeRegistration nodeReg, String poolId, final StorageBlockReport[] reports, final BlockReportContext context) throws IOException {
        this.checkNNStartup();
        this.verifyRequest(nodeReg);
        if (blockStateChangeLog.isDebugEnabled()) {
            blockStateChangeLog.debug("*BLOCK* NameNode.blockReport: from " + nodeReg + ", reports.length=" + reports.length);
        }
        final BlockManager bm = this.namesystem.getBlockManager();
        boolean noStaleStorages = false;
        try {
            if (bm.checkBlockReportLease(context, nodeReg)) {
                int r = 0;
                while (r < reports.length) {
                    final BlockListAsLongs blocks = reports[r].getBlocks();
                    final int index = r++;
                    noStaleStorages = bm.runBlockOp(new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws IOException {
                            return bm.processReport(nodeReg, reports[index].getStorage(), blocks, context);
                        }
                    });
                    this.metrics.incrStorageBlockReportOps();
                }
            }
        }
        catch (UnregisteredNodeException une) {
            LOG.debug("Datanode {} is attempting to report but not register yet.", (Object)nodeReg);
            return RegisterCommand.REGISTER;
        }
        bm.removeBRLeaseIfNeeded(nodeReg, context);
        BlockManagerFaultInjector.getInstance().incomingBlockReportRpc(nodeReg, context);
        if (this.nn.getFSImage().isUpgradeFinalized() && !this.namesystem.isRollingUpgrade() && this.nn.isActiveState() && noStaleStorages) {
            return new FinalizeCommand(poolId);
        }
        return null;
    }

    @Override
    public DatanodeCommand cacheReport(DatanodeRegistration nodeReg, String poolId, List<Long> blockIds) throws IOException {
        this.checkNNStartup();
        this.verifyRequest(nodeReg);
        if (blockStateChangeLog.isDebugEnabled()) {
            blockStateChangeLog.debug("*BLOCK* NameNode.cacheReport: from " + nodeReg + " " + blockIds.size() + " blocks");
        }
        this.namesystem.getCacheManager().processCacheReport(nodeReg, blockIds);
        return null;
    }

    @Override
    public void blockReceivedAndDeleted(final DatanodeRegistration nodeReg, String poolId, StorageReceivedDeletedBlocks[] receivedAndDeletedBlocks) throws IOException {
        this.checkNNStartup();
        this.verifyRequest(nodeReg);
        this.metrics.incrBlockReceivedAndDeletedOps();
        if (blockStateChangeLog.isDebugEnabled()) {
            blockStateChangeLog.debug("*BLOCK* NameNode.blockReceivedAndDeleted: from " + nodeReg + " " + receivedAndDeletedBlocks.length + " blocks.");
        }
        BlockManager bm = this.namesystem.getBlockManager();
        for (final StorageReceivedDeletedBlocks r : receivedAndDeletedBlocks) {
            bm.enqueueBlockOp(new Runnable(){

                @Override
                public void run() {
                    try {
                        NameNodeRpcServer.this.namesystem.processIncrementalBlockReport(nodeReg, r);
                    }
                    catch (Exception ex) {
                        blockStateChangeLog.error("*BLOCK* NameNode.blockReceivedAndDeleted: failed from " + nodeReg + ": " + ex.getMessage());
                    }
                }
            });
        }
    }

    @Override
    public void errorReport(DatanodeRegistration nodeReg, int errorCode, String msg) throws IOException {
        String dnName;
        this.checkNNStartup();
        String string = dnName = nodeReg == null ? "Unknown DataNode" : nodeReg.toString();
        if (errorCode == 0) {
            LOG.info("Error report from " + dnName + ": " + msg);
            return;
        }
        this.verifyRequest(nodeReg);
        if (errorCode == 1) {
            LOG.warn("Disk error on " + dnName + ": " + msg);
        } else if (errorCode == 3) {
            LOG.warn("Fatal disk error on " + dnName + ": " + msg);
            this.namesystem.getBlockManager().getDatanodeManager().removeDatanode(nodeReg);
        } else {
            LOG.info("Error report from " + dnName + ": " + msg);
        }
    }

    @Override
    public NamespaceInfo versionRequest() throws IOException {
        this.checkNNStartup();
        return this.namesystem.getNamespaceInfo();
    }

    @Override
    public void sendLifeline(DatanodeRegistration nodeReg, StorageReport[] report, long dnCacheCapacity, long dnCacheUsed, int xmitsInProgress, int xceiverCount, int failedVolumes, VolumeFailureSummary volumeFailureSummary) throws IOException {
        this.checkNNStartup();
        this.verifyRequest(nodeReg);
        this.namesystem.handleLifeline(nodeReg, report, dnCacheCapacity, dnCacheUsed, xceiverCount, xmitsInProgress, failedVolumes, volumeFailureSummary);
    }

    private void verifyRequest(NodeRegistration nodeReg) throws IOException {
        String id = nodeReg.getRegistrationID();
        String expectedID = this.namesystem.getRegistrationID();
        if (!expectedID.equals(id)) {
            LOG.warn("Registration IDs mismatched: the " + nodeReg.getClass().getSimpleName() + " ID is " + id + " but the expected ID is " + expectedID);
            throw new UnregisteredNodeException(nodeReg);
        }
    }

    @Override
    public void refreshServiceAcl() throws IOException {
        this.checkNNStartup();
        if (!this.serviceAuthEnabled) {
            throw new AuthorizationException("Service Level Authorization not enabled!");
        }
        this.clientRpcServer.refreshServiceAcl(new Configuration(), new HDFSPolicyProvider());
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.refreshServiceAcl(new Configuration(), new HDFSPolicyProvider());
        }
    }

    @Override
    public void refreshUserToGroupsMappings() throws IOException {
        LOG.info("Refreshing all user-to-groups mappings. Requested by user: " + NameNodeRpcServer.getRemoteUser().getShortUserName());
        Groups.getUserToGroupsMappingService().refresh();
    }

    @Override
    public void refreshSuperUserGroupsConfiguration() {
        LOG.info("Refreshing SuperUser proxy group mapping list ");
        ProxyUsers.refreshSuperUserGroupsConfiguration();
    }

    @Override
    public void refreshCallQueue() {
        LOG.info("Refreshing call queue.");
        Configuration conf = new Configuration();
        this.clientRpcServer.refreshCallQueue(conf);
        if (this.serviceRpcServer != null) {
            this.serviceRpcServer.refreshCallQueue(conf);
        }
    }

    @Override
    public Collection<RefreshResponse> refresh(String identifier, String[] args) {
        return RefreshRegistry.defaultRegistry().dispatch(identifier, args);
    }

    @Override
    public String[] getGroupsForUser(String user) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Getting groups for user " + user);
        }
        return UserGroupInformation.createRemoteUser(user).getGroupNames();
    }

    @Override
    public synchronized void monitorHealth() throws HealthCheckFailedException, AccessControlException, IOException {
        this.checkNNStartup();
        this.nn.monitorHealth();
    }

    @Override
    public synchronized void transitionToActive(HAServiceProtocol.StateChangeRequestInfo req) throws ServiceFailedException, AccessControlException, IOException {
        this.checkNNStartup();
        this.nn.checkHaStateChange(req);
        this.nn.transitionToActive();
    }

    @Override
    public synchronized void transitionToStandby(HAServiceProtocol.StateChangeRequestInfo req) throws ServiceFailedException, AccessControlException, IOException {
        this.checkNNStartup();
        this.nn.checkHaStateChange(req);
        this.nn.transitionToStandby();
    }

    @Override
    public synchronized void transitionToObserver(HAServiceProtocol.StateChangeRequestInfo req) throws ServiceFailedException, AccessControlException, IOException {
        this.checkNNStartup();
        this.nn.checkHaStateChange(req);
        this.nn.transitionToObserver();
    }

    @Override
    public synchronized HAServiceStatus getServiceStatus() throws AccessControlException, ServiceFailedException, IOException {
        this.checkNNStartup();
        return this.nn.getServiceStatus();
    }

    void verifyLayoutVersion(int version) throws IOException {
        if (version != HdfsServerConstants.NAMENODE_LAYOUT_VERSION) {
            throw new IncorrectVersionException(HdfsServerConstants.NAMENODE_LAYOUT_VERSION, version, "data node");
        }
    }

    private void verifySoftwareVersion(DatanodeRegistration dnReg) throws IncorrectVersionException {
        String dnVersion = dnReg.getSoftwareVersion();
        if (VersionUtil.compareVersions(dnVersion, this.minimumDataNodeVersion) < 0) {
            IncorrectVersionException ive = new IncorrectVersionException(this.minimumDataNodeVersion, dnVersion, "DataNode", "NameNode");
            LOG.warn(ive.getMessage() + " DN: " + dnReg);
            throw ive;
        }
        String nnVersion = VersionInfo.getVersion();
        if (!dnVersion.equals(nnVersion)) {
            long dnCTime;
            String messagePrefix = "Reported DataNode version '" + dnVersion + "' of DN " + dnReg + " does not match NameNode version '" + nnVersion + "'";
            long nnCTime = this.nn.getFSImage().getStorage().getCTime();
            if (nnCTime != (dnCTime = dnReg.getStorageInfo().getCTime())) {
                IncorrectVersionException ive = new IncorrectVersionException(messagePrefix + " and CTime of DN ('" + dnCTime + "') does not match CTime of NN ('" + nnCTime + "')");
                LOG.warn(ive.toString(), (Throwable)ive);
                throw ive;
            }
            LOG.info(messagePrefix + ". Note: This is normal during a rolling upgrade.");
        }
    }

    private static String getClientMachine() {
        String clientMachine = Server.getRemoteAddress();
        if (clientMachine == null) {
            clientMachine = "";
        }
        return clientMachine;
    }

    public DataEncryptionKey getDataEncryptionKey() throws IOException {
        this.checkNNStartup();
        return this.namesystem.getBlockManager().generateDataEncryptionKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        this.checkNNStartup();
        if (!this.checkPathLength(snapshotRoot)) {
            throw new IOException("createSnapshot: Pathname too long.  Limit 8000 characters, 1000 levels.");
        }
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntryWithPayload cacheEntry = RetryCache.waitForCompletion(this.retryCache, null);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return (String)cacheEntry.getPayload();
        }
        this.metrics.incrCreateSnapshotOps();
        String ret = null;
        try {
            ret = this.namesystem.createSnapshot(snapshotRoot, snapshotName, cacheEntry != null);
            RetryCache.setState(cacheEntry, ret != null, ret);
        }
        catch (Throwable throwable) {
            RetryCache.setState(cacheEntry, ret != null, ret);
            throw throwable;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSnapshot(String snapshotRoot, String snapshotName) throws IOException {
        this.checkNNStartup();
        if (snapshotName == null || snapshotName.isEmpty()) {
            throw new IOException("The snapshot name is null or empty.");
        }
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        this.metrics.incrDeleteSnapshotOps();
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.deleteSnapshot(snapshotRoot, snapshotName, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    public void allowSnapshot(String snapshotRoot) throws IOException {
        this.checkNNStartup();
        this.metrics.incrAllowSnapshotOps();
        this.namesystem.allowSnapshot(snapshotRoot);
    }

    public void disallowSnapshot(String snapshot) throws IOException {
        this.checkNNStartup();
        this.metrics.incrDisAllowSnapshotOps();
        this.namesystem.disallowSnapshot(snapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSnapshot(String snapshotRoot, String snapshotOldName, String snapshotNewName) throws IOException {
        this.checkNNStartup();
        if (snapshotNewName == null || snapshotNewName.isEmpty()) {
            throw new IOException("The new snapshot name is null or empty.");
        }
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        this.metrics.incrRenameSnapshotOps();
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.renameSnapshot(snapshotRoot, snapshotOldName, snapshotNewName, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    public SnapshottableDirectoryStatus[] getSnapshottableDirListing() throws IOException {
        this.checkNNStartup();
        SnapshottableDirectoryStatus[] status = this.namesystem.getSnapshottableDirListing();
        this.metrics.incrListSnapshottableDirOps();
        return status;
    }

    public SnapshotDiffReport getSnapshotDiffReport(String snapshotRoot, String earlierSnapshotName, String laterSnapshotName) throws IOException {
        this.checkNNStartup();
        SnapshotDiffReport report = this.namesystem.getSnapshotDiffReport(snapshotRoot, earlierSnapshotName, laterSnapshotName);
        this.metrics.incrSnapshotDiffReportOps();
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addCacheDirective(CacheDirectiveInfo path, EnumSet<CacheFlag> flags) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntryWithPayload cacheEntry = RetryCache.waitForCompletion(this.retryCache, null);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return (Long)cacheEntry.getPayload();
        }
        boolean success = false;
        long ret = 0L;
        try {
            ret = this.namesystem.addCacheDirective(path, flags, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success, ret);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyCacheDirective(CacheDirectiveInfo directive, EnumSet<CacheFlag> flags) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.modifyCacheDirective(directive, flags, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheDirective(long id) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.removeCacheDirective(id, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    public BatchedRemoteIterator.BatchedEntries<CacheDirectiveEntry> listCacheDirectives(long prevId, CacheDirectiveInfo filter) throws IOException {
        this.checkNNStartup();
        if (filter == null) {
            filter = new CacheDirectiveInfo.Builder().build();
        }
        return this.namesystem.listCacheDirectives(prevId, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCachePool(CachePoolInfo info) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.addCachePool(info, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyCachePool(CachePoolInfo info) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.modifyCachePool(info, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCachePool(String cachePoolName) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.removeCachePool(cachePoolName, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    public BatchedRemoteIterator.BatchedEntries<CachePoolEntry> listCachePools(String prevKey) throws IOException {
        this.checkNNStartup();
        return this.namesystem.listCachePools(prevKey != null ? prevKey : "");
    }

    public void modifyAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.checkNNStartup();
        this.namesystem.modifyAclEntries(src, aclSpec);
    }

    public void removeAclEntries(String src, List<AclEntry> aclSpec) throws IOException {
        this.checkNNStartup();
        this.namesystem.removeAclEntries(src, aclSpec);
    }

    public void removeDefaultAcl(String src) throws IOException {
        this.checkNNStartup();
        this.namesystem.removeDefaultAcl(src);
    }

    public void removeAcl(String src) throws IOException {
        this.checkNNStartup();
        this.namesystem.removeAcl(src);
    }

    public void setAcl(String src, List<AclEntry> aclSpec) throws IOException {
        this.checkNNStartup();
        this.namesystem.setAcl(src, aclSpec);
    }

    public AclStatus getAclStatus(String src) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getAclStatus(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEncryptionZone(String src, String keyName) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.createEncryptionZone(src, keyName, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    public EncryptionZone getEZForPath(String src) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getEZForPath(src);
    }

    public BatchedRemoteIterator.BatchedEntries<EncryptionZone> listEncryptionZones(long prevId) throws IOException {
        this.checkNNStartup();
        return this.namesystem.listEncryptionZones(prevId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXAttr(String src, XAttr xAttr, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.setXAttr(src, xAttr, flag, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    public List<XAttr> getXAttrs(String src, List<XAttr> xAttrs) throws IOException {
        this.checkNNStartup();
        return this.namesystem.getXAttrs(src, xAttrs);
    }

    public List<XAttr> listXAttrs(String src) throws IOException {
        this.checkNNStartup();
        return this.namesystem.listXAttrs(src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeXAttr(String src, XAttr xAttr) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.WRITE);
        RetryCache.CacheEntry cacheEntry = RetryCache.waitForCompletion(this.retryCache);
        if (cacheEntry != null && cacheEntry.isSuccess()) {
            return;
        }
        boolean success = false;
        try {
            this.namesystem.removeXAttr(src, xAttr, cacheEntry != null);
            success = true;
        }
        finally {
            RetryCache.setState(cacheEntry, success);
        }
    }

    private void checkNNStartup() throws IOException {
        if (!this.nn.isStarted()) {
            String message = NameNode.composeNotStartedMessage(this.nn.getRole());
            throw new RetriableException(message);
        }
    }

    public void checkAccess(String path, FsAction mode) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkAccess(path, mode);
    }

    public long getCurrentEditLogTxid() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        this.namesystem.checkSuperuserPrivilege();
        return this.namesystem.getEditLog().isOpenForWrite() ? this.namesystem.getEditLog().getLastWrittenTxId() : -1L;
    }

    private static FSEditLogOp readOp(EditLogInputStream elis) throws IOException {
        try {
            return elis.readOp();
        }
        catch (FileNotFoundException e) {
            LOG.debug("Tried to read from deleted or moved edit log segment", (Throwable)e);
            return null;
        }
        catch (HttpGetFailedException e) {
            LOG.debug("Tried to read from deleted edit log segment", (Throwable)e);
            return null;
        }
    }

    public EventBatchList getEditsFromTxid(final long txid) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkOperation(NameNode.OperationCategory.READ);
        this.namesystem.checkSuperuserPrivilege();
        final int maxEventsPerRPC = this.nn.getConf().getInt("dfs.namenode.inotify.max.events.per.rpc", 1000);
        final FSEditLog log = this.namesystem.getFSImage().getEditLog();
        final long syncTxid = log.getSyncTxId();
        final boolean readInProgress = syncTxid > 0L;
        EventBatchList ret = SecurityUtil.doAsLoginUser(new PrivilegedExceptionAction<EventBatchList>(){

            @Override
            public EventBatchList run() throws IOException {
                return NameNodeRpcServer.this.getEventBatchList(syncTxid, txid, log, readInProgress, maxEventsPerRPC);
            }
        });
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventBatchList getEventBatchList(long syncTxid, long txid, FSEditLog log, boolean readInProgress, int maxEventsPerRPC) throws IOException {
        ArrayList batches = Lists.newArrayList();
        int totalEvents = 0;
        long maxSeenTxid = -1L;
        long firstSeenTxid = -1L;
        if (syncTxid > 0L && txid > syncTxid) {
            return new EventBatchList((List)batches, firstSeenTxid, maxSeenTxid, syncTxid);
        }
        Collection<EditLogInputStream> streams = null;
        try {
            streams = log.selectInputStreams(txid, 0L, null, readInProgress);
        }
        catch (IllegalStateException e) {
            LOG.info("NN is transitioning from active to standby and FSEditLog is closed -- could not read edits");
            return new EventBatchList((List)batches, firstSeenTxid, maxSeenTxid, syncTxid);
        }
        boolean breakOuter = false;
        for (EditLogInputStream elis : streams) {
            try {
                FSEditLogOp op = null;
                while ((op = NameNodeRpcServer.readOp(elis)) != null) {
                    if (syncTxid > 0L && op.getTransactionId() > syncTxid) {
                        breakOuter = true;
                    } else {
                        EventBatch eventBatch = InotifyFSEditLogOpTranslator.translate(op);
                        if (eventBatch != null) {
                            batches.add(eventBatch);
                            totalEvents += eventBatch.getEvents().length;
                        }
                        if (op.getTransactionId() > maxSeenTxid) {
                            maxSeenTxid = op.getTransactionId();
                        }
                        if (firstSeenTxid == -1L) {
                            firstSeenTxid = op.getTransactionId();
                        }
                        if (totalEvents < maxEventsPerRPC && (syncTxid <= 0L || op.getTransactionId() != syncTxid)) continue;
                        breakOuter = true;
                    }
                    break;
                }
            }
            finally {
                elis.close();
            }
            if (!breakOuter) continue;
            break;
        }
        return new EventBatchList((List)batches, firstSeenTxid, maxSeenTxid, syncTxid);
    }

    @Override
    public SpanReceiverInfo[] listSpanReceivers() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.nn.tracerConfigurationManager.listSpanReceivers();
    }

    @Override
    public long addSpanReceiver(SpanReceiverInfo info) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.nn.tracerConfigurationManager.addSpanReceiver(info);
    }

    @Override
    public void removeSpanReceiver(long id) throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        this.nn.tracerConfigurationManager.removeSpanReceiver(id);
    }

    public void startReconfiguration() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        this.nn.startReconfigurationTask();
    }

    public ReconfigurationTaskStatus getReconfigurationStatus() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return this.nn.getReconfigurationTaskStatus();
    }

    public List<String> listReconfigurableProperties() throws IOException {
        this.checkNNStartup();
        this.namesystem.checkSuperuserPrivilege();
        return Lists.newArrayList(this.nn.getReconfigurableProperties());
    }
}

