/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.server.namenode.startupprogress;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.hdfs.server.namenode.startupprogress.StepType;

@InterfaceAudience.Private
public class Step
implements Comparable<Step> {
    private static final AtomicInteger SEQUENCE = new AtomicInteger();
    private final String file;
    private final int sequenceNumber;
    private final long size;
    private final StepType type;

    public Step(StepType type) {
        this(type, null, Long.MIN_VALUE);
    }

    public Step(String file) {
        this(null, file, Long.MIN_VALUE);
    }

    public Step(String file, long size) {
        this(null, file, size);
    }

    public Step(StepType type, String file) {
        this(type, file, Long.MIN_VALUE);
    }

    public Step(StepType type, String file, long size) {
        this.file = file;
        this.sequenceNumber = SEQUENCE.incrementAndGet();
        this.size = size;
        this.type = type;
    }

    @Override
    public int compareTo(Step other) {
        return new CompareToBuilder().append((Object)this.file, (Object)other.file).append(this.sequenceNumber, other.sequenceNumber).toComparison();
    }

    public boolean equals(Object otherObj) {
        if (otherObj == null || otherObj.getClass() != this.getClass()) {
            return false;
        }
        Step other = (Step)otherObj;
        return new EqualsBuilder().append((Object)this.file, (Object)other.file).append(this.size, other.size).append((Object)this.type, (Object)other.type).isEquals();
    }

    public String getFile() {
        return this.file;
    }

    public long getSize() {
        return this.size;
    }

    public StepType getType() {
        return this.type;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.file).append(this.size).append((Object)this.type).toHashCode();
    }
}

