/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.tools.snapshot;

import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.conf.Configured;
import shaded.org.apache.hadoop.fs.FileSystem;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.hdfs.DistributedFileSystem;
import shaded.org.apache.hadoop.hdfs.HdfsConfiguration;
import shaded.org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import shaded.org.apache.hadoop.util.Tool;
import shaded.org.apache.hadoop.util.ToolRunner;

@InterfaceAudience.Private
public class SnapshotDiff
extends Configured
implements Tool {
    public SnapshotDiff() {
        this((Configuration)new HdfsConfiguration());
    }

    public SnapshotDiff(Configuration conf) {
        super(conf);
    }

    private static String getSnapshotName(String name) {
        int i;
        if (".".equals(name)) {
            return "";
        }
        if (name.startsWith(".snapshot/")) {
            i = 0;
        } else if (name.startsWith("/.snapshot/")) {
            i = 1;
        } else {
            return name;
        }
        return name.substring(i + ".snapshot".length() + 1);
    }

    @Override
    public int run(String[] argv) throws Exception {
        String description = "hdfs snapshotDiff <snapshotDir> <from> <to>:\n\tGet the difference between two snapshots, \n\tor between a snapshot and the current tree of a directory.\n\tFor <from>/<to>, users can use \".\" to present the current status,\n\tand use \".snapshot/snapshot_name\" to present a snapshot,\n\twhere \".snapshot/\" can be omitted\n";
        if (argv.length != 3) {
            System.err.println("Usage: \n" + description);
            return 1;
        }
        FileSystem fs = FileSystem.get(new Path(argv[0]).toUri(), this.getConf());
        if (!(fs instanceof DistributedFileSystem)) {
            System.err.println("SnapshotDiff can only be used in DistributedFileSystem");
            return 1;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        Path snapshotRoot = new Path(argv[0]);
        String fromSnapshot = SnapshotDiff.getSnapshotName(argv[1]);
        String toSnapshot = SnapshotDiff.getSnapshotName(argv[2]);
        try {
            SnapshotDiffReport diffReport = dfs.getSnapshotDiffReport(snapshotRoot, fromSnapshot, toSnapshot);
            System.out.println(diffReport.toString());
        }
        catch (IOException e) {
            String[] content = e.getLocalizedMessage().split("\n");
            System.err.println("snapshotDiff: " + content[0]);
            return 1;
        }
        return 0;
    }

    public static void main(String[] argv) throws Exception {
        int rc = ToolRunner.run(new SnapshotDiff(), argv);
        System.exit(rc);
    }
}

