/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.hdfs.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class XMLUtils {
    private static final int NUM_SLASH_POSITIONS = 4;

    private static boolean codePointMustBeMangled(int cp) {
        if (cp < 32) {
            return cp != 9 && cp != 10 && cp != 13;
        }
        if (55295 < cp && cp < 57344) {
            return true;
        }
        if (cp == 65534 || cp == 65535) {
            return true;
        }
        return cp == 92;
    }

    private static String mangleCodePoint(int cp) {
        return String.format("\\%04x;", cp);
    }

    private static String codePointToEntityRef(int cp) {
        switch (cp) {
            case 38: {
                return "&amp;";
            }
            case 34: {
                return "&quot;";
            }
            case 39: {
                return "&apos;";
            }
            case 60: {
                return "&lt;";
            }
            case 62: {
                return "&gt;";
            }
        }
        return null;
    }

    public static String mangleXmlString(String str, boolean createEntityRefs) {
        int len;
        StringBuilder bld = new StringBuilder();
        int length = str.length();
        for (int offset = 0; offset < length; offset += len) {
            int cp = str.codePointAt(offset);
            len = Character.charCount(cp);
            if (XMLUtils.codePointMustBeMangled(cp)) {
                bld.append(XMLUtils.mangleCodePoint(cp));
                continue;
            }
            String entityRef = null;
            if (createEntityRefs) {
                entityRef = XMLUtils.codePointToEntityRef(cp);
            }
            if (entityRef != null) {
                bld.append(entityRef);
                continue;
            }
            for (int i = 0; i < len; ++i) {
                bld.append(str.charAt(offset + i));
            }
        }
        return bld.toString();
    }

    public static String unmangleXmlString(String str, boolean decodeEntityRefs) throws UnmanglingError {
        int slashPosition = -1;
        String escapedCp = "";
        StringBuilder bld = new StringBuilder();
        StringBuilder entityRef = null;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (entityRef != null) {
                entityRef.append(ch);
                if (ch != ';') continue;
                String e = entityRef.toString();
                if (e.equals("&quot;")) {
                    bld.append("\"");
                } else if (e.equals("&apos;")) {
                    bld.append("'");
                } else if (e.equals("&amp;")) {
                    bld.append("&");
                } else if (e.equals("&lt;")) {
                    bld.append("<");
                } else if (e.equals("&gt;")) {
                    bld.append(">");
                } else {
                    throw new UnmanglingError("Unknown entity ref " + e);
                }
                entityRef = null;
                continue;
            }
            if (slashPosition >= 0 && slashPosition < 4) {
                escapedCp = escapedCp + ch;
                ++slashPosition;
                continue;
            }
            if (slashPosition == 4) {
                if (ch != ';') {
                    throw new UnmanglingError("unterminated code point escape: expected semicolon at end.");
                }
                try {
                    bld.appendCodePoint(Integer.parseInt(escapedCp, 16));
                }
                catch (NumberFormatException e) {
                    throw new UnmanglingError("error parsing unmangling escape code", e);
                }
                escapedCp = "";
                slashPosition = -1;
                continue;
            }
            if (ch == '\\') {
                slashPosition = 0;
                continue;
            }
            boolean startingEntityRef = false;
            if (decodeEntityRefs) {
                boolean bl = startingEntityRef = ch == '&';
            }
            if (startingEntityRef) {
                entityRef = new StringBuilder();
                entityRef.append("&");
                continue;
            }
            bld.append(ch);
        }
        if (entityRef != null) {
            throw new UnmanglingError("unterminated entity ref starting with " + entityRef.toString());
        }
        if (slashPosition != -1) {
            throw new UnmanglingError("unterminated code point escape: string broke off in the middle");
        }
        return bld.toString();
    }

    public static void addSaxString(ContentHandler contentHandler, String tag, String val) throws SAXException {
        contentHandler.startElement("", "", tag, new AttributesImpl());
        char[] c = XMLUtils.mangleXmlString(val, false).toCharArray();
        contentHandler.characters(c, 0, c.length);
        contentHandler.endElement("", "", tag);
    }

    public static class Stanza {
        private final TreeMap<String, LinkedList<Stanza>> subtrees = new TreeMap();
        private String value = "";

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean hasChildren(String name) {
            return this.subtrees.containsKey(name);
        }

        public List<Stanza> getChildren(String name) throws InvalidXmlException {
            LinkedList<Stanza> children = this.subtrees.get(name);
            if (children == null) {
                throw new InvalidXmlException("no entry found for " + name);
            }
            return children;
        }

        public String getValue(String name) throws InvalidXmlException {
            String ret = this.getValueOrNull(name);
            if (ret == null) {
                throw new InvalidXmlException("no entry found for " + name);
            }
            return ret;
        }

        public String getValueOrNull(String name) throws InvalidXmlException {
            if (!this.subtrees.containsKey(name)) {
                return null;
            }
            LinkedList<Stanza> l = this.subtrees.get(name);
            if (l.size() != 1) {
                throw new InvalidXmlException("More than one value found for " + name);
            }
            return l.get(0).getValue();
        }

        public void addChild(String name, Stanza child) {
            LinkedList<Object> l;
            if (this.subtrees.containsKey(name)) {
                l = this.subtrees.get(name);
            } else {
                l = new LinkedList();
                this.subtrees.put(name, l);
            }
            l.add(child);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("{");
            if (!this.value.equals("")) {
                bld.append("\"").append(this.value).append("\"");
            }
            String prefix = "";
            for (Map.Entry<String, LinkedList<Stanza>> entry : this.subtrees.entrySet()) {
                String key = entry.getKey();
                LinkedList<Stanza> ll = entry.getValue();
                for (Stanza child : ll) {
                    bld.append(prefix);
                    bld.append("<").append(key).append(">");
                    bld.append(child.toString());
                    prefix = ", ";
                }
            }
            bld.append("}");
            return bld.toString();
        }
    }

    public static class UnmanglingError
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public UnmanglingError(String str, Exception e) {
            super(str, e);
        }

        public UnmanglingError(String str) {
            super(str);
        }
    }

    public static class InvalidXmlException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public InvalidXmlException(String s) {
            super(s);
        }
    }
}

