/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.io;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configurable;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.io.Writable;
import shaded.org.apache.hadoop.io.WritableFactory;
import shaded.org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class WritableFactories {
    private static final Map<Class, WritableFactory> CLASS_TO_FACTORY = new ConcurrentHashMap<Class, WritableFactory>();

    private WritableFactories() {
    }

    public static void setFactory(Class c, WritableFactory factory) {
        CLASS_TO_FACTORY.put(c, factory);
    }

    public static WritableFactory getFactory(Class c) {
        return CLASS_TO_FACTORY.get(c);
    }

    public static Writable newInstance(Class<? extends Writable> c, Configuration conf) {
        WritableFactory factory = WritableFactories.getFactory(c);
        if (factory != null) {
            Writable result = factory.newInstance();
            if (result instanceof Configurable) {
                ((Configurable)((Object)result)).setConf(conf);
            }
            return result;
        }
        return ReflectionUtils.newInstance(c, conf);
    }

    public static Writable newInstance(Class<? extends Writable> c) {
        return WritableFactories.newInstance(c, null);
    }
}

