/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.ipc;

import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import shaded.org.apache.hadoop.ipc.Server;
import shaded.org.apache.hadoop.ipc.protobuf.RpcHeaderProtos;
import shaded.org.apache.hadoop.security.UserGroupInformation;

public abstract class ExternalCall<T>
extends Server.Call {
    private final PrivilegedExceptionAction<T> action;
    private final AtomicBoolean done = new AtomicBoolean();
    private T result;
    private Throwable error;

    public ExternalCall(PrivilegedExceptionAction<T> action) {
        this.action = action;
    }

    @Override
    public String getDetailedMetricsName() {
        return "(external)";
    }

    @Override
    public abstract UserGroupInformation getRemoteUser();

    public final T get() throws InterruptedException, ExecutionException {
        this.waitForCompletion();
        if (this.error != null) {
            throw new ExecutionException(this.error);
        }
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCompletion() throws InterruptedException {
        AtomicBoolean atomicBoolean = this.done;
        synchronized (atomicBoolean) {
            while (!this.done.get()) {
                try {
                    this.done.wait();
                }
                catch (InterruptedException ie) {
                    if (!Thread.interrupted()) continue;
                    throw ie;
                }
            }
        }
    }

    boolean isDone() {
        return this.done.get();
    }

    @Override
    public final Void run() throws IOException {
        try {
            this.result = this.action.run();
            this.sendResponse();
        }
        catch (Throwable t) {
            this.abortResponse(t);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void doResponse(Throwable t, RpcHeaderProtos.RpcResponseHeaderProto.RpcStatusProto status) {
        AtomicBoolean atomicBoolean = this.done;
        synchronized (atomicBoolean) {
            this.error = t;
            this.done.set(true);
            this.done.notify();
        }
    }
}

