/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.FSDataOutputStream;
import shaded.org.apache.hadoop.fs.FileSystem;
import shaded.org.apache.hadoop.fs.LocalDirAllocator;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.io.DataInputBuffer;
import shaded.org.apache.hadoop.io.DataOutputBuffer;
import shaded.org.apache.hadoop.io.WritableUtils;
import shaded.org.apache.hadoop.mapred.IFile;
import shaded.org.apache.hadoop.mapred.Merger;
import shaded.org.apache.hadoop.mapred.RamManager;
import shaded.org.apache.hadoop.mapred.TaskAttemptID;
import shaded.org.apache.hadoop.mapreduce.CryptoUtils;
import shaded.org.apache.hadoop.mapreduce.task.reduce.InMemoryReader;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class BackupStore<K, V> {
    private static final Log LOG = LogFactory.getLog((String)BackupStore.class.getName());
    private static final int MAX_VINT_SIZE = 9;
    private static final int EOF_MARKER_SIZE = 18;
    private final shaded.org.apache.hadoop.mapreduce.TaskAttemptID tid;
    private MemoryCache memCache;
    private FileCache fileCache;
    List<Merger.Segment<K, V>> segmentList = new LinkedList<Merger.Segment<K, V>>();
    private int readSegmentIndex = 0;
    private int firstSegmentOffset = 0;
    private int currentKVOffset = 0;
    private int nextKVOffset = -1;
    private DataInputBuffer currentKey = null;
    private DataInputBuffer currentValue = new DataInputBuffer();
    private DataInputBuffer currentDiskValue = new DataInputBuffer();
    private boolean hasMore = false;
    private boolean inReset = false;
    private boolean clearMarkFlag = false;
    private boolean lastSegmentEOF = false;
    private Configuration conf;

    public BackupStore(Configuration conf, shaded.org.apache.hadoop.mapreduce.TaskAttemptID taskid) throws IOException {
        float bufferPercent = conf.getFloat("mapreduce.reduce.markreset.buffer.percent", 0.0f);
        if ((double)bufferPercent > 1.0 || (double)bufferPercent < 0.0) {
            throw new IOException("mapreduce.reduce.markreset.buffer.percent" + bufferPercent);
        }
        int maxSize = (int)Math.min((float)Runtime.getRuntime().maxMemory() * bufferPercent, 2.1474836E9f);
        int tmp = conf.getInt("mapreduce.reduce.markreset.buffer.size", 0);
        if (tmp > 0) {
            maxSize = tmp;
        }
        this.memCache = new MemoryCache(maxSize);
        this.fileCache = new FileCache(conf);
        this.tid = taskid;
        this.conf = conf;
        LOG.info((Object)("Created a new BackupStore with a memory of " + maxSize));
    }

    public void write(DataInputBuffer key, DataInputBuffer value) throws IOException {
        assert (key != null && value != null);
        if (this.fileCache.isActive()) {
            this.fileCache.write(key, value);
            return;
        }
        if (this.memCache.reserveSpace(key, value)) {
            this.memCache.write(key, value);
        } else {
            this.fileCache.activate();
            this.fileCache.write(key, value);
        }
    }

    public void mark() throws IOException {
        if (this.nextKVOffset == 0) {
            assert (this.readSegmentIndex != 0);
            assert (this.currentKVOffset != 0);
            --this.readSegmentIndex;
        }
        int i = 0;
        Iterator<Merger.Segment<K, V>> itr = this.segmentList.iterator();
        while (itr.hasNext()) {
            Merger.Segment<K, V> s = itr.next();
            if (i == this.readSegmentIndex) break;
            s.close();
            itr.remove();
            ++i;
            LOG.debug((Object)"Dropping a segment");
        }
        this.firstSegmentOffset = this.currentKVOffset;
        this.readSegmentIndex = 0;
        LOG.debug((Object)("Setting the FirsSegmentOffset to " + this.currentKVOffset));
    }

    public void reset() throws IOException {
        if (!this.inReset) {
            if (this.fileCache.isActive) {
                this.fileCache.createInDiskSegment();
            } else {
                this.memCache.createInMemorySegment();
            }
        }
        this.inReset = true;
        for (int i = 0; i < this.segmentList.size(); ++i) {
            Merger.Segment<K, V> s = this.segmentList.get(i);
            if (s.inMemory()) {
                int offset = i == 0 ? this.firstSegmentOffset : 0;
                s.getReader().reset(offset);
                continue;
            }
            s.closeReader();
            if (i != 0) continue;
            s.reinitReader(this.firstSegmentOffset);
            s.getReader().disableChecksumValidation();
        }
        this.currentKVOffset = this.firstSegmentOffset;
        this.nextKVOffset = -1;
        this.readSegmentIndex = 0;
        this.hasMore = false;
        this.lastSegmentEOF = false;
        LOG.debug((Object)("Reset - First segment offset is " + this.firstSegmentOffset + " Segment List Size is " + this.segmentList.size()));
    }

    public boolean hasNext() throws IOException {
        if (this.lastSegmentEOF) {
            return false;
        }
        if (this.hasMore) {
            return true;
        }
        Merger.Segment<K, V> seg = this.segmentList.get(this.readSegmentIndex);
        this.nextKVOffset = (int)seg.getActualPosition();
        if (seg.nextRawKey()) {
            this.currentKey = seg.getKey();
            seg.getValue(this.currentValue);
            this.hasMore = true;
            return true;
        }
        if (!seg.inMemory()) {
            seg.closeReader();
        }
        if (this.readSegmentIndex == this.segmentList.size() - 1) {
            this.nextKVOffset = -1;
            this.lastSegmentEOF = true;
            return false;
        }
        this.nextKVOffset = 0;
        ++this.readSegmentIndex;
        Merger.Segment<K, V> nextSegment = this.segmentList.get(this.readSegmentIndex);
        if (!nextSegment.inMemory()) {
            this.currentValue.reset(this.currentDiskValue.getData(), this.currentDiskValue.getLength());
            nextSegment.init(null);
        }
        if (nextSegment.nextRawKey()) {
            this.currentKey = nextSegment.getKey();
            nextSegment.getValue(this.currentValue);
            this.hasMore = true;
            return true;
        }
        throw new IOException("New segment did not have even one K/V");
    }

    public void next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("iterate past last value");
        }
        this.hasMore = false;
        this.currentKVOffset = this.nextKVOffset;
        this.nextKVOffset = -1;
    }

    public DataInputBuffer nextValue() {
        return this.currentValue;
    }

    public DataInputBuffer nextKey() {
        return this.currentKey;
    }

    public void reinitialize() throws IOException {
        if (this.segmentList.size() != 0) {
            this.clearSegmentList();
        }
        this.memCache.reinitialize(true);
        this.fileCache.reinitialize();
        this.firstSegmentOffset = 0;
        this.readSegmentIndex = 0;
        this.currentKVOffset = 0;
        this.nextKVOffset = -1;
        this.clearMarkFlag = false;
        this.inReset = false;
        this.hasMore = false;
    }

    public void exitResetMode() throws IOException {
        this.inReset = false;
        if (this.clearMarkFlag) {
            this.reinitialize();
            return;
        }
        if (!this.fileCache.isActive) {
            this.memCache.reinitialize(false);
        }
    }

    public DataOutputStream getOutputStream(int length) throws IOException {
        if (this.memCache.reserveSpace(length)) {
            return this.memCache.dataOut;
        }
        this.fileCache.activate();
        return this.fileCache.writer.getOutputStream();
    }

    public void updateCounters(int length) {
        if (this.fileCache.isActive) {
            this.fileCache.writer.updateCountersForExternalAppend(length);
        } else {
            this.memCache.usedSize += length;
        }
    }

    public void clearMark() throws IOException {
        if (this.inReset) {
            this.clearMarkFlag = true;
        } else {
            this.reinitialize();
        }
    }

    private void clearSegmentList() throws IOException {
        for (Merger.Segment<K, V> segment : this.segmentList) {
            long len = segment.getLength();
            segment.close();
            if (!segment.inMemory()) continue;
            this.memCache.unreserve(len);
        }
        this.segmentList.clear();
    }

    static class BackupRamManager
    implements RamManager {
        private int availableSize = 0;
        private final int maxSize;

        public BackupRamManager(int size) {
            this.availableSize = this.maxSize = size;
        }

        @Override
        public boolean reserve(int requestedSize, InputStream in) {
            LOG.warn((Object)"Reserve(int, InputStream) not supported by BackupRamManager");
            return false;
        }

        int reserve(int requestedSize) {
            if (this.availableSize == 0) {
                return 0;
            }
            int reservedSize = Math.min(requestedSize, this.availableSize);
            this.availableSize -= reservedSize;
            LOG.debug((Object)("Reserving: " + reservedSize + " Requested: " + requestedSize));
            return reservedSize;
        }

        int reserve(int requestedSize, int minSize) {
            if (this.availableSize < minSize) {
                LOG.debug((Object)("No space available. Available: " + this.availableSize + " MinSize: " + minSize));
                return 0;
            }
            return this.reserve(requestedSize);
        }

        @Override
        public void unreserve(int requestedSize) {
            this.availableSize += requestedSize;
            LOG.debug((Object)("Unreserving: " + requestedSize + ". Available: " + this.availableSize));
        }

        void reinitialize() {
            this.availableSize = this.maxSize;
        }
    }

    class FileCache {
        private LocalDirAllocator lDirAlloc;
        private final Configuration conf;
        private final FileSystem fs;
        private boolean isActive = false;
        private Path file = null;
        private IFile.Writer<K, V> writer = null;
        private int spillNumber = 0;

        public FileCache(Configuration conf) throws IOException {
            this.conf = conf;
            this.fs = FileSystem.getLocal(conf);
            this.lDirAlloc = new LocalDirAllocator("mapreduce.cluster.local.dir");
        }

        void write(DataInputBuffer key, DataInputBuffer value) throws IOException {
            if (this.writer == null) {
                assert (this.spillNumber != 0);
                this.writer = this.createSpillFile();
            }
            this.writer.append(key, value);
            LOG.debug((Object)("ID: " + BackupStore.this.segmentList.size() + " WRITE TO DISK"));
        }

        void reinitialize() {
            this.spillNumber = 0;
            this.writer = null;
            this.isActive = false;
        }

        void activate() throws IOException {
            this.isActive = true;
            this.writer = this.createSpillFile();
        }

        void createInDiskSegment() throws IOException {
            assert (this.writer != null);
            this.writer.close();
            Merger.Segment s = new Merger.Segment(this.conf, this.fs, this.file, null, true);
            this.writer = null;
            BackupStore.this.segmentList.add(s);
            LOG.debug((Object)("Disk Segment added to List. Size is " + BackupStore.this.segmentList.size()));
        }

        boolean isActive() {
            return this.isActive;
        }

        private IFile.Writer<K, V> createSpillFile() throws IOException {
            Path tmp = new Path("output/backup_" + BackupStore.this.tid.getId() + "_" + this.spillNumber++ + ".out");
            LOG.info((Object)("Created file: " + tmp));
            this.file = this.lDirAlloc.getLocalPathForWrite(tmp.toUri().getPath(), -1L, this.conf);
            FSDataOutputStream out = this.fs.create(this.file);
            out = CryptoUtils.wrapIfNecessary(this.conf, out);
            return new IFile.Writer(this.conf, out, null, null, null, null, true);
        }
    }

    class MemoryCache {
        private DataOutputBuffer dataOut;
        private int blockSize;
        private int usedSize;
        private final BackupRamManager ramManager;
        private int defaultBlockSize = 0x100000;

        public MemoryCache(int maxSize) {
            this.ramManager = new BackupRamManager(maxSize);
            if (maxSize < this.defaultBlockSize) {
                this.defaultBlockSize = maxSize;
            }
        }

        public void unreserve(long len) {
            this.ramManager.unreserve((int)len);
        }

        void reinitialize(boolean clearAll) {
            if (clearAll) {
                this.ramManager.reinitialize();
            }
            int allocatedSize = this.createNewMemoryBlock(this.defaultBlockSize, this.defaultBlockSize);
            assert (allocatedSize == this.defaultBlockSize || allocatedSize == 0);
            LOG.debug((Object)("Created a new mem block of " + allocatedSize));
        }

        private int createNewMemoryBlock(int requestedSize, int minSize) {
            int allocatedSize = this.ramManager.reserve(requestedSize, minSize);
            this.usedSize = 0;
            if (allocatedSize == 0) {
                this.dataOut = null;
                this.blockSize = 0;
            } else {
                this.dataOut = new DataOutputBuffer(allocatedSize);
                this.blockSize = allocatedSize;
            }
            return allocatedSize;
        }

        boolean reserveSpace(int length) throws IOException {
            int availableSize = this.blockSize - this.usedSize;
            if (availableSize >= length + 18) {
                return true;
            }
            assert (!BackupStore.this.inReset);
            this.createInMemorySegment();
            int tmp = Math.max(length + 18, this.defaultBlockSize);
            availableSize = this.createNewMemoryBlock(tmp, length + 18);
            return availableSize != 0;
        }

        boolean reserveSpace(DataInputBuffer key, DataInputBuffer value) throws IOException {
            int keyLength = key.getLength() - key.getPosition();
            int valueLength = value.getLength() - value.getPosition();
            int requestedSize = keyLength + valueLength + WritableUtils.getVIntSize(keyLength) + WritableUtils.getVIntSize(valueLength);
            return this.reserveSpace(requestedSize);
        }

        public void write(DataInputBuffer key, DataInputBuffer value) throws IOException {
            int keyLength = key.getLength() - key.getPosition();
            int valueLength = value.getLength() - value.getPosition();
            WritableUtils.writeVInt(this.dataOut, keyLength);
            WritableUtils.writeVInt(this.dataOut, valueLength);
            this.dataOut.write(key.getData(), key.getPosition(), keyLength);
            this.dataOut.write(value.getData(), value.getPosition(), valueLength);
            this.usedSize += keyLength + valueLength + WritableUtils.getVIntSize(keyLength) + WritableUtils.getVIntSize(valueLength);
            LOG.debug((Object)("ID: " + BackupStore.this.segmentList.size() + " WRITE TO MEM"));
        }

        void createInMemorySegment() throws IOException {
            if (this.usedSize == 0) {
                this.ramManager.unreserve(this.blockSize);
                return;
            }
            assert (this.blockSize - this.usedSize >= 18);
            WritableUtils.writeVInt(this.dataOut, -1);
            WritableUtils.writeVInt(this.dataOut, -1);
            this.usedSize += 18;
            this.ramManager.unreserve(this.blockSize - this.usedSize);
            InMemoryReader reader = new InMemoryReader(null, (TaskAttemptID)BackupStore.this.tid, this.dataOut.getData(), 0, this.usedSize, BackupStore.this.conf);
            Merger.Segment segment = new Merger.Segment(reader, false);
            BackupStore.this.segmentList.add(segment);
            LOG.debug((Object)("Added Memory Segment to List. List Size is " + BackupStore.this.segmentList.size()));
        }
    }
}

