/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred;

import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.fs.FileSystem;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.io.BytesWritable;
import shaded.org.apache.hadoop.io.SequenceFile;
import shaded.org.apache.hadoop.io.Writable;
import shaded.org.apache.hadoop.io.WritableComparable;
import shaded.org.apache.hadoop.io.compress.CompressionCodec;
import shaded.org.apache.hadoop.io.compress.DefaultCodec;
import shaded.org.apache.hadoop.mapred.FileOutputFormat;
import shaded.org.apache.hadoop.mapred.InvalidJobConfException;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapred.RecordWriter;
import shaded.org.apache.hadoop.mapred.Reporter;
import shaded.org.apache.hadoop.mapred.SequenceFileOutputFormat;
import shaded.org.apache.hadoop.mapreduce.lib.output.SequenceFileAsBinaryOutputFormat;
import shaded.org.apache.hadoop.util.Progressable;
import shaded.org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SequenceFileAsBinaryOutputFormat
extends SequenceFileOutputFormat<BytesWritable, BytesWritable> {
    public static void setSequenceFileOutputKeyClass(JobConf conf, Class<?> theClass) {
        conf.setClass(shaded.org.apache.hadoop.mapreduce.lib.output.SequenceFileAsBinaryOutputFormat.KEY_CLASS, theClass, Object.class);
    }

    public static void setSequenceFileOutputValueClass(JobConf conf, Class<?> theClass) {
        conf.setClass(shaded.org.apache.hadoop.mapreduce.lib.output.SequenceFileAsBinaryOutputFormat.VALUE_CLASS, theClass, Object.class);
    }

    public static Class<? extends WritableComparable> getSequenceFileOutputKeyClass(JobConf conf) {
        return conf.getClass(shaded.org.apache.hadoop.mapreduce.lib.output.SequenceFileAsBinaryOutputFormat.KEY_CLASS, conf.getOutputKeyClass().asSubclass(WritableComparable.class), WritableComparable.class);
    }

    public static Class<? extends Writable> getSequenceFileOutputValueClass(JobConf conf) {
        return conf.getClass(shaded.org.apache.hadoop.mapreduce.lib.output.SequenceFileAsBinaryOutputFormat.VALUE_CLASS, conf.getOutputValueClass().asSubclass(Writable.class), Writable.class);
    }

    @Override
    public RecordWriter<BytesWritable, BytesWritable> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        Path file = FileOutputFormat.getTaskOutputPath(job, name);
        FileSystem fs = file.getFileSystem(job);
        CompressionCodec codec = null;
        SequenceFile.CompressionType compressionType = SequenceFile.CompressionType.NONE;
        if (SequenceFileAsBinaryOutputFormat.getCompressOutput(job)) {
            compressionType = SequenceFileAsBinaryOutputFormat.getOutputCompressionType(job);
            Class<CompressionCodec> codecClass = SequenceFileAsBinaryOutputFormat.getOutputCompressorClass(job, DefaultCodec.class);
            codec = ReflectionUtils.newInstance(codecClass, job);
        }
        final SequenceFile.Writer out = SequenceFile.createWriter(fs, job, file, SequenceFileAsBinaryOutputFormat.getSequenceFileOutputKeyClass(job), SequenceFileAsBinaryOutputFormat.getSequenceFileOutputValueClass(job), compressionType, codec, progress);
        return new RecordWriter<BytesWritable, BytesWritable>(){
            private WritableValueBytes wvaluebytes = new WritableValueBytes();

            @Override
            public void write(BytesWritable bkey, BytesWritable bvalue) throws IOException {
                this.wvaluebytes.reset(bvalue);
                out.appendRaw(bkey.getBytes(), 0, bkey.getLength(), this.wvaluebytes);
                this.wvaluebytes.reset(null);
            }

            @Override
            public void close(Reporter reporter) throws IOException {
                out.close();
            }
        };
    }

    @Override
    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        super.checkOutputSpecs(ignored, job);
        if (SequenceFileAsBinaryOutputFormat.getCompressOutput(job) && SequenceFileAsBinaryOutputFormat.getOutputCompressionType(job) == SequenceFile.CompressionType.RECORD) {
            throw new InvalidJobConfException("SequenceFileAsBinaryOutputFormat doesn't support Record Compression");
        }
    }

    protected static class WritableValueBytes
    extends SequenceFileAsBinaryOutputFormat.WritableValueBytes {
        public WritableValueBytes() {
        }

        public WritableValueBytes(BytesWritable value) {
            super(value);
        }
    }
}

