/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred;

import java.io.IOException;
import java.util.Map;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.fs.FileSystem;
import shaded.org.apache.hadoop.fs.LocalDirAllocator;
import shaded.org.apache.hadoop.io.compress.CompressionCodec;
import shaded.org.apache.hadoop.mapred.Counters;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapred.MapOutputFile;
import shaded.org.apache.hadoop.mapred.RawKeyValueIterator;
import shaded.org.apache.hadoop.mapred.Reducer;
import shaded.org.apache.hadoop.mapred.Reporter;
import shaded.org.apache.hadoop.mapred.Task;
import shaded.org.apache.hadoop.mapred.TaskAttemptID;
import shaded.org.apache.hadoop.mapred.TaskStatus;
import shaded.org.apache.hadoop.mapred.TaskUmbilicalProtocol;
import shaded.org.apache.hadoop.util.Progress;

@InterfaceAudience.LimitedPrivate(value={"mapreduce"})
@InterfaceStability.Unstable
public interface ShuffleConsumerPlugin<K, V> {
    public void init(Context<K, V> var1);

    public RawKeyValueIterator run() throws IOException, InterruptedException;

    public void close();

    @InterfaceAudience.LimitedPrivate(value={"mapreduce"})
    @InterfaceStability.Unstable
    public static class Context<K, V> {
        private final shaded.org.apache.hadoop.mapreduce.TaskAttemptID reduceId;
        private final JobConf jobConf;
        private final FileSystem localFS;
        private final TaskUmbilicalProtocol umbilical;
        private final LocalDirAllocator localDirAllocator;
        private final Reporter reporter;
        private final CompressionCodec codec;
        private final Class<? extends Reducer> combinerClass;
        private final Task.CombineOutputCollector<K, V> combineCollector;
        private final Counters.Counter spilledRecordsCounter;
        private final Counters.Counter reduceCombineInputCounter;
        private final Counters.Counter shuffledMapsCounter;
        private final Counters.Counter reduceShuffleBytes;
        private final Counters.Counter failedShuffleCounter;
        private final Counters.Counter mergedMapOutputsCounter;
        private final TaskStatus status;
        private final Progress copyPhase;
        private final Progress mergePhase;
        private final Task reduceTask;
        private final MapOutputFile mapOutputFile;
        private final Map<TaskAttemptID, MapOutputFile> localMapFiles;

        public Context(shaded.org.apache.hadoop.mapreduce.TaskAttemptID reduceId, JobConf jobConf, FileSystem localFS, TaskUmbilicalProtocol umbilical, LocalDirAllocator localDirAllocator, Reporter reporter, CompressionCodec codec, Class<? extends Reducer> combinerClass, Task.CombineOutputCollector<K, V> combineCollector, Counters.Counter spilledRecordsCounter, Counters.Counter reduceCombineInputCounter, Counters.Counter shuffledMapsCounter, Counters.Counter reduceShuffleBytes, Counters.Counter failedShuffleCounter, Counters.Counter mergedMapOutputsCounter, TaskStatus status, Progress copyPhase, Progress mergePhase, Task reduceTask, MapOutputFile mapOutputFile, Map<TaskAttemptID, MapOutputFile> localMapFiles) {
            this.reduceId = reduceId;
            this.jobConf = jobConf;
            this.localFS = localFS;
            this.umbilical = umbilical;
            this.localDirAllocator = localDirAllocator;
            this.reporter = reporter;
            this.codec = codec;
            this.combinerClass = combinerClass;
            this.combineCollector = combineCollector;
            this.spilledRecordsCounter = spilledRecordsCounter;
            this.reduceCombineInputCounter = reduceCombineInputCounter;
            this.shuffledMapsCounter = shuffledMapsCounter;
            this.reduceShuffleBytes = reduceShuffleBytes;
            this.failedShuffleCounter = failedShuffleCounter;
            this.mergedMapOutputsCounter = mergedMapOutputsCounter;
            this.status = status;
            this.copyPhase = copyPhase;
            this.mergePhase = mergePhase;
            this.reduceTask = reduceTask;
            this.mapOutputFile = mapOutputFile;
            this.localMapFiles = localMapFiles;
        }

        public shaded.org.apache.hadoop.mapreduce.TaskAttemptID getReduceId() {
            return this.reduceId;
        }

        public JobConf getJobConf() {
            return this.jobConf;
        }

        public FileSystem getLocalFS() {
            return this.localFS;
        }

        public TaskUmbilicalProtocol getUmbilical() {
            return this.umbilical;
        }

        public LocalDirAllocator getLocalDirAllocator() {
            return this.localDirAllocator;
        }

        public Reporter getReporter() {
            return this.reporter;
        }

        public CompressionCodec getCodec() {
            return this.codec;
        }

        public Class<? extends Reducer> getCombinerClass() {
            return this.combinerClass;
        }

        public Task.CombineOutputCollector<K, V> getCombineCollector() {
            return this.combineCollector;
        }

        public Counters.Counter getSpilledRecordsCounter() {
            return this.spilledRecordsCounter;
        }

        public Counters.Counter getReduceCombineInputCounter() {
            return this.reduceCombineInputCounter;
        }

        public Counters.Counter getShuffledMapsCounter() {
            return this.shuffledMapsCounter;
        }

        public Counters.Counter getReduceShuffleBytes() {
            return this.reduceShuffleBytes;
        }

        public Counters.Counter getFailedShuffleCounter() {
            return this.failedShuffleCounter;
        }

        public Counters.Counter getMergedMapOutputsCounter() {
            return this.mergedMapOutputsCounter;
        }

        public TaskStatus getStatus() {
            return this.status;
        }

        public Progress getCopyPhase() {
            return this.copyPhase;
        }

        public Progress getMergePhase() {
            return this.mergePhase;
        }

        public Task getReduceTask() {
            return this.reduceTask;
        }

        public MapOutputFile getMapOutputFile() {
            return this.mapOutputFile;
        }

        public Map<TaskAttemptID, MapOutputFile> getLocalMapFiles() {
            return this.localMapFiles;
        }
    }
}

