/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapred.pipes;

import shaded.org.apache.hadoop.io.Writable;
import shaded.org.apache.hadoop.io.WritableComparable;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapred.Partitioner;
import shaded.org.apache.hadoop.mapred.pipes.Submitter;
import shaded.org.apache.hadoop.util.ReflectionUtils;

class PipesPartitioner<K extends WritableComparable, V extends Writable>
implements Partitioner<K, V> {
    private static final ThreadLocal<Integer> CACHE = new ThreadLocal();
    private Partitioner<K, V> part = null;

    PipesPartitioner() {
    }

    @Override
    public void configure(JobConf conf) {
        this.part = ReflectionUtils.newInstance(Submitter.getJavaPartitioner(conf), conf);
    }

    static void setNextPartition(int newValue) {
        CACHE.set(newValue);
    }

    @Override
    public int getPartition(K key, V value, int numPartitions) {
        Integer result = CACHE.get();
        if (result == null) {
            return this.part.getPartition(key, value, numPartitions);
        }
        return result;
    }
}

