/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.io.Writable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ClusterMetrics
implements Writable {
    private int runningMaps;
    private int runningReduces;
    private int occupiedMapSlots;
    private int occupiedReduceSlots;
    private int reservedMapSlots;
    private int reservedReduceSlots;
    private int totalMapSlots;
    private int totalReduceSlots;
    private int totalJobSubmissions;
    private int numTrackers;
    private int numBlacklistedTrackers;
    private int numGraylistedTrackers;
    private int numDecommissionedTrackers;

    public ClusterMetrics() {
    }

    public ClusterMetrics(int runningMaps, int runningReduces, int occupiedMapSlots, int occupiedReduceSlots, int reservedMapSlots, int reservedReduceSlots, int mapSlots, int reduceSlots, int totalJobSubmissions, int numTrackers, int numBlacklistedTrackers, int numDecommissionedNodes) {
        this(runningMaps, runningReduces, occupiedMapSlots, occupiedReduceSlots, reservedMapSlots, reservedReduceSlots, mapSlots, reduceSlots, totalJobSubmissions, numTrackers, numBlacklistedTrackers, 0, numDecommissionedNodes);
    }

    public ClusterMetrics(int runningMaps, int runningReduces, int occupiedMapSlots, int occupiedReduceSlots, int reservedMapSlots, int reservedReduceSlots, int mapSlots, int reduceSlots, int totalJobSubmissions, int numTrackers, int numBlacklistedTrackers, int numGraylistedTrackers, int numDecommissionedNodes) {
        this.runningMaps = runningMaps;
        this.runningReduces = runningReduces;
        this.occupiedMapSlots = occupiedMapSlots;
        this.occupiedReduceSlots = occupiedReduceSlots;
        this.reservedMapSlots = reservedMapSlots;
        this.reservedReduceSlots = reservedReduceSlots;
        this.totalMapSlots = mapSlots;
        this.totalReduceSlots = reduceSlots;
        this.totalJobSubmissions = totalJobSubmissions;
        this.numTrackers = numTrackers;
        this.numBlacklistedTrackers = numBlacklistedTrackers;
        this.numGraylistedTrackers = numGraylistedTrackers;
        this.numDecommissionedTrackers = numDecommissionedNodes;
    }

    public int getRunningMaps() {
        return this.runningMaps;
    }

    public int getRunningReduces() {
        return this.runningReduces;
    }

    public int getOccupiedMapSlots() {
        return this.occupiedMapSlots;
    }

    public int getOccupiedReduceSlots() {
        return this.occupiedReduceSlots;
    }

    public int getReservedMapSlots() {
        return this.reservedMapSlots;
    }

    public int getReservedReduceSlots() {
        return this.reservedReduceSlots;
    }

    public int getMapSlotCapacity() {
        return this.totalMapSlots;
    }

    public int getReduceSlotCapacity() {
        return this.totalReduceSlots;
    }

    public int getTotalJobSubmissions() {
        return this.totalJobSubmissions;
    }

    public int getTaskTrackerCount() {
        return this.numTrackers;
    }

    public int getBlackListedTaskTrackerCount() {
        return this.numBlacklistedTrackers;
    }

    public int getGrayListedTaskTrackerCount() {
        return this.numGraylistedTrackers;
    }

    public int getDecommissionedTaskTrackerCount() {
        return this.numDecommissionedTrackers;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.runningMaps = in.readInt();
        this.runningReduces = in.readInt();
        this.occupiedMapSlots = in.readInt();
        this.occupiedReduceSlots = in.readInt();
        this.reservedMapSlots = in.readInt();
        this.reservedReduceSlots = in.readInt();
        this.totalMapSlots = in.readInt();
        this.totalReduceSlots = in.readInt();
        this.totalJobSubmissions = in.readInt();
        this.numTrackers = in.readInt();
        this.numBlacklistedTrackers = in.readInt();
        this.numGraylistedTrackers = in.readInt();
        this.numDecommissionedTrackers = in.readInt();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeInt(this.runningMaps);
        out.writeInt(this.runningReduces);
        out.writeInt(this.occupiedMapSlots);
        out.writeInt(this.occupiedReduceSlots);
        out.writeInt(this.reservedMapSlots);
        out.writeInt(this.reservedReduceSlots);
        out.writeInt(this.totalMapSlots);
        out.writeInt(this.totalReduceSlots);
        out.writeInt(this.totalJobSubmissions);
        out.writeInt(this.numTrackers);
        out.writeInt(this.numBlacklistedTrackers);
        out.writeInt(this.numGraylistedTrackers);
        out.writeInt(this.numDecommissionedTrackers);
    }
}

