/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.filecache;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.FileStatus;
import shaded.org.apache.hadoop.fs.FileSystem;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.fs.permission.FsAction;
import shaded.org.apache.hadoop.fs.permission.FsPermission;
import shaded.org.apache.hadoop.mapreduce.filecache.DistributedCache;
import shaded.org.apache.hadoop.mapreduce.security.TokenCache;
import shaded.org.apache.hadoop.security.Credentials;

@InterfaceAudience.Private
public class ClientDistributedCacheManager {
    public static void determineTimestampsAndCacheVisibilities(Configuration job) throws IOException {
        HashMap<URI, FileStatus> statCache = new HashMap<URI, FileStatus>();
        ClientDistributedCacheManager.determineTimestampsAndCacheVisibilities(job, statCache);
    }

    public static void determineTimestampsAndCacheVisibilities(Configuration job, Map<URI, FileStatus> statCache) throws IOException {
        ClientDistributedCacheManager.determineTimestamps(job, statCache);
        ClientDistributedCacheManager.determineCacheVisibilities(job, statCache);
    }

    public static void determineTimestamps(Configuration job, Map<URI, FileStatus> statCache) throws IOException {
        URI[] tfiles;
        URI[] tarchives = DistributedCache.getCacheArchives(job);
        if (tarchives != null) {
            FileStatus status = ClientDistributedCacheManager.getFileStatus(job, tarchives[0], statCache);
            StringBuilder archiveFileSizes = new StringBuilder(String.valueOf(status.getLen()));
            StringBuilder archiveTimestamps = new StringBuilder(String.valueOf(status.getModificationTime()));
            for (int i = 1; i < tarchives.length; ++i) {
                status = ClientDistributedCacheManager.getFileStatus(job, tarchives[i], statCache);
                archiveFileSizes.append(",");
                archiveFileSizes.append(String.valueOf(status.getLen()));
                archiveTimestamps.append(",");
                archiveTimestamps.append(String.valueOf(status.getModificationTime()));
            }
            job.set("mapreduce.job.cache.archives.filesizes", archiveFileSizes.toString());
            ClientDistributedCacheManager.setArchiveTimestamps(job, archiveTimestamps.toString());
        }
        if ((tfiles = DistributedCache.getCacheFiles(job)) != null) {
            FileStatus status = ClientDistributedCacheManager.getFileStatus(job, tfiles[0], statCache);
            StringBuilder fileSizes = new StringBuilder(String.valueOf(status.getLen()));
            StringBuilder fileTimestamps = new StringBuilder(String.valueOf(status.getModificationTime()));
            for (int i = 1; i < tfiles.length; ++i) {
                status = ClientDistributedCacheManager.getFileStatus(job, tfiles[i], statCache);
                fileSizes.append(",");
                fileSizes.append(String.valueOf(status.getLen()));
                fileTimestamps.append(",");
                fileTimestamps.append(String.valueOf(status.getModificationTime()));
            }
            job.set("mapreduce.job.cache.files.filesizes", fileSizes.toString());
            ClientDistributedCacheManager.setFileTimestamps(job, fileTimestamps.toString());
        }
    }

    public static void getDelegationTokens(Configuration job, Credentials credentials) throws IOException {
        URI[] tarchives = DistributedCache.getCacheArchives(job);
        URI[] tfiles = DistributedCache.getCacheFiles(job);
        int size = (tarchives != null ? tarchives.length : 0) + (tfiles != null ? tfiles.length : 0);
        Path[] ps = new Path[size];
        int i = 0;
        if (tarchives != null) {
            for (i = 0; i < tarchives.length; ++i) {
                ps[i] = new Path(tarchives[i].toString());
            }
        }
        if (tfiles != null) {
            for (int j = 0; j < tfiles.length; ++j) {
                ps[i + j] = new Path(tfiles[j].toString());
            }
        }
        TokenCache.obtainTokensForNamenodes(credentials, ps, job);
    }

    public static void determineCacheVisibilities(Configuration job, Map<URI, FileStatus> statCache) throws IOException {
        URI[] tfiles;
        URI[] tarchives = DistributedCache.getCacheArchives(job);
        if (tarchives != null) {
            StringBuilder archiveVisibilities = new StringBuilder(String.valueOf(ClientDistributedCacheManager.isPublic(job, tarchives[0], statCache)));
            for (int i = 1; i < tarchives.length; ++i) {
                archiveVisibilities.append(",");
                archiveVisibilities.append(String.valueOf(ClientDistributedCacheManager.isPublic(job, tarchives[i], statCache)));
            }
            ClientDistributedCacheManager.setArchiveVisibilities(job, archiveVisibilities.toString());
        }
        if ((tfiles = DistributedCache.getCacheFiles(job)) != null) {
            StringBuilder fileVisibilities = new StringBuilder(String.valueOf(ClientDistributedCacheManager.isPublic(job, tfiles[0], statCache)));
            for (int i = 1; i < tfiles.length; ++i) {
                fileVisibilities.append(",");
                fileVisibilities.append(String.valueOf(ClientDistributedCacheManager.isPublic(job, tfiles[i], statCache)));
            }
            ClientDistributedCacheManager.setFileVisibilities(job, fileVisibilities.toString());
        }
    }

    static void setArchiveVisibilities(Configuration conf, String booleans) {
        conf.set("mapreduce.job.cache.archives.visibilities", booleans);
    }

    static void setFileVisibilities(Configuration conf, String booleans) {
        conf.set("mapreduce.job.cache.files.visibilities", booleans);
    }

    static void setArchiveTimestamps(Configuration conf, String timestamps) {
        conf.set("mapreduce.job.cache.archives.timestamps", timestamps);
    }

    static void setFileTimestamps(Configuration conf, String timestamps) {
        conf.set("mapreduce.job.cache.files.timestamps", timestamps);
    }

    private static FileStatus getFileStatus(Configuration job, URI uri, Map<URI, FileStatus> statCache) throws IOException {
        FileSystem fileSystem = FileSystem.get(uri, job);
        return ClientDistributedCacheManager.getFileStatus(fileSystem, uri, statCache);
    }

    static boolean isPublic(Configuration conf, URI uri, Map<URI, FileStatus> statCache) throws IOException {
        boolean isPublic = true;
        FileSystem fs = FileSystem.get(uri, conf);
        Path current = new Path(uri.getPath());
        if (!(current = fs.makeQualified(current)).getName().equals("*")) {
            isPublic = ClientDistributedCacheManager.checkPermissionOfOther(fs, current, FsAction.READ, statCache);
        }
        return isPublic && ClientDistributedCacheManager.ancestorsHaveExecutePermissions(fs, current.getParent(), statCache);
    }

    static boolean ancestorsHaveExecutePermissions(FileSystem fs, Path path, Map<URI, FileStatus> statCache) throws IOException {
        for (Path current = path; current != null; current = current.getParent()) {
            if (ClientDistributedCacheManager.checkPermissionOfOther(fs, current, FsAction.EXECUTE, statCache)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkPermissionOfOther(FileSystem fs, Path path, FsAction action, Map<URI, FileStatus> statCache) throws IOException {
        FsAction otherAction;
        FileStatus status = ClientDistributedCacheManager.getFileStatus(fs, path.toUri(), statCache);
        FsPermission perms = status.getPermission();
        return !perms.getEncryptedBit() && (otherAction = perms.getOtherAction()).implies(action);
    }

    private static FileStatus getFileStatus(FileSystem fs, URI uri, Map<URI, FileStatus> statCache) throws IOException {
        FileStatus stat;
        Path path = new Path(uri);
        if (path.getName().equals("*")) {
            path = path.getParent();
            uri = path.toUri();
        }
        if ((stat = statCache.get(uri)) == null) {
            stat = fs.getFileStatus(path);
            statCache.put(uri, stat);
        }
        return stat;
    }
}

