/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.lib.db;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.mapreduce.InputSplit;
import shaded.org.apache.hadoop.mapreduce.lib.db.BigDecimalSplitter;
import shaded.org.apache.hadoop.mapreduce.lib.db.DataDrivenDBInputFormat;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TextSplitter
extends BigDecimalSplitter {
    private static final Log LOG = LogFactory.getLog(TextSplitter.class);
    private static final BigDecimal ONE_PLACE = new BigDecimal(65536);
    private static final int MAX_CHARS = 8;

    @Override
    public List<InputSplit> split(Configuration conf, ResultSet results, String colName) throws SQLException {
        char c2;
        char c1;
        int sharedLen;
        LOG.warn((Object)"Generating splits for a textual index column.");
        LOG.warn((Object)"If your database sorts in a case-insensitive order, this may result in a partial import or duplicate records.");
        LOG.warn((Object)"You are strongly encouraged to choose an integral split column.");
        String minString = results.getString(1);
        String maxString = results.getString(2);
        boolean minIsNull = false;
        if (null == minString) {
            minString = "";
            minIsNull = true;
        }
        if (null == maxString) {
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
            splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(colName + " IS NULL", colName + " IS NULL"));
            return splits;
        }
        int numSplits = conf.getInt("mapreduce.job.maps", 1);
        String lowClausePrefix = colName + " >= '";
        String highClausePrefix = colName + " < '";
        int maxPrefixLen = Math.min(minString.length(), maxString.length());
        for (sharedLen = 0; sharedLen < maxPrefixLen && (c1 = minString.charAt(sharedLen)) == (c2 = maxString.charAt(sharedLen)); ++sharedLen) {
        }
        String commonPrefix = minString.substring(0, sharedLen);
        minString = minString.substring(sharedLen);
        maxString = maxString.substring(sharedLen);
        List<String> splitStrings = this.split(numSplits, minString, maxString, commonPrefix);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        String start = splitStrings.get(0);
        for (int i = 1; i < splitStrings.size(); ++i) {
            String end = splitStrings.get(i);
            if (i == splitStrings.size() - 1) {
                splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(lowClausePrefix + start + "'", colName + " <= '" + end + "'"));
                continue;
            }
            splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(lowClausePrefix + start + "'", highClausePrefix + end + "'"));
        }
        if (minIsNull) {
            splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(colName + " IS NULL", colName + " IS NULL"));
        }
        return splits;
    }

    List<String> split(int numSplits, String minString, String maxString, String commonPrefix) throws SQLException {
        BigDecimal minVal = this.stringToBigDecimal(minString);
        BigDecimal maxVal = this.stringToBigDecimal(maxString);
        List<BigDecimal> splitPoints = this.split(new BigDecimal(numSplits), minVal, maxVal);
        ArrayList<String> splitStrings = new ArrayList<String>();
        for (BigDecimal bd : splitPoints) {
            splitStrings.add(commonPrefix + this.bigDecimalToString(bd));
        }
        if (splitStrings.size() == 0 || !((String)splitStrings.get(0)).equals(commonPrefix + minString)) {
            splitStrings.add(0, commonPrefix + minString);
        }
        if (splitStrings.size() == 1 || !((String)splitStrings.get(splitStrings.size() - 1)).equals(commonPrefix + maxString)) {
            splitStrings.add(commonPrefix + maxString);
        }
        return splitStrings;
    }

    BigDecimal stringToBigDecimal(String str) {
        BigDecimal result = BigDecimal.ZERO;
        BigDecimal curPlace = ONE_PLACE;
        int len = Math.min(str.length(), 8);
        for (int i = 0; i < len; ++i) {
            int codePoint = str.codePointAt(i);
            result = result.add(this.tryDivide(new BigDecimal(codePoint), curPlace));
            curPlace = curPlace.multiply(ONE_PLACE);
        }
        return result;
    }

    String bigDecimalToString(BigDecimal bd) {
        int curCodePoint;
        BigDecimal cur = bd.stripTrailingZeros();
        StringBuilder sb = new StringBuilder();
        for (int numConverted = 0; numConverted < 8 && 0 != (curCodePoint = (cur = cur.multiply(ONE_PLACE)).intValue()); ++numConverted) {
            cur = cur.subtract(new BigDecimal(curCodePoint));
            sb.append(Character.toChars(curCodePoint));
        }
        return sb.toString();
    }
}

