/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.mapreduce.InputFormat;
import shaded.org.apache.hadoop.mapreduce.InputSplit;
import shaded.org.apache.hadoop.mapreduce.Job;
import shaded.org.apache.hadoop.mapreduce.JobContext;
import shaded.org.apache.hadoop.mapreduce.Mapper;
import shaded.org.apache.hadoop.mapreduce.RecordReader;
import shaded.org.apache.hadoop.mapreduce.TaskAttemptContext;
import shaded.org.apache.hadoop.mapreduce.lib.input.DelegatingRecordReader;
import shaded.org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import shaded.org.apache.hadoop.mapreduce.lib.input.MultipleInputs;
import shaded.org.apache.hadoop.mapreduce.lib.input.TaggedInputSplit;
import shaded.org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DelegatingInputFormat<K, V>
extends InputFormat<K, V> {
    @Override
    public List<InputSplit> getSplits(JobContext job) throws IOException, InterruptedException {
        Configuration conf = job.getConfiguration();
        Job jobCopy = Job.getInstance(conf);
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        Map<Path, InputFormat> formatMap = MultipleInputs.getInputFormatMap(job);
        Map<Path, Class<? extends Mapper>> mapperMap = MultipleInputs.getMapperTypeMap(job);
        HashMap formatPaths = new HashMap();
        for (Map.Entry<Path, InputFormat> entry : formatMap.entrySet()) {
            if (!formatPaths.containsKey(entry.getValue().getClass())) {
                formatPaths.put(entry.getValue().getClass(), new LinkedList());
            }
            ((List)formatPaths.get(entry.getValue().getClass())).add(entry.getKey());
        }
        for (Map.Entry entry : formatPaths.entrySet()) {
            Class<? extends Mapper<?, ?, ?, ?>> mapperClass;
            Class formatClass = (Class)((Object)entry.getKey());
            InputFormat format = (InputFormat)ReflectionUtils.newInstance(formatClass, conf);
            List paths = (List)((Object)entry.getValue());
            HashMap mapperPaths = new HashMap();
            for (Path path : paths) {
                mapperClass = mapperMap.get(path);
                if (!mapperPaths.containsKey(mapperClass)) {
                    mapperPaths.put(mapperClass, new LinkedList());
                }
                ((List)mapperPaths.get(mapperClass)).add(path);
            }
            for (Map.Entry entry2 : mapperPaths.entrySet()) {
                paths = (List)entry2.getValue();
                mapperClass = (Class<? extends Mapper<?, ?, ?, ?>>)entry2.getKey();
                if (mapperClass == null) {
                    try {
                        mapperClass = job.getMapperClass();
                    }
                    catch (ClassNotFoundException e) {
                        throw new IOException("Mapper class is not found", e);
                    }
                }
                FileInputFormat.setInputPaths(jobCopy, paths.toArray(new Path[paths.size()]));
                List<InputSplit> pathSplits = format.getSplits(jobCopy);
                for (InputSplit pathSplit : pathSplits) {
                    splits.add(new TaggedInputSplit(pathSplit, conf, format.getClass(), mapperClass));
                }
            }
        }
        return splits;
    }

    @Override
    public RecordReader<K, V> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new DelegatingRecordReader(split, context);
    }
}

