/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.lib.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.io.WritableComparable;
import shaded.org.apache.hadoop.mapreduce.InputFormat;
import shaded.org.apache.hadoop.mapreduce.InputSplit;
import shaded.org.apache.hadoop.mapreduce.JobContext;
import shaded.org.apache.hadoop.mapreduce.RecordReader;
import shaded.org.apache.hadoop.mapreduce.TaskAttemptContext;
import shaded.org.apache.hadoop.mapreduce.lib.join.ComposableRecordReader;
import shaded.org.apache.hadoop.mapreduce.lib.join.InnerJoinRecordReader;
import shaded.org.apache.hadoop.mapreduce.lib.join.OuterJoinRecordReader;
import shaded.org.apache.hadoop.mapreduce.lib.join.OverrideRecordReader;
import shaded.org.apache.hadoop.mapreduce.lib.join.Parser;
import shaded.org.apache.hadoop.mapreduce.lib.join.TupleWritable;
import shaded.org.apache.hadoop.mapreduce.lib.join.WrappedRecordReader;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class CompositeInputFormat<K extends WritableComparable>
extends InputFormat<K, TupleWritable> {
    public static final String JOIN_EXPR = "mapreduce.join.expr";
    public static final String JOIN_COMPARATOR = "mapreduce.join.keycomparator";
    private Parser.Node root;

    public void setFormat(Configuration conf) throws IOException {
        this.addDefaults();
        this.addUserIdentifiers(conf);
        this.root = Parser.parse(conf.get(JOIN_EXPR, null), conf);
    }

    protected void addDefaults() {
        try {
            Parser.CNode.addIdentifier("inner", InnerJoinRecordReader.class);
            Parser.CNode.addIdentifier("outer", OuterJoinRecordReader.class);
            Parser.CNode.addIdentifier("override", OverrideRecordReader.class);
            Parser.WNode.addIdentifier("tbl", WrappedRecordReader.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("FATAL: Failed to init defaults", e);
        }
    }

    private void addUserIdentifiers(Configuration conf) throws IOException {
        Pattern x = Pattern.compile("^mapreduce\\.join\\.define\\.(\\w+)$");
        for (Map.Entry<String, String> kv : conf) {
            Matcher m = x.matcher(kv.getKey());
            if (!m.matches()) continue;
            try {
                Parser.CNode.addIdentifier(m.group(1), conf.getClass(m.group(0), null, ComposableRecordReader.class));
            }
            catch (NoSuchMethodException e) {
                throw new IOException("Invalid define for " + m.group(1), e);
            }
        }
    }

    @Override
    public List<InputSplit> getSplits(JobContext job) throws IOException, InterruptedException {
        this.setFormat(job.getConfiguration());
        job.getConfiguration().setLong("mapreduce.input.fileinputformat.split.minsize", Long.MAX_VALUE);
        return this.root.getSplits(job);
    }

    @Override
    public RecordReader<K, TupleWritable> createRecordReader(InputSplit split, TaskAttemptContext taskContext) throws IOException, InterruptedException {
        this.setFormat(taskContext.getConfiguration());
        return this.root.createRecordReader(split, taskContext);
    }

    public static String compose(Class<? extends InputFormat> inf, String path) {
        return CompositeInputFormat.compose(inf.getName().intern(), path, new StringBuffer()).toString();
    }

    public static String compose(String op, Class<? extends InputFormat> inf, String ... path) {
        String infname = inf.getName();
        StringBuffer ret = new StringBuffer(op + '(');
        for (String p : path) {
            CompositeInputFormat.compose(infname, p, ret);
            ret.append(',');
        }
        ret.setCharAt(ret.length() - 1, ')');
        return ret.toString();
    }

    public static String compose(String op, Class<? extends InputFormat> inf, Path ... path) {
        ArrayList<String> tmp = new ArrayList<String>(path.length);
        for (Path p : path) {
            tmp.add(p.toString());
        }
        return CompositeInputFormat.compose(op, inf, tmp.toArray(new String[0]));
    }

    private static StringBuffer compose(String inf, String path, StringBuffer sb) {
        sb.append("tbl(" + inf + ",\"");
        sb.append(path);
        sb.append("\")");
        return sb;
    }
}

