/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.task;

import java.io.IOException;
import java.net.URI;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.io.RawComparator;
import shaded.org.apache.hadoop.mapred.JobConf;
import shaded.org.apache.hadoop.mapreduce.InputFormat;
import shaded.org.apache.hadoop.mapreduce.JobContext;
import shaded.org.apache.hadoop.mapreduce.JobID;
import shaded.org.apache.hadoop.mapreduce.Mapper;
import shaded.org.apache.hadoop.mapreduce.OutputFormat;
import shaded.org.apache.hadoop.mapreduce.Partitioner;
import shaded.org.apache.hadoop.mapreduce.Reducer;
import shaded.org.apache.hadoop.mapreduce.filecache.DistributedCache;
import shaded.org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import shaded.org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import shaded.org.apache.hadoop.mapreduce.lib.partition.HashPartitioner;
import shaded.org.apache.hadoop.security.Credentials;
import shaded.org.apache.hadoop.security.UserGroupInformation;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobContextImpl
implements JobContext {
    protected final JobConf conf;
    private JobID jobId;
    protected UserGroupInformation ugi;
    protected final Credentials credentials;

    public JobContextImpl(Configuration conf, JobID jobId) {
        this.conf = conf instanceof JobConf ? (JobConf)conf : new JobConf(conf);
        this.jobId = jobId;
        this.credentials = this.conf.getCredentials();
        try {
            this.ugi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public JobID getJobID() {
        return this.jobId;
    }

    public void setJobID(JobID jobId) {
        this.jobId = jobId;
    }

    @Override
    public int getNumReduceTasks() {
        return this.conf.getNumReduceTasks();
    }

    @Override
    public Path getWorkingDirectory() throws IOException {
        return this.conf.getWorkingDirectory();
    }

    @Override
    public Class<?> getOutputKeyClass() {
        return this.conf.getOutputKeyClass();
    }

    @Override
    public Class<?> getOutputValueClass() {
        return this.conf.getOutputValueClass();
    }

    @Override
    public Class<?> getMapOutputKeyClass() {
        return this.conf.getMapOutputKeyClass();
    }

    @Override
    public Class<?> getMapOutputValueClass() {
        return this.conf.getMapOutputValueClass();
    }

    @Override
    public String getJobName() {
        return this.conf.getJobName();
    }

    @Override
    public Class<? extends InputFormat<?, ?>> getInputFormatClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.job.inputformat.class", TextInputFormat.class);
    }

    @Override
    public Class<? extends Mapper<?, ?, ?, ?>> getMapperClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.job.map.class", Mapper.class);
    }

    @Override
    public Class<? extends Reducer<?, ?, ?, ?>> getCombinerClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.job.combine.class", null);
    }

    @Override
    public Class<? extends Reducer<?, ?, ?, ?>> getReducerClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.job.reduce.class", Reducer.class);
    }

    @Override
    public Class<? extends OutputFormat<?, ?>> getOutputFormatClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.job.outputformat.class", TextOutputFormat.class);
    }

    @Override
    public Class<? extends Partitioner<?, ?>> getPartitionerClass() throws ClassNotFoundException {
        return this.conf.getClass("mapreduce.job.partitioner.class", HashPartitioner.class);
    }

    @Override
    public RawComparator<?> getSortComparator() {
        return this.conf.getOutputKeyComparator();
    }

    @Override
    public String getJar() {
        return this.conf.getJar();
    }

    @Override
    public RawComparator<?> getCombinerKeyGroupingComparator() {
        return this.conf.getCombinerKeyGroupingComparator();
    }

    @Override
    public RawComparator<?> getGroupingComparator() {
        return this.conf.getOutputValueGroupingComparator();
    }

    @Override
    public boolean getJobSetupCleanupNeeded() {
        return this.conf.getBoolean("mapreduce.job.committer.setup.cleanup.needed", true);
    }

    @Override
    public boolean getTaskCleanupNeeded() {
        return this.conf.getBoolean("mapreduce.job.committer.task.cleanup.needed", true);
    }

    @Override
    public boolean getSymlink() {
        return DistributedCache.getSymlink(this.conf);
    }

    @Override
    public Path[] getArchiveClassPaths() {
        return DistributedCache.getArchiveClassPaths(this.conf);
    }

    @Override
    public URI[] getCacheArchives() throws IOException {
        return DistributedCache.getCacheArchives(this.conf);
    }

    @Override
    public URI[] getCacheFiles() throws IOException {
        return DistributedCache.getCacheFiles(this.conf);
    }

    @Override
    public Path[] getLocalCacheArchives() throws IOException {
        return DistributedCache.getLocalCacheArchives(this.conf);
    }

    @Override
    public Path[] getLocalCacheFiles() throws IOException {
        return DistributedCache.getLocalCacheFiles(this.conf);
    }

    @Override
    public Path[] getFileClassPaths() {
        return DistributedCache.getFileClassPaths(this.conf);
    }

    private static String[] toTimestampStrs(long[] timestamps) {
        if (timestamps == null) {
            return null;
        }
        String[] result = new String[timestamps.length];
        for (int i = 0; i < timestamps.length; ++i) {
            result[i] = Long.toString(timestamps[i]);
        }
        return result;
    }

    @Override
    public String[] getArchiveTimestamps() {
        return JobContextImpl.toTimestampStrs(DistributedCache.getArchiveTimestamps(this.conf));
    }

    @Override
    public String[] getFileTimestamps() {
        return JobContextImpl.toTimestampStrs(DistributedCache.getFileTimestamps(this.conf));
    }

    @Override
    public int getMaxMapAttempts() {
        return this.conf.getMaxMapAttempts();
    }

    @Override
    public int getMaxReduceAttempts() {
        return this.conf.getMaxReduceAttempts();
    }

    @Override
    public boolean getProfileEnabled() {
        return this.conf.getProfileEnabled();
    }

    @Override
    public String getProfileParams() {
        return this.conf.getProfileParams();
    }

    @Override
    public Configuration.IntegerRanges getProfileTaskRange(boolean isMap) {
        return this.conf.getProfileTaskRange(isMap);
    }

    @Override
    public String getUser() {
        return this.conf.getUser();
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }
}

