/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.task;

import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.mapred.Task;
import shaded.org.apache.hadoop.mapreduce.Counter;
import shaded.org.apache.hadoop.mapreduce.Counters;
import shaded.org.apache.hadoop.mapreduce.StatusReporter;
import shaded.org.apache.hadoop.mapreduce.TaskAttemptContext;
import shaded.org.apache.hadoop.mapreduce.TaskAttemptID;
import shaded.org.apache.hadoop.mapreduce.task.JobContextImpl;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class TaskAttemptContextImpl
extends JobContextImpl
implements TaskAttemptContext {
    private final TaskAttemptID taskId;
    private String status = "";
    private StatusReporter reporter;

    public TaskAttemptContextImpl(Configuration conf, TaskAttemptID taskId) {
        this(conf, taskId, new DummyReporter());
    }

    public TaskAttemptContextImpl(Configuration conf, TaskAttemptID taskId, StatusReporter reporter) {
        super(conf, taskId.getJobID());
        this.taskId = taskId;
        this.reporter = reporter;
    }

    @Override
    public TaskAttemptID getTaskAttemptID() {
        return this.taskId;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public Counter getCounter(Enum<?> counterName) {
        return this.reporter.getCounter(counterName);
    }

    @Override
    public Counter getCounter(String groupName, String counterName) {
        return this.reporter.getCounter(groupName, counterName);
    }

    @Override
    public void progress() {
        this.reporter.progress();
    }

    protected void setStatusString(String status) {
        this.status = status;
    }

    @Override
    public void setStatus(String status) {
        String normalizedStatus = Task.normalizeStatus(status, this.conf);
        this.setStatusString(normalizedStatus);
        this.reporter.setStatus(normalizedStatus);
    }

    @Override
    public float getProgress() {
        return this.reporter.getProgress();
    }

    public static class DummyReporter
    extends StatusReporter {
        @Override
        public void setStatus(String s) {
        }

        @Override
        public void progress() {
        }

        @Override
        public Counter getCounter(Enum<?> name) {
            return new Counters().findCounter(name);
        }

        @Override
        public Counter getCounter(String group, String name) {
            return new Counters().findCounter(group, name);
        }

        @Override
        public float getProgress() {
            return 0.0f;
        }
    }
}

