/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.task.reduce;

import java.util.ArrayList;
import java.util.List;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.mapreduce.TaskAttemptID;

@InterfaceAudience.LimitedPrivate(value={"MapReduce"})
@InterfaceStability.Unstable
public class MapHost {
    private State state = State.IDLE;
    private final String hostName;
    private final String baseUrl;
    private List<TaskAttemptID> maps = new ArrayList<TaskAttemptID>();

    public MapHost(String hostName, String baseUrl) {
        this.hostName = hostName;
        this.baseUrl = baseUrl;
    }

    public State getState() {
        return this.state;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public synchronized void addKnownMap(TaskAttemptID mapId) {
        this.maps.add(mapId);
        if (this.state == State.IDLE) {
            this.state = State.PENDING;
        }
    }

    public synchronized List<TaskAttemptID> getAndClearKnownMaps() {
        List<TaskAttemptID> currentKnownMaps = this.maps;
        this.maps = new ArrayList<TaskAttemptID>();
        return currentKnownMaps;
    }

    public synchronized void markBusy() {
        this.state = State.BUSY;
    }

    public synchronized int getNumKnownMapOutputs() {
        return this.maps.size();
    }

    public synchronized State markAvailable() {
        this.state = this.maps.isEmpty() ? State.IDLE : State.PENDING;
        return this.state;
    }

    public String toString() {
        return this.hostName;
    }

    public synchronized void penalize() {
        this.state = State.PENALIZED;
    }

    public static enum State {
        IDLE,
        BUSY,
        PENDING,
        PENALIZED;

    }
}

