/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.mapreduce.v2.app.webapp;

import com.google.inject.Inject;
import java.io.IOException;
import shaded.org.apache.hadoop.fs.Path;
import shaded.org.apache.hadoop.mapreduce.v2.api.records.JobId;
import shaded.org.apache.hadoop.mapreduce.v2.app.AppContext;
import shaded.org.apache.hadoop.mapreduce.v2.app.job.Job;
import shaded.org.apache.hadoop.mapreduce.v2.app.webapp.dao.ConfEntryInfo;
import shaded.org.apache.hadoop.mapreduce.v2.app.webapp.dao.ConfInfo;
import shaded.org.apache.hadoop.mapreduce.v2.util.MRApps;
import shaded.org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import shaded.org.apache.hadoop.yarn.webapp.hamlet.HamletSpec;
import shaded.org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class ConfBlock
extends HtmlBlock {
    final AppContext appContext;

    @Inject
    ConfBlock(AppContext appctx) {
        this.appContext = appctx;
    }

    protected void render(HtmlBlock.Block html) {
        String jid = this.$("job.id");
        if (jid.isEmpty()) {
            html.p()._(new Object[]{"Sorry, can't do anything without a JobID."})._();
            return;
        }
        JobId jobID = MRApps.toJobID((String)jid);
        Job job = this.appContext.getJob(jobID);
        if (job == null) {
            html.p()._(new Object[]{"Sorry, ", jid, " not found."})._();
            return;
        }
        Path confPath = job.getConfFile();
        try {
            ConfInfo info = new ConfInfo(job);
            html.div().a("/jobhistory/downloadconf/" + jid, confPath.toString())._();
            Hamlet.TBODY tbody = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#conf").thead().tr().th(".ui-state-default", "key").th(".ui-state-default", "value").th(".ui-state-default", "source chain")._())._()).tbody();
            for (ConfEntryInfo entry : info.getProperties()) {
                StringBuffer buffer = new StringBuffer();
                String[] sources = entry.getSource();
                boolean first = true;
                for (int i = sources.length - 2; i >= 0; --i) {
                    if (!first) {
                        buffer.append(" <- ");
                    }
                    first = false;
                    buffer.append(sources[i]);
                }
                tbody.tr().td(entry.getName()).td(entry.getValue()).td(buffer.toString())._();
            }
            ((Hamlet.TABLE)((Hamlet.TFOOT)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TR)((Hamlet.TH)((Hamlet.TABLE)tbody._()).tfoot().tr().th().input("search_init").$type(HamletSpec.InputType.text).$name("key").$value("key")._())._()).th().input("search_init").$type(HamletSpec.InputType.text).$name("value").$value("value")._())._()).th().input("search_init").$type(HamletSpec.InputType.text).$name("source chain").$value("source chain")._())._())._())._())._();
        }
        catch (IOException e) {
            LOG.error("Error while reading " + confPath, (Throwable)e);
            html.p()._(new Object[]{"Sorry got an error while reading conf file. ", confPath});
        }
    }
}

