/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.record.compiler;

import java.util.Map;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.record.compiler.CodeBuffer;

@Deprecated
@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class JType {
    JavaType javaType;
    CppType cppType;
    CType cType;

    static String toCamelCase(String name) {
        char firstChar = name.charAt(0);
        if (Character.isLowerCase(firstChar)) {
            return "" + Character.toUpperCase(firstChar) + name.substring(1);
        }
        return name;
    }

    abstract String getSignature();

    void setJavaType(JavaType jType) {
        this.javaType = jType;
    }

    JavaType getJavaType() {
        return this.javaType;
    }

    void setCppType(CppType cppType) {
        this.cppType = cppType;
    }

    CppType getCppType() {
        return this.cppType;
    }

    void setCType(CType cType) {
        this.cType = cType;
    }

    CType getCType() {
        return this.cType;
    }

    class CType {
        CType() {
        }
    }

    abstract class CppType {
        private String name;

        CppType(String cppname) {
            this.name = cppname;
        }

        void genDecl(CodeBuffer cb, String fname) {
            cb.append(this.name + " " + fname + ";\n");
        }

        void genStaticTypeInfo(CodeBuffer cb, String fname) {
            cb.append("p->addField(new ::std::string(\"" + fname + "\"), " + this.getTypeIDObjectString() + ");\n");
        }

        void genGetSet(CodeBuffer cb, String fname) {
            cb.append("virtual " + this.name + " get" + JType.toCamelCase(fname) + "() const {\n");
            cb.append("return " + fname + ";\n");
            cb.append("}\n");
            cb.append("virtual void set" + JType.toCamelCase(fname) + "(" + this.name + " m_) {\n");
            cb.append(fname + "=m_;\n");
            cb.append("}\n");
        }

        abstract String getTypeIDObjectString();

        void genSetRTIFilter(CodeBuffer cb) {
        }

        String getType() {
            return this.name;
        }
    }

    abstract class JavaType {
        private String name;
        private String methodSuffix;
        private String wrapper;
        private String typeIDByteString;

        JavaType(String javaname, String suffix, String wrapper, String typeIDByteString) {
            this.name = javaname;
            this.methodSuffix = suffix;
            this.wrapper = wrapper;
            this.typeIDByteString = typeIDByteString;
        }

        void genDecl(CodeBuffer cb, String fname) {
            cb.append("private " + this.name + " " + fname + ";\n");
        }

        void genStaticTypeInfo(CodeBuffer cb, String fname) {
            cb.append("_rio_recTypeInfo.addField(\"" + fname + "\", " + this.getTypeIDObjectString() + ");\n");
        }

        abstract String getTypeIDObjectString();

        void genSetRTIFilter(CodeBuffer cb, Map<String, Integer> nestedStructMap) {
        }

        void genConstructorParam(CodeBuffer cb, String fname) {
            cb.append("final " + this.name + " " + fname);
        }

        void genGetSet(CodeBuffer cb, String fname) {
            cb.append("public " + this.name + " get" + JType.toCamelCase(fname) + "() {\n");
            cb.append("return " + fname + ";\n");
            cb.append("}\n");
            cb.append("public void set" + JType.toCamelCase(fname) + "(final " + this.name + " " + fname + ") {\n");
            cb.append("this." + fname + "=" + fname + ";\n");
            cb.append("}\n");
        }

        String getType() {
            return this.name;
        }

        String getWrapperType() {
            return this.wrapper;
        }

        String getMethodSuffix() {
            return this.methodSuffix;
        }

        String getTypeIDByteString() {
            return this.typeIDByteString;
        }

        void genWriteMethod(CodeBuffer cb, String fname, String tag) {
            cb.append("_rio_a.write" + this.methodSuffix + "(" + fname + ",\"" + tag + "\");\n");
        }

        void genReadMethod(CodeBuffer cb, String fname, String tag, boolean decl) {
            if (decl) {
                cb.append(this.name + " " + fname + ";\n");
            }
            cb.append(fname + "=" + "_rio_a" + ".read" + this.methodSuffix + "(\"" + tag + "\");\n");
        }

        void genCompareTo(CodeBuffer cb, String fname, String other) {
            cb.append("_rio_ret = (" + fname + " == " + other + ")? 0 :((" + fname + "<" + other + ")?-1:1);\n");
        }

        abstract void genCompareBytes(CodeBuffer var1);

        abstract void genSlurpBytes(CodeBuffer var1, String var2, String var3, String var4);

        void genEquals(CodeBuffer cb, String fname, String peer) {
            cb.append("_rio_ret = (" + fname + "==" + peer + ");\n");
        }

        void genHashCode(CodeBuffer cb, String fname) {
            cb.append("_rio_ret = (int)" + fname + ";\n");
        }

        void genConstructorSet(CodeBuffer cb, String fname) {
            cb.append("this." + fname + " = " + fname + ";\n");
        }

        void genClone(CodeBuffer cb, String fname) {
            cb.append("_rio_other." + fname + " = this." + fname + ";\n");
        }
    }
}

