/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.security.authentication.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.security.authentication.client.AuthenticationException;
import shaded.org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import shaded.org.apache.hadoop.security.authentication.server.AuthenticationHandlerUtil;
import shaded.org.apache.hadoop.security.authentication.server.AuthenticationToken;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class LdapAuthenticationHandler
implements AuthenticationHandler {
    private static Logger logger = LoggerFactory.getLogger(LdapAuthenticationHandler.class);
    public static final String TYPE = "ldap";
    public static final String SECURITY_AUTHENTICATION = "simple";
    public static final String PROVIDER_URL = "ldap.providerurl";
    public static final String BASE_DN = "ldap.basedn";
    public static final String LDAP_BIND_DOMAIN = "ldap.binddomain";
    public static final String ENABLE_START_TLS = "ldap.enablestarttls";
    private String ldapDomain;
    private String baseDN;
    private String providerUrl;
    private Boolean enableStartTls;
    private Boolean disableHostNameVerification;

    @VisibleForTesting
    public void setEnableStartTls(Boolean enableStartTls) {
        this.enableStartTls = enableStartTls;
    }

    @VisibleForTesting
    public void setDisableHostNameVerification(Boolean disableHostNameVerification) {
        this.disableHostNameVerification = disableHostNameVerification;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void init(Properties config) throws ServletException {
        this.baseDN = config.getProperty(BASE_DN);
        this.providerUrl = config.getProperty(PROVIDER_URL);
        this.ldapDomain = config.getProperty(LDAP_BIND_DOMAIN);
        this.enableStartTls = Boolean.valueOf(config.getProperty(ENABLE_START_TLS, "false"));
        Preconditions.checkNotNull((Object)this.providerUrl, (Object)"The LDAP URI can not be null");
        Preconditions.checkArgument((boolean)(this.baseDN == null ^ this.ldapDomain == null), (Object)"Either LDAP base DN or LDAP domain value needs to be specified");
        if (this.enableStartTls.booleanValue()) {
            String tmp = this.providerUrl.toLowerCase();
            Preconditions.checkArgument((!tmp.startsWith("ldaps") ? 1 : 0) != 0, (Object)"Can not use ldaps and StartTLS option at the same time");
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public boolean managementOperation(AuthenticationToken token, HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        return true;
    }

    @Override
    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token = null;
        String authorization = request.getHeader("Authorization");
        if (authorization == null || !AuthenticationHandlerUtil.matchAuthScheme("Basic", authorization)) {
            response.setHeader("WWW-Authenticate", "Basic");
            response.setStatus(401);
            if (authorization == null) {
                logger.trace("Basic auth starting");
            } else {
                logger.warn("'Authorization' does not start with 'Basic' :  {}", (Object)authorization);
            }
        } else {
            Base64 base64 = new Base64(0);
            String[] credentials = new String(base64.decode(authorization = authorization.substring("Basic".length()).trim()), StandardCharsets.UTF_8).split(":", 2);
            if (credentials.length == 2) {
                token = this.authenticateUser(credentials[0], credentials[1]);
                response.setStatus(200);
            }
        }
        return token;
    }

    private AuthenticationToken authenticateUser(String userName, String password) throws AuthenticationException {
        if (userName == null || userName.isEmpty()) {
            throw new AuthenticationException("Error validating LDAP user: a null or blank username has been provided");
        }
        if (!LdapAuthenticationHandler.hasDomain(userName) && this.ldapDomain != null) {
            userName = userName + "@" + this.ldapDomain;
        }
        if (password == null || password.isEmpty() || password.getBytes(StandardCharsets.UTF_8)[0] == 0) {
            throw new AuthenticationException("Error validating LDAP user: a null or blank password has been provided");
        }
        String bindDN = this.baseDN == null ? userName : "uid=" + userName + "," + this.baseDN;
        if (this.enableStartTls.booleanValue()) {
            this.authenticateWithTlsExtension(bindDN, password);
        } else {
            this.authenticateWithoutTlsExtension(bindDN, password);
        }
        return new AuthenticationToken(userName, userName, TYPE);
    }

    private void authenticateWithTlsExtension(String userDN, String password) throws AuthenticationException {
        InitialLdapContext ctx = null;
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.providerUrl);
        try {
            ctx = new InitialLdapContext(env, null);
            StartTlsResponse tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
            if (this.disableHostNameVerification.booleanValue()) {
                tls.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            tls.negotiate();
            ctx.addToEnvironment("java.naming.security.authentication", SECURITY_AUTHENTICATION);
            ctx.addToEnvironment("java.naming.security.principal", userDN);
            ctx.addToEnvironment("java.naming.security.credentials", password);
            ctx.lookup(userDN);
            logger.debug("Authentication successful for {}", (Object)userDN);
        }
        catch (IOException | NamingException ex) {
            throw new AuthenticationException("Error validating LDAP user", ex);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    private void authenticateWithoutTlsExtension(String userDN, String password) throws AuthenticationException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.providerUrl);
        env.put("java.naming.security.authentication", SECURITY_AUTHENTICATION);
        env.put("java.naming.security.principal", userDN);
        env.put("java.naming.security.credentials", password);
        try {
            InitialDirContext ctx = new InitialDirContext(env);
            ctx.close();
            logger.debug("Authentication successful for {}", (Object)userDN);
        }
        catch (NamingException e) {
            throw new AuthenticationException("Error validating LDAP user", e);
        }
    }

    private static boolean hasDomain(String userName) {
        return LdapAuthenticationHandler.indexOfDomainMatch(userName) > 0;
    }

    private static int indexOfDomainMatch(String userName) {
        int idx2;
        if (userName == null) {
            return -1;
        }
        int idx = userName.indexOf(47);
        int endIdx = Math.min(idx, idx2 = userName.indexOf(64));
        if (endIdx == -1) {
            endIdx = Math.max(idx, idx2);
        }
        return endIdx;
    }
}

