/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.security.ssl;

import java.io.IOException;
import java.util.ArrayList;
import javax.net.ssl.SSLEngine;
import org.mortbay.jetty.security.SslSelectChannelConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.hadoop.classification.InterfaceAudience;

@InterfaceAudience.Private
public class SslSelectChannelConnectorSecure
extends SslSelectChannelConnector {
    public static final Logger LOG = LoggerFactory.getLogger(SslSelectChannelConnectorSecure.class);

    protected SSLEngine createSSLEngine() throws IOException {
        SSLEngine engine = super.createSSLEngine();
        ArrayList<String> nonSSLProtocols = new ArrayList<String>();
        for (String p : engine.getEnabledProtocols()) {
            if (p.contains("SSLv3")) continue;
            nonSSLProtocols.add(p);
        }
        engine.setEnabledProtocols(nonSSLProtocols.toArray(new String[nonSSLProtocols.size()]));
        return engine;
    }

    public boolean isRunning() {
        if (super.isRunning()) {
            return true;
        }
        LOG.warn("HttpServer Acceptor: isRunning is false. Rechecking.");
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        boolean runState = super.isRunning();
        LOG.warn("HttpServer Acceptor: isRunning is " + runState);
        return runState;
    }
}

