/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import shaded.org.apache.hadoop.util.DiskChecker;
import shaded.org.apache.hadoop.util.DiskValidator;
import shaded.org.apache.hadoop.util.ReadWriteDiskValidatorMetrics;

public class ReadWriteDiskValidator
implements DiskValidator {
    public static final String NAME = "read-write";
    private static final Random RANDOM = new Random();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkStatus(File dir) throws DiskChecker.DiskErrorException {
        ReadWriteDiskValidatorMetrics metric = ReadWriteDiskValidatorMetrics.getMetric(dir.toString());
        Path tmpFile = null;
        try {
            if (!dir.isDirectory()) {
                metric.diskCheckFailed();
                throw new DiskChecker.DiskErrorException(dir + " is not a directory!");
            }
            DiskChecker.checkDir(dir);
            tmpFile = Files.createTempFile(dir.toPath(), "test", "tmp", new FileAttribute[0]);
            byte[] inputBytes = new byte[16];
            RANDOM.nextBytes(inputBytes);
            long startTime = System.nanoTime();
            Files.write(tmpFile, inputBytes, new OpenOption[0]);
            long writeLatency = TimeUnit.MICROSECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
            metric.addWriteFileLatency(writeLatency);
            startTime = System.nanoTime();
            byte[] outputBytes = Files.readAllBytes(tmpFile);
            long readLatency = TimeUnit.MICROSECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
            metric.addReadFileLatency(readLatency);
            if (!Arrays.equals(inputBytes, outputBytes)) {
                metric.diskCheckFailed();
                throw new DiskChecker.DiskErrorException("Data in file has been corrupted.");
            }
            if (tmpFile == null) return;
        }
        catch (IOException e) {
            try {
                metric.diskCheckFailed();
                throw new DiskChecker.DiskErrorException("Disk Check failed!", e);
            }
            catch (Throwable throwable) {
                if (tmpFile == null) throw throwable;
                try {
                    Files.delete(tmpFile);
                    throw throwable;
                }
                catch (IOException e2) {
                    metric.diskCheckFailed();
                    throw new DiskChecker.DiskErrorException("File deletion failed!", e2);
                }
            }
        }
        try {
            Files.delete(tmpFile);
            return;
        }
        catch (IOException e) {
            metric.diskCheckFailed();
            throw new DiskChecker.DiskErrorException("File deletion failed!", e);
        }
    }
}

