/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.yarn.api.records;

import java.util.Map;
import java.util.Set;
import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import shaded.org.apache.hadoop.yarn.api.records.ApplicationId;
import shaded.org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import shaded.org.apache.hadoop.yarn.api.records.ApplicationTimeout;
import shaded.org.apache.hadoop.yarn.api.records.ApplicationTimeoutType;
import shaded.org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import shaded.org.apache.hadoop.yarn.api.records.LogAggregationStatus;
import shaded.org.apache.hadoop.yarn.api.records.Priority;
import shaded.org.apache.hadoop.yarn.api.records.Token;
import shaded.org.apache.hadoop.yarn.api.records.YarnApplicationState;
import shaded.org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ApplicationReport {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ApplicationReport newInstance(ApplicationId applicationId, ApplicationAttemptId applicationAttemptId, String user, String queue, String name, String host, int rpcPort, Token clientToAMToken, YarnApplicationState state, String diagnostics, String url, long startTime, long launchTime, long finishTime, FinalApplicationStatus finalStatus, ApplicationResourceUsageReport appResources, String origTrackingUrl, float progress, String applicationType, Token amRmToken) {
        return ApplicationReport.newInstance(applicationId, applicationAttemptId, user, queue, name, host, rpcPort, clientToAMToken, state, diagnostics, url, startTime, startTime, launchTime, finishTime, finalStatus, appResources, origTrackingUrl, progress, applicationType, amRmToken);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ApplicationReport newInstance(ApplicationId applicationId, ApplicationAttemptId applicationAttemptId, String user, String queue, String name, String host, int rpcPort, Token clientToAMToken, YarnApplicationState state, String diagnostics, String url, long startTime, long submitTime, long launchTime, long finishTime, FinalApplicationStatus finalStatus, ApplicationResourceUsageReport appResources, String origTrackingUrl, float progress, String applicationType, Token amRmToken) {
        ApplicationReport report = Records.newRecord(ApplicationReport.class);
        report.setApplicationId(applicationId);
        report.setCurrentApplicationAttemptId(applicationAttemptId);
        report.setUser(user);
        report.setQueue(queue);
        report.setName(name);
        report.setHost(host);
        report.setRpcPort(rpcPort);
        report.setClientToAMToken(clientToAMToken);
        report.setYarnApplicationState(state);
        report.setDiagnostics(diagnostics);
        report.setTrackingUrl(url);
        report.setStartTime(startTime);
        report.setSubmitTime(submitTime);
        report.setLaunchTime(launchTime);
        report.setFinishTime(finishTime);
        report.setFinalApplicationStatus(finalStatus);
        report.setApplicationResourceUsageReport(appResources);
        report.setOriginalTrackingUrl(origTrackingUrl);
        report.setProgress(progress);
        report.setApplicationType(applicationType);
        report.setAMRMToken(amRmToken);
        return report;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ApplicationReport newInstance(ApplicationId applicationId, ApplicationAttemptId applicationAttemptId, String user, String queue, String name, String host, int rpcPort, Token clientToAMToken, YarnApplicationState state, String diagnostics, String url, long startTime, long finishTime, FinalApplicationStatus finalStatus, ApplicationResourceUsageReport appResources, String origTrackingUrl, float progress, String applicationType, Token amRmToken, Set<String> tags, boolean unmanagedApplication, Priority priority, String appNodeLabelExpression, String amNodeLabelExpression) {
        ApplicationReport report = ApplicationReport.newInstance(applicationId, applicationAttemptId, user, queue, name, host, rpcPort, clientToAMToken, state, diagnostics, url, startTime, 0L, 0L, finishTime, finalStatus, appResources, origTrackingUrl, progress, applicationType, amRmToken);
        report.setApplicationTags(tags);
        report.setUnmanagedApp(unmanagedApplication);
        report.setPriority(priority);
        report.setAppNodeLabelExpression(appNodeLabelExpression);
        report.setAmNodeLabelExpression(amNodeLabelExpression);
        return report;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ApplicationReport newInstance(ApplicationId applicationId, ApplicationAttemptId applicationAttemptId, String user, String queue, String name, String host, int rpcPort, Token clientToAMToken, YarnApplicationState state, String diagnostics, String url, long startTime, long launchTime, long finishTime, FinalApplicationStatus finalStatus, ApplicationResourceUsageReport appResources, String origTrackingUrl, float progress, String applicationType, Token amRmToken, Set<String> tags, boolean unmanagedApplication, Priority priority, String appNodeLabelExpression, String amNodeLabelExpression) {
        return ApplicationReport.newInstance(applicationId, applicationAttemptId, user, queue, name, host, rpcPort, clientToAMToken, state, diagnostics, url, startTime, startTime, launchTime, finishTime, finalStatus, appResources, origTrackingUrl, progress, applicationType, amRmToken, tags, unmanagedApplication, priority, appNodeLabelExpression, amNodeLabelExpression);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ApplicationReport newInstance(ApplicationId applicationId, ApplicationAttemptId applicationAttemptId, String user, String queue, String name, String host, int rpcPort, Token clientToAMToken, YarnApplicationState state, String diagnostics, String url, long startTime, long submitTime, long launchTime, long finishTime, FinalApplicationStatus finalStatus, ApplicationResourceUsageReport appResources, String origTrackingUrl, float progress, String applicationType, Token amRmToken, Set<String> tags, boolean unmanagedApplication, Priority priority, String appNodeLabelExpression, String amNodeLabelExpression) {
        ApplicationReport report = ApplicationReport.newInstance(applicationId, applicationAttemptId, user, queue, name, host, rpcPort, clientToAMToken, state, diagnostics, url, startTime, submitTime, launchTime, finishTime, finalStatus, appResources, origTrackingUrl, progress, applicationType, amRmToken);
        report.setApplicationTags(tags);
        report.setUnmanagedApp(unmanagedApplication);
        report.setPriority(priority);
        report.setAppNodeLabelExpression(appNodeLabelExpression);
        report.setAmNodeLabelExpression(amNodeLabelExpression);
        return report;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ApplicationId getApplicationId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplicationId(ApplicationId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ApplicationAttemptId getCurrentApplicationAttemptId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setCurrentApplicationAttemptId(ApplicationAttemptId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getUser();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setUser(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getQueue();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setQueue(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getName();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setName(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getHost();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setHost(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getRpcPort();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setRpcPort(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Token getClientToAMToken();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setClientToAMToken(Token var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract YarnApplicationState getYarnApplicationState();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setYarnApplicationState(YarnApplicationState var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getDiagnostics();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setDiagnostics(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getTrackingUrl();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setTrackingUrl(String var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract String getOriginalTrackingUrl();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setOriginalTrackingUrl(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract long getStartTime();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setStartTime(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract long getSubmitTime();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setSubmitTime(long var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setLaunchTime(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getLaunchTime();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract long getFinishTime();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setFinishTime(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract FinalApplicationStatus getFinalApplicationStatus();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setFinalApplicationStatus(FinalApplicationStatus var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ApplicationResourceUsageReport getApplicationResourceUsageReport();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplicationResourceUsageReport(ApplicationResourceUsageReport var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract float getProgress();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setProgress(float var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getApplicationType();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplicationType(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Set<String> getApplicationTags();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplicationTags(Set<String> var1);

    @InterfaceAudience.Private
    @InterfaceStability.Stable
    public abstract void setAMRMToken(Token var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Token getAMRMToken();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract LogAggregationStatus getLogAggregationStatus();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setLogAggregationStatus(LogAggregationStatus var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract boolean isUnmanagedApp();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setUnmanagedApp(boolean var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Priority getPriority();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setPriority(Priority var1);

    @InterfaceStability.Unstable
    public abstract String getAppNodeLabelExpression();

    @InterfaceStability.Unstable
    public abstract void setAppNodeLabelExpression(String var1);

    @InterfaceStability.Unstable
    public abstract String getAmNodeLabelExpression();

    @InterfaceStability.Unstable
    public abstract void setAmNodeLabelExpression(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract Map<ApplicationTimeoutType, ApplicationTimeout> getApplicationTimeouts();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setApplicationTimeouts(Map<ApplicationTimeoutType, ApplicationTimeout> var1);
}

