/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.hadoop.yarn.api.records;

import shaded.org.apache.hadoop.classification.InterfaceAudience;
import shaded.org.apache.hadoop.classification.InterfaceStability;
import shaded.org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class ResourceUtilization
implements Comparable<ResourceUtilization> {
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ResourceUtilization newInstance(int pmem, int vmem, float cpu) {
        ResourceUtilization utilization = Records.newRecord(ResourceUtilization.class);
        utilization.setPhysicalMemory(pmem);
        utilization.setVirtualMemory(vmem);
        utilization.setCPU(cpu);
        return utilization;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ResourceUtilization newInstance(ResourceUtilization resourceUtil) {
        return ResourceUtilization.newInstance(resourceUtil.getPhysicalMemory(), resourceUtil.getVirtualMemory(), resourceUtil.getCPU());
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int getVirtualMemory();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setVirtualMemory(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract int getPhysicalMemory();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setPhysicalMemory(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract float getCPU();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setCPU(float var1);

    public int hashCode() {
        int prime = 263167;
        int result = 3571;
        result = 263167 * result + this.getVirtualMemory();
        result = 263167 * result + this.getPhysicalMemory();
        result = 31 * result + Float.valueOf(this.getCPU()).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceUtilization)) {
            return false;
        }
        ResourceUtilization other = (ResourceUtilization)obj;
        return this.getVirtualMemory() == other.getVirtualMemory() && this.getPhysicalMemory() == other.getPhysicalMemory() && this.getCPU() == other.getCPU();
    }

    public String toString() {
        return "<pmem:" + this.getPhysicalMemory() + ", vmem:" + this.getVirtualMemory() + ", vCores:" + this.getCPU() + ">";
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public void addTo(int pmem, int vmem, float cpu) {
        this.setPhysicalMemory(this.getPhysicalMemory() + pmem);
        this.setVirtualMemory(this.getVirtualMemory() + vmem);
        this.setCPU(this.getCPU() + cpu);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public void subtractFrom(int pmem, int vmem, float cpu) {
        this.setPhysicalMemory(this.getPhysicalMemory() - pmem);
        this.setVirtualMemory(this.getVirtualMemory() - vmem);
        this.setCPU(this.getCPU() - cpu);
    }
}

