/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.config;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import mx4j.tools.config.ConfigurationBuilder;
import mx4j.tools.config.ConfigurationException;
import mx4j.tools.config.ConfigurationLoaderMBean;
import mx4j.tools.config.DefaultConfigurationBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ConfigurationLoader
implements ConfigurationLoaderMBean,
MBeanRegistration {
    private MBeanServer server;
    private ConfigurationBuilder builder;
    private ConfigurationBuilder.Node root;

    public ConfigurationLoader() {
        this(null, new DefaultConfigurationBuilder());
    }

    public ConfigurationLoader(ConfigurationBuilder builder) {
        this(null, builder);
    }

    public ConfigurationLoader(MBeanServer server) {
        this(server, new DefaultConfigurationBuilder());
    }

    public ConfigurationLoader(MBeanServer server, ConfigurationBuilder builder) {
        this.server = server;
        if (builder == null) {
            throw new IllegalArgumentException("ConfigurationBuilder cannot be null");
        }
        this.builder = builder;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registered) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void startup(Reader source) throws ConfigurationException {
        if (this.server == null) {
            throw new ConfigurationException("Cannot startup the configuration, MBeanServer is not specified");
        }
        try {
            DocumentBuilderFactory documentFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentFactory.newDocumentBuilder();
            InputSource src = new InputSource(source);
            Document document = documentBuilder.parse(src);
            Element xmlRoot = document.getDocumentElement();
            this.root = this.builder.createConfigurationNode(xmlRoot);
            this.parse(xmlRoot, this.root);
            this.root.configure(this.server);
        }
        catch (ConfigurationException x) {
            throw x;
        }
        catch (Exception x) {
            throw new ConfigurationException(x);
        }
    }

    @Override
    public void shutdown() throws ConfigurationException {
        this.root.configure(null);
    }

    private void parse(Element xmlNode, ConfigurationBuilder.Node node) throws ConfigurationException {
        List elements;
        NamedNodeMap attributes = xmlNode.getAttributes();
        if (attributes != null && attributes.getLength() > 0) {
            node.setAttributes(attributes);
        }
        if ((elements = this.getChildrenElements(xmlNode)) != null) {
            for (int i = 0; i < elements.size(); ++i) {
                Element xmlChild = (Element)elements.get(i);
                ConfigurationBuilder.Node child = this.builder.createConfigurationNode(xmlChild);
                node.addChild(child);
                this.parse(xmlChild, child);
            }
        }
        String value = this.getNodeValue(xmlNode);
        node.setText(value);
    }

    private List getChildrenElements(Element xmlNode) {
        NodeList xmlChildren = xmlNode.getChildNodes();
        if (xmlChildren == null) {
            return null;
        }
        ArrayList<Node> children = new ArrayList<Node>();
        for (int i = 0; i < xmlChildren.getLength(); ++i) {
            Node xmlChild = xmlChildren.item(i);
            if (xmlChild.getNodeType() != 1) continue;
            children.add(xmlChild);
        }
        return children;
    }

    private String getNodeValue(Element xmlNode) {
        NodeList xmlChildren = xmlNode.getChildNodes();
        if (xmlChildren == null) {
            return null;
        }
        for (int i = 0; i < xmlChildren.getLength(); ++i) {
            Node xmlChild = xmlChildren.item(i);
            if (xmlChild.getNodeType() != 3) continue;
            return xmlChild.getNodeValue();
        }
        return null;
    }
}

