/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.soap.axis.ser;

import java.io.IOException;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import mx4j.tools.remote.soap.axis.ser.AxisSerializer;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.wsdl.fromJava.Types;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class SubjectSer
extends AxisSerializer {
    static final String TYPE = "Subject";
    static final String READ_ONLY = "readOnly";
    static final String PRINCIPALS = "principals";
    static final String PUBLIC_CREDENTIALS = "publicCredentials";
    static final String PRIVATE_CREDENTIALS = "privateCredentials";
    private static final QName READ_ONLY_QNAME = new QName("", "readOnly");
    private static final QName PRINCIPALS_QNAME = new QName("", "principals");
    private static final QName PUBLIC_CREDENTIALS_QNAME = new QName("", "publicCredentials");
    private static final QName PRIVATE_CREDENTIALS_QNAME = new QName("", "privateCredentials");

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        Subject subject = (Subject)value;
        context.startElement(name, attributes);
        context.serialize(READ_ONLY_QNAME, null, (Object)new Boolean(subject.isReadOnly()));
        context.serialize(PRINCIPALS_QNAME, null, subject.getPrincipals());
        context.serialize(PUBLIC_CREDENTIALS_QNAME, null, subject.getPublicCredentials());
        context.serialize(PRIVATE_CREDENTIALS_QNAME, null, subject.getPrivateCredentials());
        context.endElement();
    }

    @Override
    public Element writeSchema(Class aClass, Types types) throws Exception {
        Element complexType = types.createElement("complexType");
        complexType.setAttribute("name", TYPE);
        Element allElement = types.createElement("all");
        complexType.appendChild(allElement);
        Element readOnlyElement = types.createElement("element");
        readOnlyElement.setAttribute("name", READ_ONLY);
        readOnlyElement.setAttribute("type", XMLType.XSD_BOOLEAN.getLocalPart());
        allElement.appendChild(readOnlyElement);
        Element principalsElement = types.createElement("element");
        principalsElement.setAttribute("name", PRINCIPALS);
        principalsElement.setAttribute("type", "Set");
        allElement.appendChild(principalsElement);
        Element publicCredentialsElement = types.createElement("element");
        publicCredentialsElement.setAttribute("name", PUBLIC_CREDENTIALS);
        publicCredentialsElement.setAttribute("type", "Set");
        allElement.appendChild(publicCredentialsElement);
        Element privateCredentialsElement = types.createElement("element");
        privateCredentialsElement.setAttribute("name", PRIVATE_CREDENTIALS);
        privateCredentialsElement.setAttribute("type", "Set");
        allElement.appendChild(privateCredentialsElement);
        return complexType;
    }
}

