/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.dataimport.nodel;

import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.nobject.Nobject;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class CrossTabInfo
extends Nobject {
    private boolean isCrossTab = false;
    private boolean hasHeaders = false;
    private int dimensionRows = 0;
    private int dimensionColumns = 0;
    private int startAt = 0;
    private int startDataX = 0;
    private int startDataY = 0;
    private int numColumns = 0;

    public CrossTabInfo(boolean isCrossTab, boolean hasHeaders, int dimensionRows, int dimensionColumns, int startAt, int numColumns, int startDataX, int startDataY) {
        this.isCrossTab = isCrossTab;
        this.hasHeaders = hasHeaders;
        this.dimensionRows = dimensionRows;
        this.dimensionColumns = dimensionColumns;
        this.startAt = startAt;
        this.startDataX = startDataX;
        this.startDataY = startDataY;
        this.numColumns = numColumns;
    }

    public CrossTabInfo() {
    }

    public void encodeION(IONObject ionObj) {
        super.encodeION(ionObj);
        ionObj.put((Object)"start-data-X", (Object)this.startDataX);
        ionObj.put((Object)"start-data-Y", (Object)this.startDataY);
        ionObj.put((Object)"has-isCrossTab", (Object)this.isCrossTab);
        ionObj.put((Object)"has-labels", (Object)this.hasHeaders);
        ionObj.put((Object)"num-columns", (Object)this.numColumns);
        ionObj.put((Object)"num-dimensionRows", (Object)this.dimensionRows);
        ionObj.put((Object)"num-dimensionColumns", (Object)this.dimensionColumns);
        ionObj.put((Object)"num-startAt", (Object)this.startAt);
    }

    public void decodeION(IONObject ionObj) {
        super.decodeION(ionObj);
        this.startDataX = ionObj.getInt("start-data-X", 0);
        this.startDataY = ionObj.getInt("start-data-Y", 0);
        this.isCrossTab = ionObj.getBoolean("has-isCrossTab", false);
        this.hasHeaders = ionObj.getBoolean("has-labels", false);
        this.numColumns = ionObj.getInt("num-columns", 0);
        this.dimensionRows = ionObj.getInt("num-dimensionRows", 0);
        this.dimensionColumns = ionObj.getInt("num-dimensionColumns", 0);
        this.startAt = ionObj.getInt("num-startAt", 0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CrossTabInfo)) {
            return false;
        }
        CrossTabInfo other = (CrossTabInfo)((Object)o);
        return new EqualsBuilder().appendSuper(super.equals((Object)other)).append(this.isCrossTab(), other.isCrossTab()).append(this.hasLabels(), other.hasLabels()).append(this.getColumnCount(), other.getColumnCount()).append(this.getStartDataX(), other.getStartDataX()).append(this.getStartDataY(), other.getStartDataY()).append(this.getDimensionRowCount(), other.getDimensionRowCount()).append(this.getDimensionColumnCount(), other.getDimensionColumnCount()).append(this.getStartRow(), other.getStartRow()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.isCrossTab()).append(this.hasLabels()).append(this.getColumnCount()).append(this.getStartDataX()).append(this.getStartDataY()).append(this.getDimensionRowCount()).append(this.getDimensionColumnCount()).append(this.getStartRow()).toHashCode();
    }

    public boolean isCrossTab() {
        return this.isCrossTab;
    }

    public boolean hasLabels() {
        return this.hasHeaders;
    }

    public int getDimensionRowCount() {
        return this.dimensionRows;
    }

    public int getDimensionColumnCount() {
        return this.dimensionColumns;
    }

    public int getStartRow() {
        return this.startAt;
    }

    public int getStartDataX() {
        return this.startDataX;
    }

    public int getStartDataY() {
        return this.startDataY;
    }

    public int getColumnCount() {
        return this.numColumns;
    }
}

